/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.core;

import java.util.HashMap;
import java.util.LinkedHashMap;

public final class MonitorProvider {
    private static final String MAIN_MONITOR = "mainMonitor";
    private final Object monitor;
    private final HashMap<String, Object> monitors = new LinkedHashMap<String, Object>();

    public static MonitorProvider getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private MonitorProvider() {
        this.monitor = new Object();
        this.monitors.put(MAIN_MONITOR, this.monitor);
    }

    public synchronized Object getMonitor() {
        return this.monitor;
    }

    public synchronized Object getMonitor(String namespace) {
        if (!this.monitors.containsKey(namespace)) {
            this.monitors.put(namespace, new Object());
        }
        return this.monitors.get(namespace);
    }

    public synchronized boolean removeMonitor(String namespace) {
        if (namespace.endsWith(MAIN_MONITOR)) {
            return false;
        }
        return this.monitors.remove(namespace) != null;
    }

    /* synthetic */ MonitorProvider(MonitorProvider monitorProvider) {
        this();
    }

    private static class SingletonHolder {
        public static final MonitorProvider INSTANCE = new MonitorProvider(null);

        private SingletonHolder() {
        }
    }
}

