/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.connection.xmlrpc;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.emfstore.internal.common.APIUtil;
import org.eclipse.emf.emfstore.internal.common.model.EMFStoreProperty;
import org.eclipse.emf.emfstore.internal.common.model.Project;
import org.eclipse.emf.emfstore.internal.server.EMFStore;
import org.eclipse.emf.emfstore.internal.server.accesscontrol.AccessControl;
import org.eclipse.emf.emfstore.internal.server.connection.xmlrpc.XmlRpcConnectionHandler;
import org.eclipse.emf.emfstore.internal.server.connection.xmlrpc.util.ShareProjectAdapter;
import org.eclipse.emf.emfstore.internal.server.exceptions.AccessControlException;
import org.eclipse.emf.emfstore.internal.server.exceptions.InvalidVersionSpecException;
import org.eclipse.emf.emfstore.internal.server.filetransfer.FileChunk;
import org.eclipse.emf.emfstore.internal.server.filetransfer.FileTransferInformation;
import org.eclipse.emf.emfstore.internal.server.model.AuthenticationInformation;
import org.eclipse.emf.emfstore.internal.server.model.ClientVersionInfo;
import org.eclipse.emf.emfstore.internal.server.model.ProjectHistory;
import org.eclipse.emf.emfstore.internal.server.model.ProjectId;
import org.eclipse.emf.emfstore.internal.server.model.ProjectInfo;
import org.eclipse.emf.emfstore.internal.server.model.SessionId;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACOrgUnitId;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACUser;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.OrgUnitProperty;
import org.eclipse.emf.emfstore.internal.server.model.impl.api.ESAuthenticationInformationImpl;
import org.eclipse.emf.emfstore.internal.server.model.versioning.AbstractChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.BranchInfo;
import org.eclipse.emf.emfstore.internal.server.model.versioning.BranchVersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.ChangePackageEnvelope;
import org.eclipse.emf.emfstore.internal.server.model.versioning.HistoryInfo;
import org.eclipse.emf.emfstore.internal.server.model.versioning.HistoryQuery;
import org.eclipse.emf.emfstore.internal.server.model.versioning.LogMessage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.PrimaryVersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.TagVersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.VersionSpec;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.eclipse.emf.emfstore.server.model.ESAuthenticationInformation;
import org.eclipse.emf.emfstore.server.model.ESClientVersionInfo;
import org.eclipse.emf.emfstore.server.model.ESSessionId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlRpcEmfStoreImpl
implements EMFStore {
    private EMFStore getEmfStore() {
        return XmlRpcConnectionHandler.getEmfStore();
    }

    private AccessControl getAccessControl() {
        return XmlRpcConnectionHandler.getAccessControl();
    }

    public AuthenticationInformation logIn(String username, String password, ClientVersionInfo clientVersionInfo) throws AccessControlException {
        ESAuthenticationInformation authInfo = this.getAccessControl().getLoginService().logIn(username, password, (ESClientVersionInfo)clientVersionInfo.toAPI());
        return (AuthenticationInformation)((ESAuthenticationInformationImpl)ESAuthenticationInformationImpl.class.cast(authInfo)).toInternalAPI();
    }

    public void logout(SessionId sessionId) throws AccessControlException {
        this.getAccessControl().getLoginService().logout((ESSessionId)sessionId.toAPI());
    }

    @Override
    public void addTag(SessionId sessionId, ProjectId projectId, PrimaryVersionSpec versionSpec, TagVersionSpec tag) throws ESException {
        this.getEmfStore().addTag(sessionId, projectId, versionSpec, tag);
    }

    @Override
    public ProjectInfo createEmptyProject(SessionId sessionId, String name, String description, LogMessage logMessage) throws ESException {
        ProjectInfo projectInfo = this.getEmfStore().createEmptyProject(sessionId, name, description, logMessage);
        ESSessionId resolvedSession = this.getAccessControl().getSessions().resolveSessionById(sessionId.getId());
        SessionId session = (SessionId)APIUtil.toInternal(SessionId.class, (Object)resolvedSession);
        ShareProjectAdapter.attachTo(session, projectInfo.getProjectId());
        return projectInfo;
    }

    @Override
    public ProjectInfo createProject(SessionId sessionId, String name, String description, LogMessage logMessage, Project project) throws ESException {
        ProjectInfo projectInfo = this.getEmfStore().createProject(sessionId, name, description, logMessage, project);
        ESSessionId resolvedSession = this.getAccessControl().getSessions().resolveSessionById(sessionId.getId());
        SessionId session = (SessionId)APIUtil.toInternal(SessionId.class, (Object)resolvedSession);
        ShareProjectAdapter.attachTo(session, projectInfo.getProjectId());
        return projectInfo;
    }

    @Override
    public PrimaryVersionSpec createVersion(SessionId sessionId, ProjectId projectId, PrimaryVersionSpec baseVersionSpec, AbstractChangePackage changePackage, BranchVersionSpec targetBranch, PrimaryVersionSpec sourceVersion, LogMessage logMessage) throws ESException, InvalidVersionSpecException {
        return this.getEmfStore().createVersion(sessionId, projectId, baseVersionSpec, changePackage, targetBranch, sourceVersion, logMessage);
    }

    @Override
    public void deleteProject(SessionId sessionId, ProjectId projectId, boolean deleteFiles) throws ESException {
        this.getEmfStore().deleteProject(sessionId, projectId, deleteFiles);
    }

    @Override
    public FileChunk downloadFileChunk(SessionId sessionId, ProjectId projectId, FileTransferInformation fileInformation) throws ESException {
        return this.getEmfStore().downloadFileChunk(sessionId, projectId, fileInformation);
    }

    @Override
    public ProjectHistory exportProjectHistoryFromServer(SessionId sessionId, ProjectId projectId) throws ESException {
        return this.getEmfStore().exportProjectHistoryFromServer(sessionId, projectId);
    }

    @Override
    public List<AbstractChangePackage> getChanges(SessionId sessionId, ProjectId projectId, VersionSpec source, VersionSpec target) throws ESException {
        return this.getEmfStore().getChanges(sessionId, projectId, source, target);
    }

    @Override
    public List<BranchInfo> getBranches(SessionId sessionId, ProjectId projectId) throws ESException {
        return this.getEmfStore().getBranches(sessionId, projectId);
    }

    @Override
    public List<HistoryInfo> getHistoryInfo(SessionId sessionId, ProjectId projectId, HistoryQuery<?> historyQuery) throws ESException {
        return this.getEmfStore().getHistoryInfo(sessionId, projectId, historyQuery);
    }

    @Override
    public Project getProject(SessionId sessionId, ProjectId projectId, VersionSpec versionSpec) throws ESException {
        return this.getEmfStore().getProject(sessionId, projectId, versionSpec);
    }

    @Override
    public List<ProjectInfo> getProjectList(SessionId sessionId) throws ESException {
        return this.getEmfStore().getProjectList(sessionId);
    }

    @Override
    public ProjectId importProjectHistoryToServer(SessionId sessionId, ProjectHistory projectHistory) throws ESException {
        return this.getEmfStore().importProjectHistoryToServer(sessionId, projectHistory);
    }

    @Override
    public void removeTag(SessionId sessionId, ProjectId projectId, PrimaryVersionSpec versionSpec, TagVersionSpec tag) throws ESException {
        this.getEmfStore().removeTag(sessionId, projectId, versionSpec, tag);
    }

    @Override
    public ACUser resolveUser(SessionId sessionId, ACOrgUnitId id) throws ESException {
        return this.getEmfStore().resolveUser(sessionId, id);
    }

    @Override
    public PrimaryVersionSpec resolveVersionSpec(SessionId sessionId, ProjectId projectId, VersionSpec versionSpec) throws ESException {
        return this.getEmfStore().resolveVersionSpec(sessionId, projectId, versionSpec);
    }

    @Override
    public void transmitProperty(SessionId sessionId, OrgUnitProperty changedProperty, ACUser tmpUser, ProjectId projectId) throws ESException {
        this.getEmfStore().transmitProperty(sessionId, changedProperty, tmpUser, projectId);
    }

    @Override
    public FileTransferInformation uploadFileChunk(SessionId sessionId, ProjectId projectId, FileChunk fileChunk) throws ESException {
        return this.getEmfStore().uploadFileChunk(sessionId, projectId, fileChunk);
    }

    @Override
    public List<EMFStoreProperty> setEMFProperties(SessionId sessionId, List<EMFStoreProperty> properties, ProjectId projectId) throws ESException {
        if (properties != null && properties.size() > 0) {
            return this.getEmfStore().setEMFProperties(sessionId, properties, projectId);
        }
        return new ArrayList<EMFStoreProperty>();
    }

    @Override
    public List<EMFStoreProperty> getEMFProperties(SessionId sessionId, ProjectId projectId) throws ESException {
        return this.getEmfStore().getEMFProperties(sessionId, projectId);
    }

    @Override
    public void registerEPackage(SessionId sessionId, EPackage pkg) throws ESException {
        this.getEmfStore().registerEPackage(sessionId, pkg);
    }

    @Override
    public String getVersion(SessionId sessionId) throws ESException {
        return this.getEmfStore().getVersion(sessionId);
    }

    @Override
    public String uploadChangePackageFragment(SessionId sessionId, ProjectId projectId, ChangePackageEnvelope envelope) throws ESException {
        return this.getEmfStore().uploadChangePackageFragment(sessionId, projectId, envelope);
    }

    @Override
    public ChangePackageEnvelope downloadChangePackageFragment(SessionId sessionId, String proxyId, int fragmentIndex) throws ESException {
        return this.getEmfStore().downloadChangePackageFragment(sessionId, proxyId, fragmentIndex);
    }
}

