/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.modelmutator.mutation;

import com.google.common.base.Predicate;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.emfstore.internal.modelmutator.mutation.ContainmentChangeMutation;
import org.eclipse.emf.emfstore.internal.modelmutator.mutation.Messages;
import org.eclipse.emf.emfstore.internal.modelmutator.mutation.Mutation;
import org.eclipse.emf.emfstore.internal.modelmutator.mutation.MutationPredicates;
import org.eclipse.emf.emfstore.internal.modelmutator.mutation.MutationTargetSelector;
import org.eclipse.emf.emfstore.modelmutator.ESDeleteObjectMutation;
import org.eclipse.emf.emfstore.modelmutator.ESModelMutatorUtil;
import org.eclipse.emf.emfstore.modelmutator.ESMutationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteObjectMutation
extends ContainmentChangeMutation<ESDeleteObjectMutation>
implements ESDeleteObjectMutation {
    private int maxNumberOfContainments;
    private EObject eObjectToDelete;

    public DeleteObjectMutation(ESModelMutatorUtil util) {
        super(util);
        this.addHasObjectToDeletePredicate();
    }

    public DeleteObjectMutation(ESModelMutatorUtil util, MutationTargetSelector selector) {
        super(util, selector);
        this.addHasObjectToDeletePredicate();
    }

    private void addHasObjectToDeletePredicate() {
        this.getTargetContainerSelector().getOriginalFeatureValuePredicates().add(MutationPredicates.IS_NON_EMPTY_EOBJECT_OR_LIST);
    }

    @Override
    public DeleteObjectMutation setMaxNumberOfContainments(int maxNumberOfContainments) {
        this.maxNumberOfContainments = maxNumberOfContainments;
        return this;
    }

    public int getMaxNumberOfContainments() {
        return this.maxNumberOfContainments;
    }

    public void setEObjectToDelete(EObject eObjectToDelete) {
        this.eObjectToDelete = eObjectToDelete;
    }

    public EObject getEObjectToDelete() {
        return this.eObjectToDelete;
    }

    @Override
    public Mutation clone() {
        DeleteObjectMutation mutation = new DeleteObjectMutation(this.getUtil(), this.getTargetContainerSelector());
        mutation.setMaxNumberOfContainments(this.maxNumberOfContainments);
        mutation.setEObjectToDelete(this.getEObjectToDelete());
        return mutation;
    }

    @Override
    public void apply() throws ESMutationException {
        this.doSelection();
        EObject eObjectToDelete = this.getOrSelectEObjectToDelete();
        EcoreUtil.delete((EObject)eObjectToDelete);
        this.getUtil().deletedEObject(eObjectToDelete);
    }

    private void doSelection() throws ESMutationException {
        if (this.getEObjectToDelete() == null) {
            this.getTargetContainerSelector().getOriginalFeatureValuePredicates().add(MutationPredicates.containsEObjectWithMaxNumberOfContainments(this.maxNumberOfContainments));
            this.getTargetContainerSelector().doSelection();
        }
    }

    private EObject getOrSelectEObjectToDelete() throws ESMutationException {
        if (this.getEObjectToDelete() == null) {
            Predicate<Object> predicate = this.getMaxNumberOfContainmentsPredicate();
            Object objectToDelete = this.getTargetContainerSelector().selectRandomContainedValue(predicate);
            if (objectToDelete != null && objectToDelete instanceof EObject) {
                this.setEObjectToDelete((EObject)objectToDelete);
            } else {
                throw new ESMutationException(Messages.getString("DeleteObjectMutation.NoObjectForDeleteFound"));
            }
        }
        return this.getEObjectToDelete();
    }

    private Predicate<Object> getMaxNumberOfContainmentsPredicate() {
        return MutationPredicates.hasMaxNumberOfContainments(this.maxNumberOfContainments);
    }
}

