/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.impl.api;

import org.eclipse.emf.emfstore.client.ESServer;
import org.eclipse.emf.emfstore.client.ESServerFactory;
import org.eclipse.emf.emfstore.client.exceptions.ESServerStartFailedException;
import org.eclipse.emf.emfstore.internal.client.model.ServerInfo;
import org.eclipse.emf.emfstore.internal.client.model.util.EMFStoreClientUtil;
import org.eclipse.emf.emfstore.internal.server.EMFStoreController;
import org.eclipse.emf.emfstore.internal.server.exceptions.FatalESException;

public final class ESServerFactoryImpl
implements ESServerFactory {
    private static final String LOCALHOST = "localhost";
    private static final String LOCAL_SERVER_NAME = "Local Server";
    public static final ESServerFactoryImpl INSTANCE = new ESServerFactoryImpl();
    private EMFStoreController localEMFStoreServer;

    private ESServerFactoryImpl() {
    }

    public ESServer createServer(String url, int port, String certificate) {
        ServerInfo serverInfo = EMFStoreClientUtil.createServerInfo(url, port, certificate);
        return (ESServer)serverInfo.toAPI();
    }

    public ESServer createServer(String name, String url, int port, String certificate) {
        ServerInfo serverInfo = EMFStoreClientUtil.createServerInfo(url, port, certificate);
        serverInfo.setName(name);
        return (ESServer)serverInfo.toAPI();
    }

    public ESServer createAndStartLocalServer() throws ESServerStartFailedException {
        if (this.localEMFStoreServer == null) {
            try {
                this.localEMFStoreServer = EMFStoreController.runAsNewThread();
            }
            catch (FatalESException e) {
                throw new ESServerStartFailedException(e);
            }
        }
        ESServer server = this.createServer(LOCAL_SERVER_NAME, LOCALHOST, Integer.parseInt("8080"), "emfstore test certificate (do not use in production!)");
        return server;
    }

    public void stopLocalServer() {
        if (this.localEMFStoreServer != null) {
            this.localEMFStoreServer.stop();
            this.localEMFStoreServer = null;
        }
    }
}

