/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.controller;

import java.text.MessageFormat;
import java.util.concurrent.Callable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.emfstore.client.ESRemoteProject;
import org.eclipse.emf.emfstore.client.ESUsersession;
import org.eclipse.emf.emfstore.internal.client.model.Usersession;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESUsersessionImpl;
import org.eclipse.emf.emfstore.internal.client.ui.common.RunInUI;
import org.eclipse.emf.emfstore.internal.client.ui.controller.AbstractEMFStoreUIController;
import org.eclipse.emf.emfstore.internal.client.ui.controller.Messages;
import org.eclipse.emf.emfstore.internal.client.ui.views.emfstorebrowser.views.CreateProjectDialog;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UICreateRemoteProjectController
extends AbstractEMFStoreUIController<ESRemoteProject> {
    private final Usersession session;
    private final String projectName;

    private UICreateRemoteProjectController(Shell shell) {
        super(shell, true, false);
        this.session = null;
        this.projectName = null;
    }

    public UICreateRemoteProjectController(Shell shell, ESUsersession session) {
        super(shell);
        this.session = (Usersession)((ESUsersessionImpl)session).toInternalAPI();
        this.projectName = null;
    }

    public UICreateRemoteProjectController(Shell shell, ESUsersession session, String projectName) {
        super(shell);
        this.session = (Usersession)((ESUsersessionImpl)session).toInternalAPI();
        this.projectName = projectName;
    }

    private ESRemoteProject createRemoteProject(IProgressMonitor monitor) throws ESException {
        String projectName = RunInUI.runWithResult(new Callable<String>(){

            @Override
            public String call() throws Exception {
                CreateProjectDialog dialog = new CreateProjectDialog(UICreateRemoteProjectController.this.getShell());
                if (dialog.open() == 0) {
                    return dialog.getName();
                }
                return null;
            }
        });
        return this.createRemoteProject(this.session, projectName, "", monitor);
    }

    private ESRemoteProject createRemoteProject(Usersession usersession, String name, String description, IProgressMonitor monitor) throws ESException {
        return ((ESUsersessionImpl)usersession.toAPI()).getServer().createRemoteProject(name, monitor);
    }

    @Override
    public ESRemoteProject doRun(IProgressMonitor monitor) throws ESException {
        try {
            if (this.session == null) {
                throw new IllegalArgumentException(Messages.UICreateRemoteProjectController_SessionMustNotBeNull);
            }
            if (this.projectName == null) {
                return this.createRemoteProject(monitor);
            }
            return this.createRemoteProject(this.session, this.projectName, "", monitor);
        }
        catch (ESException e) {
            RunInUI.run(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    MessageDialog.openError((Shell)UICreateRemoteProjectController.this.getShell(), (String)Messages.UICreateRemoteProjectController_CreateProjectFailed_Title, (String)MessageFormat.format(Messages.UICreateRemoteProjectController_CreateProjectFailed_Message, e.getMessage()));
                    return null;
                }
            });
            return null;
        }
    }
}

