/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.migration;

import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionPoint;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionPointException;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.migration.EMFStoreMigrationException;
import org.eclipse.emf.emfstore.internal.migration.EMFStoreMigrator;

public final class EMFStoreMigratorUtil {
    private static final String MIGRATOR_CLASS = "migratorClass";
    private static EMFStoreMigrator migrator;

    private EMFStoreMigratorUtil() {
    }

    public static boolean isMigratorAvailable() {
        if (migrator != null) {
            return true;
        }
        try {
            migrator = EMFStoreMigratorUtil.loadMigrator();
        }
        catch (EMFStoreMigrationException eMFStoreMigrationException) {
            return false;
        }
        return true;
    }

    public static EMFStoreMigrator getEMFStoreMigrator() throws EMFStoreMigrationException {
        if (migrator != null) {
            return migrator;
        }
        return EMFStoreMigratorUtil.loadMigrator();
    }

    private static EMFStoreMigrator loadMigrator() throws EMFStoreMigrationException {
        ESExtensionPoint extensionPoint = new ESExtensionPoint("org.eclipse.emf.emfstore.migration.migrator", true);
        if (extensionPoint.size() > 1) {
            ModelUtil.logWarning((String)"Multiple EMFStore Migrators are registered. EMFStore will default to first loadable migrator.");
        }
        try {
            return (EMFStoreMigrator)extensionPoint.getFirst().getClass(MIGRATOR_CLASS, EMFStoreMigrator.class);
        }
        catch (ESExtensionPointException eSExtensionPointException) {
            throw new EMFStoreMigrationException("No EMFStore migrator registered.");
        }
    }
}

