/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.emfstore.common.ESObserver;
import org.eclipse.emf.emfstore.internal.client.importexport.impl.ExportProjectSpaceController;
import org.eclipse.emf.emfstore.internal.client.importexport.impl.ExportWorkspaceController;
import org.eclipse.emf.emfstore.internal.client.model.AdminBroker;
import org.eclipse.emf.emfstore.internal.client.model.ESWorkspaceProviderImpl;
import org.eclipse.emf.emfstore.internal.client.model.ModelFactory;
import org.eclipse.emf.emfstore.internal.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.internal.client.model.ServerInfo;
import org.eclipse.emf.emfstore.internal.client.model.Usersession;
import org.eclipse.emf.emfstore.internal.client.model.Workspace;
import org.eclipse.emf.emfstore.internal.client.model.connectionmanager.ServerCall;
import org.eclipse.emf.emfstore.internal.client.model.exceptions.ProjectUrlResolutionException;
import org.eclipse.emf.emfstore.internal.client.model.exceptions.ServerUrlResolutionException;
import org.eclipse.emf.emfstore.internal.client.model.exceptions.UnkownProjectException;
import org.eclipse.emf.emfstore.internal.client.model.impl.AdminBrokerImpl;
import org.eclipse.emf.emfstore.internal.client.model.impl.Messages;
import org.eclipse.emf.emfstore.internal.client.model.impl.ProjectSpaceBase;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESWorkspaceImpl;
import org.eclipse.emf.emfstore.internal.client.model.util.ResourceHelper;
import org.eclipse.emf.emfstore.internal.client.observers.DeleteProjectSpaceObserver;
import org.eclipse.emf.emfstore.internal.common.ESDisposable;
import org.eclipse.emf.emfstore.internal.common.model.Project;
import org.eclipse.emf.emfstore.internal.common.model.util.IResourceLogger;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.exceptions.AccessControlException;
import org.eclipse.emf.emfstore.internal.server.model.url.ProjectUrlFragment;
import org.eclipse.emf.emfstore.internal.server.model.url.ServerUrl;
import org.eclipse.emf.emfstore.server.exceptions.ESException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WorkspaceBase
extends EObjectImpl
implements Workspace,
ESDisposable,
DeleteProjectSpaceObserver {
    private ESWorkspaceImpl apiImplClass;
    private Map<Project, ProjectSpace> projectToProjectSpaceMap;
    private ResourceSet workspaceResourceSet;

    public void addProjectSpace(ProjectSpace projectSpace) {
        this.getProjectSpaces().add((Object)projectSpace);
        this.projectToProjectSpaceMap.put(projectSpace.getProject(), projectSpace);
    }

    public ProjectSpace cloneProject(String projectName, Project originalProject) {
        ProjectSpace projectSpace = ModelFactory.eINSTANCE.createProjectSpace();
        projectSpace.setProject((Project)ModelUtil.clone((EObject)originalProject));
        projectSpace.setProjectName(projectName);
        projectSpace.initResources(this.getResourceSet());
        this.addProjectSpace(projectSpace);
        this.save();
        return projectSpace;
    }

    @Override
    public ProjectSpace createLocalProject(String projectName) {
        return this.cloneProject(projectName, org.eclipse.emf.emfstore.internal.common.model.ModelFactory.eINSTANCE.createProject());
    }

    @Override
    public void init() {
        this.projectToProjectSpaceMap = new LinkedHashMap<Project, ProjectSpace>();
        for (ProjectSpace projectSpace : this.getProjectSpaces()) {
            projectSpace.init();
            this.projectToProjectSpaceMap.put(projectSpace.getProject(), projectSpace);
        }
        ESWorkspaceProviderImpl.getObserverBus().register((ESObserver)this, new Class[]{DeleteProjectSpaceObserver.class});
    }

    public void dispose() {
        for (ProjectSpace projectSpace : this.getProjectSpaces()) {
            ((ProjectSpaceBase)projectSpace).dispose();
        }
        this.getServerInfos().clear();
        this.getUsersessions().clear();
        this.save();
    }

    @Override
    public void setResourceSet(ResourceSet resourceSet) {
        this.workspaceResourceSet = resourceSet;
        for (ProjectSpace projectSpace : this.getProjectSpaces()) {
            ProjectSpaceBase base = (ProjectSpaceBase)projectSpace;
            base.setResourceSet(this.workspaceResourceSet);
        }
    }

    @Override
    public void updateACUser(ServerInfo serverInfo) throws ESException {
        new ServerCall<Void>(serverInfo){

            @Override
            protected Void run() throws ESException {
                this.getUsersession().setACUser(this.getConnectionManager().resolveUser(this.getSessionId(), null));
                return null;
            }
        }.execute();
    }

    @Override
    public void updateACUser(Usersession usersession) throws ESException {
        new ServerCall<Void>(usersession){

            @Override
            protected Void run() throws ESException {
                this.getUsersession().setACUser(this.getConnectionManager().resolveUser(this.getSessionId(), null));
                return null;
            }
        }.execute();
    }

    @Override
    public ResourceSet getResourceSet() {
        return this.workspaceResourceSet;
    }

    @Override
    public ProjectSpace importProject(Project project, String name, String description) {
        ProjectSpace projectSpace = ModelFactory.eINSTANCE.createProjectSpace();
        projectSpace.setProject(project);
        projectSpace.setProjectName(name);
        projectSpace.setProjectDescription(description);
        projectSpace.initResources(this.workspaceResourceSet);
        this.addProjectSpace(projectSpace);
        this.save();
        return projectSpace;
    }

    @Override
    public ProjectSpace importProject(String absoluteFileName) throws IOException {
        Project project = ResourceHelper.getElementFromResource(absoluteFileName, Project.class, 0);
        return this.importProject(project, absoluteFileName.substring(absoluteFileName.lastIndexOf(File.separatorChar) + 1), String.valueOf(Messages.WorkspaceBase_ImportedFrom) + absoluteFileName);
    }

    @Override
    public ProjectSpace importProjectSpace(String absoluteFileName) throws IOException {
        ProjectSpace projectSpace = ResourceHelper.getElementFromResource(absoluteFileName, ProjectSpace.class, 0);
        projectSpace.setIdentifier(ModelFactory.eINSTANCE.createProjectSpace().getIdentifier());
        projectSpace.initResources(this.workspaceResourceSet);
        this.addProjectSpace(projectSpace);
        this.save();
        return projectSpace;
    }

    @Override
    public Set<ProjectSpace> resolve(ProjectUrlFragment projectUrlFragment) throws ProjectUrlResolutionException {
        LinkedHashSet<ProjectSpace> result = new LinkedHashSet<ProjectSpace>();
        for (ProjectSpace projectSpace : this.getProjectSpaces()) {
            if (!projectSpace.getProjectId().equals(projectUrlFragment.getProjectId())) continue;
            result.add(projectSpace);
        }
        if (result.size() == 0) {
            throw new ProjectUrlResolutionException();
        }
        return result;
    }

    @Override
    public Set<ServerInfo> resolve(ServerUrl serverUrl) throws ServerUrlResolutionException {
        LinkedHashSet<ServerInfo> result = new LinkedHashSet<ServerInfo>();
        for (ServerInfo serverInfo : this.getServerInfos()) {
            boolean matchingPort;
            boolean matchingHostname = serverInfo.getUrl().equals(serverUrl.getHostName());
            boolean bl = matchingPort = serverInfo.getPort() == serverUrl.getPort();
            if (!matchingHostname || !matchingPort) continue;
            result.add(serverInfo);
        }
        if (result.size() == 0) {
            throw new ServerUrlResolutionException();
        }
        return result;
    }

    @Override
    public void save() {
        try {
            ModelUtil.saveResource((Resource)this.eResource(), (IResourceLogger)ModelUtil.getResourceLogger());
        }
        catch (IOException iOException) {}
    }

    @Override
    public void exportProjectSpace(ProjectSpace projectSpace, File file) throws IOException {
        new ExportProjectSpaceController(projectSpace).execute(file, (IProgressMonitor)new NullProgressMonitor());
    }

    @Override
    public void exportProjectSpace(ProjectSpace projectSpace, File file, IProgressMonitor progressMonitor) throws IOException {
        new ExportProjectSpaceController(projectSpace).execute(file, progressMonitor);
    }

    @Override
    public void exportWorkSpace(File file) throws IOException {
        new ExportWorkspaceController().execute(file, (IProgressMonitor)new NullProgressMonitor());
    }

    @Override
    public void exportWorkSpace(File file, IProgressMonitor progressMonitor) throws IOException {
        new ExportWorkspaceController().execute(file, progressMonitor);
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    @Override
    public AdminBroker getAdminBroker(final ServerInfo serverInfo) throws ESException, AccessControlException {
        return (AdminBroker)new ServerCall<AdminBroker>(serverInfo){

            @Override
            protected AdminBroker run() throws ESException {
                return new AdminBrokerImpl(serverInfo, this.getSessionId());
            }
        }.execute();
    }

    @Override
    public AdminBroker getAdminBroker(final Usersession usersession) throws ESException, AccessControlException {
        return (AdminBroker)new ServerCall<AdminBroker>(usersession){

            @Override
            protected AdminBroker run() throws ESException {
                return new AdminBrokerImpl(usersession.getServerInfo(), this.getSessionId());
            }
        }.execute();
    }

    @Override
    public EditingDomain getEditingDomain() {
        return ESWorkspaceProviderImpl.getInstance().getEditingDomain();
    }

    @Override
    public ProjectSpace getProjectSpace(Project project) throws UnkownProjectException {
        ProjectSpace projectSpace = this.projectToProjectSpaceMap.get(project);
        if (projectSpace == null) {
            throw new UnkownProjectException();
        }
        return projectSpace;
    }

    @Override
    public void projectSpaceDeleted(ProjectSpace projectSpace) {
        assert (projectSpace != null);
        this.getProjectSpaces().remove((Object)projectSpace);
        this.save();
        this.projectToProjectSpaceMap.remove(projectSpace.getProject());
    }

    @Override
    public void addServerInfo(ServerInfo serverInfo) {
        this.getServerInfos().add((Object)serverInfo);
        this.save();
    }

    @Override
    public void removeServerInfo(ServerInfo serverInfo) {
        this.getServerInfos().remove((Object)serverInfo);
        ArrayList<Usersession> deletables = new ArrayList<Usersession>();
        for (Usersession session : this.getUsersessions()) {
            if (session.getServerInfo() != serverInfo) continue;
            try {
                session.logout();
            }
            catch (ESException eSException) {}
            deletables.add(session);
        }
        this.getUsersessions().removeAll(deletables);
        this.save();
    }

    @Override
    public void removeUsersession(Usersession session) throws ESException {
        session.logout();
        this.getUsersessions().remove((Object)session);
        this.save();
    }

    public ESWorkspaceImpl toAPI() {
        if (this.apiImplClass == null) {
            this.apiImplClass = this.createAPI();
        }
        return this.apiImplClass;
    }

    public void setAPIImpl(ESWorkspaceImpl apiImpl) {
        this.apiImplClass = apiImpl;
    }

    public ESWorkspaceImpl createAPI() {
        return new ESWorkspaceImpl(this);
    }
}

