/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.connection.xmlrpc;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.common.TypeConverterFactory;
import org.apache.xmlrpc.common.TypeFactory;
import org.apache.xmlrpc.common.XmlRpcController;
import org.apache.xmlrpc.server.PropertyHandlerMapping;
import org.apache.xmlrpc.server.XmlRpcHandlerMapping;
import org.apache.xmlrpc.server.XmlRpcServerConfigImpl;
import org.apache.xmlrpc.server.XmlRpcStreamServer;
import org.apache.xmlrpc.webserver.WebServer;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.EMFStoreController;
import org.eclipse.emf.emfstore.internal.server.connection.ServerKeyStoreManager;
import org.eclipse.emf.emfstore.internal.server.connection.xmlrpc.util.EObjectTypeConverterFactory;
import org.eclipse.emf.emfstore.internal.server.connection.xmlrpc.util.EObjectTypeFactory;
import org.eclipse.emf.emfstore.internal.server.exceptions.FatalESException;
import org.eclipse.emf.emfstore.internal.server.exceptions.ServerKeyStoreException;
import org.eclipse.emf.emfstore.server.ESXmlRpcWebServerProvider;
import org.eclipse.emf.emfstore.server.exceptions.ESServerInitException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XmlRpcBuiltinWebServer
implements ESXmlRpcWebServerProvider {
    private WebServer webServer = null;
    private int port = -1;

    @Override
    public void initServer() throws ESServerInitException {
        if (this.port == -1) {
            throw new ESServerInitException("Port is not set for EMFStore Server");
        }
        if (this.webServer != null) {
            return;
        }
        try {
            this.webServer = new WebServer(this.port){

                protected ServerSocket createServerSocket(int pPort, int backlog, InetAddress addr) throws IOException {
                    ServerSocketFactory serverSocketFactory = null;
                    try {
                        SSLContext context = SSLContext.getInstance("TLS");
                        context.init(ServerKeyStoreManager.getInstance().getKeyManagerFactory().getKeyManagers(), null, null);
                        serverSocketFactory = context.getServerSocketFactory();
                    }
                    catch (NoSuchAlgorithmException exception) {
                        this.shutdown((SSLServerSocketFactory)serverSocketFactory, exception);
                    }
                    catch (KeyManagementException exception) {
                        this.shutdown((SSLServerSocketFactory)serverSocketFactory, exception);
                    }
                    catch (ServerKeyStoreException exception) {
                        this.shutdown((SSLServerSocketFactory)serverSocketFactory, exception);
                    }
                    return serverSocketFactory.createServerSocket(pPort, backlog, addr);
                }

                private void shutdown(SSLServerSocketFactory serverSocketFactory, Exception e) {
                    if (serverSocketFactory == null) {
                        ModelUtil.logException((String)"Couldn't initialize server socket.", (Throwable)e);
                        EMFStoreController.getInstance().shutdown(new FatalESException());
                    }
                }
            };
            ModelUtil.logInfo((String)("Started XML RPC Webserver on port: " + this.port));
            XmlRpcStreamServer xmlRpcServer = this.webServer.getXmlRpcServer();
            xmlRpcServer.setTypeFactory((TypeFactory)new EObjectTypeFactory((XmlRpcController)xmlRpcServer));
            EObjectTypeConverterFactory pFactory = new EObjectTypeConverterFactory();
            xmlRpcServer.setTypeConverterFactory((TypeConverterFactory)pFactory);
            PropertyHandlerMapping phm = new PropertyHandlerMapping();
            phm.setVoidMethodEnabled(true);
            phm.setTypeConverterFactory((TypeConverterFactory)pFactory);
            xmlRpcServer.setHandlerMapping((XmlRpcHandlerMapping)phm);
            XmlRpcServerConfigImpl serverConfig = (XmlRpcServerConfigImpl)xmlRpcServer.getConfig();
            serverConfig.setEnabledForExtensions(true);
            serverConfig.setEnabledForExceptions(true);
            serverConfig.setContentLengthOptional(true);
            this.webServer.start();
        }
        catch (IOException e) {
            throw new ESServerInitException("Couldn't start webserver", e);
        }
    }

    @Override
    public void addHandler(String handlerName, Class<?> clazz) throws ESServerInitException {
        try {
            PropertyHandlerMapping mapper = (PropertyHandlerMapping)this.webServer.getXmlRpcServer().getHandlerMapping();
            mapper.addHandler(handlerName, clazz);
        }
        catch (XmlRpcException e) {
            throw new ESServerInitException("Couldn't add handler", e);
        }
    }

    @Override
    public boolean removeHandler(String handlerName) {
        PropertyHandlerMapping mapper = (PropertyHandlerMapping)this.webServer.getXmlRpcServer().getHandlerMapping();
        mapper.removeHandler(handlerName);
        try {
            return mapper.getListMethods().length > 0;
        }
        catch (XmlRpcException xmlRpcException) {
            return false;
        }
    }

    @Override
    public void stopServer() {
        this.webServer.shutdown();
        this.webServer = null;
    }

    @Override
    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public int getPort() {
        return this.port;
    }
}

