/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.views.historybrowserview;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.internal.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESLocalProjectImpl;
import org.eclipse.emf.emfstore.internal.common.model.ModelElementId;
import org.eclipse.emf.emfstore.internal.server.model.impl.api.ESHistoryInfoImpl;
import org.eclipse.emf.emfstore.internal.server.model.versioning.HistoryInfo;
import org.eclipse.emf.emfstore.internal.server.model.versioning.HistoryQuery;
import org.eclipse.emf.emfstore.internal.server.model.versioning.PrimaryVersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.VersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.Versions;
import org.eclipse.emf.emfstore.internal.server.model.versioning.util.HistoryQueryBuilder;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.eclipse.emf.emfstore.server.model.ESHistoryInfo;
import org.eclipse.emf.emfstore.server.model.query.ESHistoryQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PaginationManager {
    private PrimaryVersionSpec currentCenterVersionShown;
    private int aboveCenterCount;
    private int belowCenterCount;
    private List<HistoryInfo> currentlyPresentedInfos = new ArrayList<HistoryInfo>();
    private ProjectSpace projectSpace;
    private boolean nextPage;
    private boolean prevPage;
    private boolean showAllVersions;
    private EObject modelElement;
    private final String projectBranch;

    public PaginationManager(ProjectSpace projectSpace, EObject modelElement, int aboveCenterCount, int belowCenterCount) {
        this.aboveCenterCount = aboveCenterCount;
        this.belowCenterCount = belowCenterCount;
        this.projectSpace = projectSpace;
        this.modelElement = modelElement;
        this.projectBranch = projectSpace.getBaseVersion().getBranch();
    }

    public List<HistoryInfo> retrieveHistoryInfos() throws ESException {
        PrimaryVersionSpec newCenterVersion;
        int beforeCurrent = -1;
        if ((this.prevPage || this.nextPage) && this.currentCenterVersionShown != null && !this.currentlyPresentedInfos.isEmpty()) {
            int i = 0;
            while (i < this.currentlyPresentedInfos.size()) {
                if (this.currentlyPresentedInfos.get(i).getPrimarySpec().getIdentifier() == this.currentCenterVersionShown.getIdentifier()) {
                    beforeCurrent = i;
                    break;
                }
                ++i;
            }
            assert (beforeCurrent != -1) : "The currently shown center version should be contained in the currently shown history infos, why has it vanished?";
            if (this.prevPage) {
                newCenterVersion = this.currentlyPresentedInfos.get(0).getPrimarySpec();
            } else if (this.nextPage) {
                newCenterVersion = this.currentlyPresentedInfos.get(this.currentlyPresentedInfos.size() - 1).getPrimarySpec();
            } else {
                assert (false);
                newCenterVersion = this.currentCenterVersionShown;
            }
        } else {
            newCenterVersion = this.currentCenterVersionShown;
        }
        HistoryQuery query = this.getQuery(newCenterVersion, this.aboveCenterCount, this.belowCenterCount);
        List infos = ((ESLocalProjectImpl)this.projectSpace.toAPI()).getHistoryInfos((ESHistoryQuery)query.toAPI(), (IProgressMonitor)new NullProgressMonitor());
        ArrayList<HistoryInfo> historyInfos = new ArrayList<HistoryInfo>();
        for (ESHistoryInfo info : infos) {
            historyInfos.add((HistoryInfo)((ESHistoryInfoImpl)info).toInternalAPI());
        }
        if (newCenterVersion != null && !this.currentCenterVersionShown.equals(newCenterVersion)) {
            this.setCorrectCenterVersionAndHistory(historyInfos, newCenterVersion.getIdentifier(), beforeCurrent);
        } else {
            this.currentlyPresentedInfos = this.cutInfos(historyInfos, this.findPositionOfId(this.currentCenterVersionShown.getIdentifier(), historyInfos));
        }
        this.prevPage = false;
        this.nextPage = false;
        return this.currentlyPresentedInfos;
    }

    private void setCorrectCenterVersionAndHistory(List<HistoryInfo> newQueryHistoryInfos, int newCenterVersionId, int positionOfOldCenterInCurrentDisplay) {
        int idOfCurrentVersionShown = this.currentlyPresentedInfos.get(positionOfOldCenterInCurrentDisplay).getPrimarySpec().getIdentifier();
        int olderVersions = 0;
        int newerVersions = 0;
        int newCenterVersionPos = -1;
        int oldCenterVersionPos = -1;
        int i = 0;
        while (i < newQueryHistoryInfos.size()) {
            int idOfI = newQueryHistoryInfos.get(i).getPrimarySpec().getIdentifier();
            if (idOfI > newCenterVersionId) {
                ++newerVersions;
            } else if (idOfI < newCenterVersionId) {
                ++olderVersions;
            } else if (idOfI == newCenterVersionId) {
                newCenterVersionPos = i;
            } else if (idOfI == idOfCurrentVersionShown) {
                assert (oldCenterVersionPos == -1) : "Should not be in there twice.";
                oldCenterVersionPos = i;
            }
            ++i;
        }
        if (newCenterVersionPos == -1) {
            newCenterVersionPos = Math.max(0, newerVersions - 1);
        }
        PrimaryVersionSpec newCenterVersion = newQueryHistoryInfos.get(newCenterVersionPos).getPrimarySpec();
        assert (this.prevPage ^ this.nextPage);
        if (this.prevPage && newerVersions < this.aboveCenterCount) {
            List<HistoryInfo> mergedInfos = this.mergeHistoryInfoLists(newQueryHistoryInfos, this.currentlyPresentedInfos);
            int oldCenterPos = this.findPositionOfId(this.currentCenterVersionShown.getIdentifier(), mergedInfos);
            int newCenterPos = Math.min(Math.min(this.aboveCenterCount, oldCenterPos), newQueryHistoryInfos.size() - 1);
            newCenterVersion = mergedInfos.get(newCenterPos).getPrimarySpec();
            this.currentlyPresentedInfos = this.cutInfos(mergedInfos, newCenterPos);
        } else if (this.nextPage && olderVersions < this.belowCenterCount) {
            List<HistoryInfo> mergedInfos = this.mergeHistoryInfoLists(newQueryHistoryInfos, this.currentlyPresentedInfos);
            int oldCenterPos = this.findPositionOfId(this.currentCenterVersionShown.getIdentifier(), mergedInfos);
            int newCenterPos = Math.max(Math.max(mergedInfos.size() - 1 - this.belowCenterCount, oldCenterPos), 0);
            newCenterVersion = mergedInfos.get(newCenterPos).getPrimarySpec();
            this.currentlyPresentedInfos = this.cutInfos(mergedInfos, newCenterPos);
        } else {
            newCenterVersion = newQueryHistoryInfos.get(newCenterVersionPos).getPrimarySpec();
            this.currentlyPresentedInfos = this.cutInfos(newQueryHistoryInfos, newCenterVersionPos);
        }
        this.currentCenterVersionShown = newCenterVersion;
    }

    private List<HistoryInfo> cutInfos(List<HistoryInfo> mergedInfos, int newCenterPos) {
        int smallestIndexIn = Math.max(0, newCenterPos - this.aboveCenterCount);
        int largestIndexIn = Math.min(mergedInfos.size() - 1, newCenterPos + this.belowCenterCount);
        ArrayList<HistoryInfo> cut = new ArrayList<HistoryInfo>();
        int i = smallestIndexIn;
        while (i <= largestIndexIn) {
            cut.add(mergedInfos.get(i));
            ++i;
        }
        return cut;
    }

    private int findPositionOfId(int identifier, List<HistoryInfo> mergedInfos) {
        return this.findPositionOfId(identifier, mergedInfos, true);
    }

    private int findPositionOfId(int identifier, List<HistoryInfo> infoList, boolean mustBeIn) {
        int i = 0;
        while (i < infoList.size()) {
            if (this.getId(infoList.get(i)) <= identifier) {
                return i;
            }
            ++i;
        }
        if (mustBeIn) {
            throw new IllegalArgumentException("Did not find version with id " + identifier + " but should be in.");
        }
        return -1;
    }

    private List<HistoryInfo> mergeHistoryInfoLists(List<HistoryInfo> newQueryHistoryInfos, List<HistoryInfo> oldPresentedHistoryInfos) {
        return this.newMerge(newQueryHistoryInfos, oldPresentedHistoryInfos);
    }

    private List<HistoryInfo> newMerge(List<HistoryInfo> newQuery, List<HistoryInfo> olderVersions) {
        int newPos = 0;
        int oldPos = 0;
        ArrayList<HistoryInfo> merge = new ArrayList<HistoryInfo>();
        while (newPos < newQuery.size() && oldPos < olderVersions.size()) {
            if (this.getId(newQuery.get(newPos)) >= this.getId(olderVersions.get(oldPos))) {
                merge.add(newQuery.get(newPos));
                ++newPos;
                continue;
            }
            merge.add(olderVersions.get(oldPos));
            ++oldPos;
        }
        assert (newPos == newQuery.size() || oldPos == olderVersions.size());
        int i = newPos;
        while (i < newQuery.size()) {
            merge.add(newQuery.get(i));
            ++i;
        }
        i = oldPos;
        while (i < olderVersions.size()) {
            merge.add(olderVersions.get(i));
            ++i;
        }
        Iterator iterator = merge.iterator();
        int prevId = Integer.MIN_VALUE;
        while (iterator.hasNext()) {
            int currId = this.getId((HistoryInfo)iterator.next());
            if (currId == prevId) {
                iterator.remove();
            }
            prevId = currId;
        }
        return merge;
    }

    private int getId(HistoryInfo info) {
        return info.getPrimarySpec().getIdentifier();
    }

    private HistoryQuery getQuery(PrimaryVersionSpec centerVersion, int aboveCenter, int belowCenter) throws ESException {
        QueryMargins margins;
        PrimaryVersionSpec version;
        if (centerVersion != null) {
            version = centerVersion;
        } else {
            this.currentCenterVersionShown = version = this.projectSpace.getBaseVersion();
        }
        if (centerVersion != null && !centerVersion.getBranch().equals(this.projectBranch)) {
            margins = this.getBranchAdaptedMargins(centerVersion, aboveCenter, belowCenter);
        } else {
            margins = new QueryMargins();
            margins.aboveCenter = aboveCenter;
            margins.belowCenter = belowCenter;
            margins.querySpec = version;
        }
        Object query = this.modelElement != null && !(this.modelElement instanceof ProjectSpace) && this.projectSpace.getProject().contains(this.modelElement) ? HistoryQueryBuilder.modelelementQuery((PrimaryVersionSpec)margins.querySpec, (ModelElementId)this.projectSpace.getProject().getModelElementId(this.modelElement), (int)margins.aboveCenter, (int)margins.belowCenter, (boolean)this.showAllVersions, (boolean)true) : HistoryQueryBuilder.rangeQuery((PrimaryVersionSpec)margins.querySpec, (int)margins.aboveCenter, (int)margins.belowCenter, (boolean)this.showAllVersions, (!this.showAllVersions ? 1 : 0) != 0, (!this.showAllVersions ? 1 : 0) != 0, (boolean)true);
        return query;
    }

    private QueryMargins getBranchAdaptedMargins(PrimaryVersionSpec centerVersion, int aboveCenter, int belowCenter) throws ESException {
        QueryMargins margins = new QueryMargins();
        centerVersion.setBranch(this.projectBranch);
        margins.aboveCenter = aboveCenter;
        margins.belowCenter = belowCenter;
        PrimaryVersionSpec nearestSpec = this.projectSpace.resolveVersionSpec((VersionSpec)centerVersion, (IProgressMonitor)new NullProgressMonitor());
        if (nearestSpec.getIdentifier() < centerVersion.getIdentifier()) {
            margins.aboveCenter = aboveCenter + (centerVersion.getIdentifier() - nearestSpec.getIdentifier()) + 1;
        } else if (nearestSpec.getIdentifier() > centerVersion.getIdentifier()) {
            margins.belowCenter = belowCenter + (nearestSpec.getIdentifier() - centerVersion.getIdentifier() + 1);
        }
        margins.querySpec = nearestSpec;
        return margins;
    }

    public void setShowAllVersions(boolean allVersions) {
        this.showAllVersions = allVersions;
        this.currentCenterVersionShown = null;
        this.currentlyPresentedInfos.clear();
    }

    public void nextPage() {
        this.nextPage = true;
        this.prevPage = false;
    }

    public void previousPage() {
        this.prevPage = true;
        this.nextPage = false;
    }

    public boolean setVersion(int id) throws ESException {
        int newCenterPos;
        this.prevPage = false;
        this.nextPage = false;
        if (this.currentlyPresentedInfos.isEmpty() || this.currentCenterVersionShown == null) {
            return false;
        }
        int newestVersion = this.getId(this.currentlyPresentedInfos.get(0));
        int oldestVersion = this.getId(this.currentlyPresentedInfos.get(this.currentlyPresentedInfos.size() - 1));
        if (newestVersion >= id && id >= oldestVersion) {
            return true;
        }
        HistoryQuery query = this.getQuery(Versions.createPRIMARY((VersionSpec)this.projectSpace.getBaseVersion(), (int)id), this.aboveCenterCount + this.belowCenterCount, this.aboveCenterCount + this.belowCenterCount);
        List infos = ((ESLocalProjectImpl)this.projectSpace.toAPI()).getHistoryInfos((ESHistoryQuery)query.toAPI(), (IProgressMonitor)new NullProgressMonitor());
        ArrayList<HistoryInfo> historyInfos = new ArrayList<HistoryInfo>();
        for (ESHistoryInfo info : infos) {
            historyInfos.add((HistoryInfo)((ESHistoryInfoImpl)info).toInternalAPI());
        }
        int requestedIdPos = this.findPositionOfId(id, historyInfos, false);
        boolean contained = this.containsId(historyInfos, id);
        if (!contained) {
            return false;
        }
        if (requestedIdPos != -1) {
            newCenterPos = this.getPosForIdTakingAboveBelowIntoAccount(historyInfos, requestedIdPos);
        } else {
            requestedIdPos = this.findPositionOfId(id, historyInfos);
            newCenterPos = this.getPosForIdTakingAboveBelowIntoAccount(historyInfos, requestedIdPos);
        }
        this.currentCenterVersionShown = ((HistoryInfo)historyInfos.get(newCenterPos)).getPrimarySpec();
        this.currentlyPresentedInfos = this.cutInfos(historyInfos, newCenterPos);
        return true;
    }

    private int getPosForIdTakingAboveBelowIntoAccount(List<HistoryInfo> infoList, int pos) {
        int newCenterPos = pos + this.belowCenterCount > infoList.size() ? Math.max(0, infoList.size() - this.belowCenterCount - 1) : (pos - this.aboveCenterCount < 0 ? Math.min(infoList.size() - 1, this.aboveCenterCount) : pos);
        return newCenterPos;
    }

    private boolean containsId(List<HistoryInfo> infos, int id) {
        int newestVersion = this.getId(infos.get(0));
        int oldestVersion = this.getId(infos.get(infos.size() - 1));
        return newestVersion >= id && id >= oldestVersion;
    }

    private class QueryMargins {
        private int belowCenter;
        private int aboveCenter;
        private PrimaryVersionSpec querySpec;

        private QueryMargins() {
        }
    }
}

