/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.table.swt;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecp.edit.internal.swt.controls.ECPFocusCellDrawHighlighter;
import org.eclipse.emf.ecp.edit.internal.swt.controls.TableViewerColumnBuilder;
import org.eclipse.emf.ecp.edit.internal.swt.util.CellEditorFactory;
import org.eclipse.emf.ecp.edit.spi.DeleteService;
import org.eclipse.emf.ecp.edit.spi.EMFDeleteServiceImpl;
import org.eclipse.emf.ecp.edit.spi.swt.table.ECPCellEditor;
import org.eclipse.emf.ecp.edit.spi.swt.util.ECPDialogExecutor;
import org.eclipse.emf.ecp.view.internal.table.swt.CellReadOnlyTesterHelper;
import org.eclipse.emf.ecp.view.internal.table.swt.TableConfigurationHelper;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.core.swt.AbstractControlSWTRenderer;
import org.eclipse.emf.ecp.view.spi.model.DiagnosticMessageExtractor;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VDiagnostic;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.reporting.StatusReport;
import org.eclipse.emf.ecp.view.spi.provider.ECPTooltipModifierHelper;
import org.eclipse.emf.ecp.view.spi.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.view.spi.renderer.NoRendererFoundException;
import org.eclipse.emf.ecp.view.spi.swt.reporting.RenderingFailedReport;
import org.eclipse.emf.ecp.view.spi.table.model.VTableControl;
import org.eclipse.emf.ecp.view.spi.table.model.VTableDomainModelReference;
import org.eclipse.emf.ecp.view.spi.util.swt.ImageRegistryService;
import org.eclipse.emf.ecp.view.template.model.VTStyleProperty;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emf.ecp.view.template.style.background.model.VTBackgroundFactory;
import org.eclipse.emf.ecp.view.template.style.background.model.VTBackgroundStyleProperty;
import org.eclipse.emf.ecp.view.template.style.fontProperties.model.VTFontPropertiesFactory;
import org.eclipse.emf.ecp.view.template.style.fontProperties.model.VTFontPropertiesStyleProperty;
import org.eclipse.emf.ecp.view.template.style.tableValidation.model.VTTableValidationFactory;
import org.eclipse.emf.ecp.view.template.style.tableValidation.model.VTTableValidationStyleProperty;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedReport;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.editsupport.EMFFormsEditSupport;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.emfforms.spi.core.services.label.NoLabelFoundException;
import org.eclipse.emfforms.spi.localization.LocalizationServiceHelper;
import org.eclipse.emfforms.spi.swt.core.AbstractSWTRenderer;
import org.eclipse.emfforms.spi.swt.core.layout.GridDescriptionFactory;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridCell;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridDescription;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapCellLabelProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationListener;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ColumnViewerEditorDeactivationEvent;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TableViewerFocusCellManager;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.osgi.framework.FrameworkUtil;

public class TableControlSWTRenderer
extends AbstractControlSWTRenderer<VTableControl> {
    private SWTGridDescription rendererGridDescription;
    private static final String FIXED_COLUMNS = "org.eclipse.rap.rwt.fixedColumns";
    private static final String ICON_ADD = "icons/add.png";
    private static final String ICON_DELETE = "icons/delete.png";
    private static final String RESIZABLE = "resizable";
    private static final String WEIGHT = "weight";
    private static final String MIN_WIDTH = "min_width";
    private static final String WIDTH = "width";
    private TableViewer tableViewer;
    private Label validationIcon;
    private Button addButton;
    private Button removeButton;
    private final ImageRegistryService imageRegistryService;
    private final EMFDataBindingContext viewModelDBC;
    private final EMFFormsEditSupport emfFormsEditSupport;

    @Inject
    public TableControlSWTRenderer(VTableControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabinding emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider, ImageRegistryService imageRegistryService, EMFFormsEditSupport emfFormsEditSupport) {
        super((VControl)vElement, viewContext, reportService, emfFormsDatabinding, emfFormsLabelProvider, vtViewTemplateProvider);
        this.imageRegistryService = imageRegistryService;
        this.emfFormsEditSupport = emfFormsEditSupport;
        this.viewModelDBC = new EMFDataBindingContext();
    }

    public SWTGridDescription getGridDescription(SWTGridDescription gridDescription) {
        if (this.rendererGridDescription == null) {
            this.rendererGridDescription = GridDescriptionFactory.INSTANCE.createSimpleGrid(1, 1, (AbstractSWTRenderer)this);
        }
        return this.rendererGridDescription;
    }

    protected Control renderControl(SWTGridCell gridCell, Composite parent) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        IObservableValue observableValue;
        VTableDomainModelReference tableDomainModelReference = (VTableDomainModelReference)((VTableControl)this.getVElement()).getDomainModelReference();
        VTableDomainModelReference dmrToCheck = tableDomainModelReference.getDomainModelReference() == null ? tableDomainModelReference : tableDomainModelReference.getDomainModelReference();
        try {
            observableValue = this.getEMFFormsDatabinding().getObservableValue((VDomainModelReference)dmrToCheck, this.getViewModelContext().getDomainModel());
        }
        catch (DatabindingFailedException ex) {
            this.getReportService().report((AbstractReport)new RenderingFailedReport((Throwable)ex));
            return null;
        }
        final EStructuralFeature structuralFeature = (EStructuralFeature)observableValue.getValueType();
        final EObject eObject = (EObject)((IObserving)observableValue).getObserved();
        observableValue.dispose();
        final EClass clazz = ((EReference)structuralFeature).getEReferenceType();
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setBackground(parent.getBackground());
        Composite titleComposite = new Composite(composite, 0);
        titleComposite.setBackground(parent.getBackground());
        GridDataFactory.fillDefaults().grab(true, false).align(4, 1).applyTo((Control)titleComposite);
        GridLayoutFactory.fillDefaults().numColumns(3).equalWidth(false).applyTo(titleComposite);
        Label label = new Label(titleComposite, 0);
        label.setBackground(parent.getBackground());
        EMFFormsLabelProvider labelService = this.getEMFFormsLabelProvider();
        try {
            IObservableValue labelText = labelService.getDisplayName((VDomainModelReference)dmrToCheck, this.getViewModelContext().getDomainModel());
            this.viewModelDBC.bindValue((IObservableValue)SWTObservables.observeText((Control)label), labelText);
            IObservableValue labelTooltipText = labelService.getDescription((VDomainModelReference)dmrToCheck, this.getViewModelContext().getDomainModel());
            this.viewModelDBC.bindValue((IObservableValue)SWTObservables.observeTooltipText((Control)label), labelTooltipText);
        }
        catch (NoLabelFoundException e) {
            this.getReportService().report((AbstractReport)new RenderingFailedReport((Throwable)e));
            label.setText(e.getMessage());
            label.setToolTipText(e.toString());
        }
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).applyTo((Control)label);
        this.validationIcon = this.createValidationIcon(titleComposite);
        GridDataFactory.fillDefaults().hint(16, 17).grab(false, false).applyTo((Control)this.validationIcon);
        Button addButton = null;
        Button removeButton = null;
        Composite buttonComposite = new Composite(titleComposite, 0);
        buttonComposite.setBackground(titleComposite.getBackground());
        GridDataFactory.fillDefaults().align(0x1000008, 1).grab(true, false).applyTo((Control)buttonComposite);
        int numButtons = this.addButtonsToButtonBar(buttonComposite);
        if (!((VTableControl)this.getVElement()).isAddRemoveDisabled()) {
            addButton = this.createAddRowButton(clazz, buttonComposite, eObject, structuralFeature);
            removeButton = this.createRemoveRowButton(clazz, buttonComposite, eObject, structuralFeature);
            numButtons += 2;
        }
        GridLayoutFactory.fillDefaults().numColumns(numButtons).equalWidth(false).applyTo(buttonComposite);
        Composite controlComposite = this.createControlComposite(composite);
        try {
            this.setTableViewer(this.createTableViewer(controlComposite, clazz));
        }
        catch (DatabindingFailedException ex) {
            this.getReportService().report((AbstractReport)new RenderingFailedReport((Throwable)ex));
            Label errorLabel = new Label(parent, 0);
            errorLabel.setText(ex.getMessage());
            return errorLabel;
        }
        if (addButton != null && removeButton != null) {
            final Button finalAddButton = addButton;
            final Button finalRemoveButton = removeButton;
            addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TableControlSWTRenderer.this.addRow(clazz, eObject, structuralFeature);
                    List containments = (List)eObject.eGet(structuralFeature, true);
                    if (structuralFeature.getUpperBound() != -1 && containments.size() >= structuralFeature.getUpperBound()) {
                        finalAddButton.setEnabled(false);
                    }
                    if (containments.size() > structuralFeature.getLowerBound()) {
                        finalRemoveButton.setEnabled(true);
                    }
                }
            });
            removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IStructuredSelection selection = (IStructuredSelection)TableControlSWTRenderer.this.tableViewer.getSelection();
                    if (selection == null || selection.getFirstElement() == null) {
                        return;
                    }
                    ArrayList<EObject> deletionList = new ArrayList<EObject>();
                    Iterator iterator = selection.iterator();
                    while (iterator.hasNext()) {
                        deletionList.add((EObject)iterator.next());
                    }
                    TableControlSWTRenderer.this.deleteRowUserConfirmDialog(deletionList, eObject, structuralFeature, finalAddButton, finalRemoveButton);
                }
            });
        }
        return composite;
    }

    protected int addButtonsToButtonBar(Composite buttonComposite) {
        return 0;
    }

    protected Composite createControlComposite(Composite composite) {
        Composite controlComposite = new Composite(composite, 0);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).hint(1, this.getTableHeightHint()).applyTo((Control)controlComposite);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(controlComposite);
        return controlComposite;
    }

    protected int getTableHeightHint() {
        return 200;
    }

    protected TableViewer getTableViewer() {
        return this.tableViewer;
    }

    protected void setTableViewer(TableViewer tableViewer) {
        this.tableViewer = tableViewer;
    }

    private TableViewer createTableViewer(Composite composite, EClass clazz) throws DatabindingFailedException {
        VTFontPropertiesStyleProperty fontPropertiesStyleProperty;
        TableViewer tableViewer = new TableViewer(composite, 68098);
        tableViewer.getTable().setData("org.eclipse.rap.rwt.customVariant", (Object)"org_eclipse_emf_ecp_control_table");
        tableViewer.getTable().setHeaderVisible(true);
        tableViewer.getTable().setLinesVisible(true);
        VTBackgroundStyleProperty backgroundStyleProperty = this.getBackgroundStyleProperty();
        if (backgroundStyleProperty.getColor() != null) {
            tableViewer.getTable().setBackground(this.getSWTColor(backgroundStyleProperty.getColor()));
        }
        if ((fontPropertiesStyleProperty = this.getFontPropertiesStyleProperty()).getColorHEX() != null) {
            tableViewer.getTable().setForeground(this.getSWTColor(fontPropertiesStyleProperty.getColorHEX()));
        }
        TableViewerFocusCellManager focusCellManager = new TableViewerFocusCellManager(tableViewer, (FocusCellHighlighter)new ECPFocusCellDrawHighlighter((ColumnViewer)tableViewer));
        ColumnViewerEditorActivationStrategy actSupport = new ColumnViewerEditorActivationStrategy((ColumnViewer)tableViewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 5 || event.eventType == 2 || event.eventType == 1 && event.keyCode == 13 || event.eventType == 4;
            }
        };
        TableViewerEditor.create((TableViewer)tableViewer, (SWTFocusCellManager)focusCellManager, (ColumnViewerEditorActivationStrategy)actSupport, (int)58);
        tableViewer.getTable().setData(FIXED_COLUMNS, (Object)new Integer(1));
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)tableViewer);
        ObservableListContentProvider cp = new ObservableListContentProvider();
        InternalEObject tempInstance = null;
        if (!clazz.isAbstract() && !clazz.isInterface()) {
            tempInstance = this.getInstanceOf(clazz);
        }
        ECPTableViewerComparator comparator = new ECPTableViewerComparator();
        tableViewer.setComparator((ViewerComparator)comparator);
        int columnNumber = 0;
        if (!((VTableControl)this.getVElement()).isReadonly()) {
            this.createFixedValidationStatusColumn(tableViewer);
        }
        VTableDomainModelReference tableDomainModelReference = (VTableDomainModelReference)VTableDomainModelReference.class.cast(((VTableControl)this.getVElement()).getDomainModelReference());
        for (VDomainModelReference dmr : tableDomainModelReference.getColumnDomainModelReferences()) {
            IValueProperty valueProperty;
            if (dmr == null) continue;
            try {
                valueProperty = this.getEMFFormsDatabinding().getValueProperty(dmr, this.getViewModelContext().getDomainModel());
            }
            catch (DatabindingFailedException ex) {
                this.getReportService().report((AbstractReport)new RenderingFailedReport((Throwable)ex));
                continue;
            }
            EStructuralFeature eStructuralFeature = (EStructuralFeature)valueProperty.getValueType();
            EMFFormsLabelProvider labelService = this.getEMFFormsLabelProvider();
            CellEditor cellEditor = this.createCellEditor((EObject)tempInstance, eStructuralFeature, tableViewer.getTable());
            TableViewerColumnBuilder columnBuilder = TableViewerColumnBuilder.create().setData(RESIZABLE, (Object)true).setMoveable(false).setStyle(0);
            if (ECPCellEditor.class.isInstance(cellEditor)) {
                columnBuilder.setData(WEIGHT, (Object)((ECPCellEditor)ECPCellEditor.class.cast(cellEditor)).getColumnWidthWeight());
                columnBuilder.setData(MIN_WIDTH, (Object)((ECPCellEditor)ECPCellEditor.class.cast(cellEditor)).getMinWidth());
            } else {
                columnBuilder.setData(WEIGHT, (Object)100);
                columnBuilder.setData(MIN_WIDTH, (Object)0);
            }
            TableViewerColumn column = columnBuilder.build(tableViewer);
            try {
                IObservableValue text = labelService.getDisplayName(dmr);
                this.viewModelDBC.bindValue((IObservableValue)SWTObservables.observeText((Widget)column.getColumn()), text);
                IObservableValue tooltipText = labelService.getDescription(dmr);
                this.viewModelDBC.bindValue((IObservableValue)SWTObservables.observeTooltipText((Widget)column.getColumn()), tooltipText);
            }
            catch (NoLabelFoundException ex) {
                this.getReportService().report((AbstractReport)new RenderingFailedReport((Throwable)ex));
                column.getColumn().setText(ex.getMessage());
                column.getColumn().setToolTipText(ex.toString());
            }
            IObservableMap observableMap = valueProperty.observeDetail(cp.getKnownElements());
            column.setLabelProvider((CellLabelProvider)new ECPCellLabelProvider(eStructuralFeature, cellEditor, observableMap, (VTableControl)this.getVElement(), dmr, tableViewer.getTable()));
            column.getColumn().addSelectionListener((SelectionListener)this.getSelectionAdapter(tableViewer, comparator, column.getColumn(), columnNumber));
            if (!TableConfigurationHelper.isReadOnly((VTableControl)this.getVElement(), dmr)) {
                ECPTableEditingSupport observableSupport = new ECPTableEditingSupport((ColumnViewer)tableViewer, cellEditor, (VTableControl)this.getVElement(), dmr, valueProperty, (EObject)tempInstance);
                column.setEditingSupport((EditingSupport)observableSupport);
            }
            ++columnNumber;
        }
        tableViewer.setContentProvider((IContentProvider)cp);
        IObservableList list = this.getEMFFormsDatabinding().getObservableList((VDomainModelReference)(tableDomainModelReference.getDomainModelReference() == null ? tableDomainModelReference : tableDomainModelReference.getDomainModelReference()), this.getViewModelContext().getDomainModel());
        tableViewer.setInput((Object)list);
        TableColumnLayout layout = new TableColumnLayout();
        composite.setLayout((Layout)layout);
        int i = 0;
        while (i < tableViewer.getTable().getColumns().length) {
            TableColumn tableColumn = tableViewer.getTable().getColumns()[i];
            boolean storedIsResizable = (Boolean)tableColumn.getData(RESIZABLE);
            Integer storedWidth = (Integer)tableColumn.getData(WIDTH);
            if (storedWidth != null) {
                layout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnPixelData(storedWidth.intValue(), storedIsResizable));
            } else {
                Integer storedWeight = (Integer)tableColumn.getData(WEIGHT);
                Integer storedMinWidth = (Integer)tableColumn.getData(MIN_WIDTH);
                layout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(storedWeight.intValue(), storedMinWidth.intValue(), storedIsResizable));
            }
            ++i;
        }
        tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TableControlSWTRenderer.this.viewerSelectionChanged(event);
            }
        });
        return tableViewer;
    }

    protected void viewerSelectionChanged(SelectionChangedEvent event) {
        if (event.getSelection().isEmpty()) {
            if (this.getRemoveButton() != null) {
                this.getRemoveButton().setEnabled(false);
            }
        } else if (this.getRemoveButton() != null) {
            this.getRemoveButton().setEnabled(true);
        }
    }

    private SelectionAdapter getSelectionAdapter(final TableViewer tableViewer, final ECPTableViewerComparator comparator, final TableColumn column, final int index) {
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                comparator.setColumn(index);
                int dir = comparator.getDirection();
                tableViewer.getTable().setSortDirection(dir);
                tableViewer.getTable().setSortColumn(column);
                tableViewer.refresh();
            }
        };
        return selectionAdapter;
    }

    private void createFixedValidationStatusColumn(TableViewer tableViewer) {
        VTTableValidationStyleProperty tableValidationStyleProperty = this.getTableValidationStyleProperty();
        int columnWidth = tableValidationStyleProperty.getColumnWidth();
        String columnName = tableValidationStyleProperty.getColumnName();
        String imagePath = tableValidationStyleProperty.getImagePath();
        TableViewerColumn column = TableViewerColumnBuilder.create().setMoveable(false).setText(columnName).setData(WIDTH, (Object)columnWidth).setData(RESIZABLE, (Object)true).build(tableViewer);
        if (imagePath != null && !imagePath.isEmpty()) {
            Image image = null;
            try {
                image = this.getImage(new File(imagePath).toURI().toURL());
            }
            catch (MalformedURLException ex) {
                ex.printStackTrace();
            }
            if (image != null) {
                column.getColumn().setImage(image);
            }
        }
        column.setLabelProvider((CellLabelProvider)new ValidationStatusCellLabelProvider((VTableControl)this.getVElement()));
    }

    protected Image getImage(URL url) {
        return this.imageRegistryService.getImage(url);
    }

    protected Image getImage(String path) {
        return this.imageRegistryService.getImage(FrameworkUtil.getBundle(((Object)((Object)this)).getClass()), path);
    }

    private VTTableValidationStyleProperty getTableValidationStyleProperty() {
        VTTableValidationStyleProperty tableValidationStyleProperties = this.getStyleProperty(VTTableValidationStyleProperty.class);
        if (tableValidationStyleProperties == null) {
            tableValidationStyleProperties = this.getDefaultTableValidationStyleProperty();
        }
        return tableValidationStyleProperties;
    }

    private VTTableValidationStyleProperty getDefaultTableValidationStyleProperty() {
        VTTableValidationStyleProperty tableValidationProp = VTTableValidationFactory.eINSTANCE.createTableValidationStyleProperty();
        tableValidationProp.setColumnWidth(80);
        tableValidationProp.setColumnName(LocalizationServiceHelper.getString(((Object)((Object)this)).getClass(), (String)"TableControl_ValidationStatusColumn"));
        tableValidationProp.setImagePath(null);
        return tableValidationProp;
    }

    private VTBackgroundStyleProperty getBackgroundStyleProperty() {
        VTBackgroundStyleProperty styleProperty = this.getStyleProperty(VTBackgroundStyleProperty.class);
        if (styleProperty == null) {
            styleProperty = this.getDefaultBackgroundStyleProperty();
        }
        return styleProperty;
    }

    private VTBackgroundStyleProperty getDefaultBackgroundStyleProperty() {
        return VTBackgroundFactory.eINSTANCE.createBackgroundStyleProperty();
    }

    private VTFontPropertiesStyleProperty getFontPropertiesStyleProperty() {
        VTFontPropertiesStyleProperty styleProperty = this.getStyleProperty(VTFontPropertiesStyleProperty.class);
        if (styleProperty == null) {
            styleProperty = this.getDefaultFontPropertiesStyleProperty();
        }
        return styleProperty;
    }

    private VTFontPropertiesStyleProperty getDefaultFontPropertiesStyleProperty() {
        VTFontPropertiesStyleProperty property = VTFontPropertiesFactory.eINSTANCE.createFontPropertiesStyleProperty();
        property.setColorHEX("000000");
        return property;
    }

    private <SP extends VTStyleProperty> SP getStyleProperty(Class<SP> stylePropertyClass) {
        Set styleProperties = this.getVTViewTemplateProvider().getStyleProperties(this.getVElement(), this.getViewModelContext());
        for (VTStyleProperty styleProperty : styleProperties) {
            if (!stylePropertyClass.isInstance(styleProperty)) continue;
            return (SP)((VTStyleProperty)stylePropertyClass.cast(styleProperty));
        }
        return null;
    }

    private Color getSWTColor(String colorHex) {
        String redString = colorHex.substring(0, 2);
        String greenString = colorHex.substring(2, 4);
        String blueString = colorHex.substring(4, 6);
        int red = Integer.parseInt(redString, 16);
        int green = Integer.parseInt(greenString, 16);
        int blue = Integer.parseInt(blueString, 16);
        return new Color((Device)Display.getDefault(), red, green, blue);
    }

    private CellEditor createCellEditor(EObject tempInstance, EStructuralFeature feature, Table table) {
        return CellEditorFactory.INSTANCE.getCellEditor(feature, tempInstance, table, this.getViewModelContext());
    }

    private InternalEObject getInstanceOf(EClass clazz) {
        return (InternalEObject)InternalEObject.class.cast(clazz.getEPackage().getEFactoryInstance().create(clazz));
    }

    private Button createRemoveRowButton(EClass clazz, Composite buttonComposite, EObject eObject, EStructuralFeature structuralFeature) {
        this.removeButton = new Button(buttonComposite, 0);
        Image image = this.getImage(ICON_DELETE);
        this.removeButton.setImage(image);
        this.removeButton.setEnabled(false);
        String instanceName = clazz.getInstanceClass() == null ? "" : clazz.getInstanceClass().getSimpleName();
        this.removeButton.setToolTipText(String.format(LocalizationServiceHelper.getString(((Object)((Object)this)).getClass(), (String)"TableControl_RemoveSelected"), instanceName));
        List containments = (List)eObject.eGet(structuralFeature, true);
        if (containments.size() <= structuralFeature.getLowerBound()) {
            this.removeButton.setEnabled(false);
        }
        return this.removeButton;
    }

    private Button createAddRowButton(EClass clazz, Composite buttonComposite, EObject eObject, EStructuralFeature structuralFeature) {
        this.addButton = new Button(buttonComposite, 0);
        Image image = this.getImage(ICON_ADD);
        this.addButton.setImage(image);
        String instanceName = clazz.getInstanceClass() == null ? "" : clazz.getInstanceClass().getSimpleName();
        this.addButton.setToolTipText(String.format(LocalizationServiceHelper.getString(((Object)((Object)this)).getClass(), (String)"TableControl_AddInstanceOf"), instanceName));
        List containments = (List)eObject.eGet(structuralFeature, true);
        if (structuralFeature.getUpperBound() != -1 && containments.size() >= structuralFeature.getUpperBound()) {
            this.addButton.setEnabled(false);
        }
        return this.addButton;
    }

    protected void deleteRowUserConfirmDialog(final List<EObject> deletionList, final EObject eObject, final EStructuralFeature structuralFeature, final Button addButton, final Button removeButton) {
        MessageDialog dialog = new MessageDialog(addButton.getShell(), LocalizationServiceHelper.getString(((Object)((Object)this)).getClass(), (String)"TableControl_Delete"), null, LocalizationServiceHelper.getString(((Object)((Object)this)).getClass(), (String)"TableControl_DeleteAreYouSure"), 5, new String[]{JFaceResources.getString((String)"yes"), JFaceResources.getString((String)"no")}, 0);
        new ECPDialogExecutor((Dialog)dialog){

            public void handleResult(int codeResult) {
                if (codeResult == 1) {
                    return;
                }
                TableControlSWTRenderer.this.deleteRows(deletionList, eObject, structuralFeature);
                List containments = (List)eObject.eGet(structuralFeature, true);
                if (containments.size() < structuralFeature.getUpperBound()) {
                    addButton.setEnabled(true);
                }
                if (containments.size() <= structuralFeature.getLowerBound()) {
                    removeButton.setEnabled(false);
                }
            }
        }.execute();
    }

    protected void deleteRows(List<EObject> deletionList, EObject eObject, EStructuralFeature structuralFeature) {
        EditingDomain editingDomain = this.getEditingDomain(eObject);
        EReference reference = (EReference)EReference.class.cast(structuralFeature);
        ArrayList<EObject> toDelete = new ArrayList<EObject>(deletionList);
        if (reference.isContainment()) {
            DeleteService deleteService = (DeleteService)this.getViewModelContext().getService(DeleteService.class);
            if (deleteService == null) {
                deleteService = new EMFDeleteServiceImpl();
            }
            deleteService.deleteElements(toDelete);
        } else {
            this.removeElements(editingDomain, eObject, (EStructuralFeature)reference, toDelete);
        }
    }

    private void removeElements(EditingDomain editingDomain, Object source, EStructuralFeature feature, Collection<Object> toRemove) {
        Command removeCommand = RemoveCommand.create((EditingDomain)editingDomain, (Object)source, (Object)feature, toRemove);
        if (removeCommand.canExecute()) {
            if (editingDomain.getCommandStack() == null) {
                removeCommand.execute();
            } else {
                editingDomain.getCommandStack().execute(removeCommand);
            }
        }
    }

    protected void addRow(EClass clazz, EObject eObject, EStructuralFeature structuralFeature) {
        if (clazz.isAbstract() || clazz.isInterface()) {
            this.getReportService().report((AbstractReport)new StatusReport(new Status(2, "org.eclipse.emf.ecp.view.table.ui.swt", String.format("The class %1$s is abstract or an interface.", clazz.getName()))));
        }
        EObject instance = clazz.getEPackage().getEFactoryInstance().create(clazz);
        EditingDomain editingDomain = this.getEditingDomain(eObject);
        editingDomain.getCommandStack().execute(AddCommand.create((EditingDomain)editingDomain, (Object)eObject, (Object)structuralFeature, (Object)instance));
    }

    protected void applyValidation() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IObservableValue observableValue;
                if (TableControlSWTRenderer.this.validationIcon == null) {
                    return;
                }
                if (TableControlSWTRenderer.this.validationIcon.isDisposed()) {
                    return;
                }
                if (((VTableControl)TableControlSWTRenderer.this.getVElement()).getDiagnostic() == null) {
                    return;
                }
                VTableDomainModelReference tableDMR = (VTableDomainModelReference)((VTableControl)TableControlSWTRenderer.this.getVElement()).getDomainModelReference();
                try {
                    observableValue = tableDMR.getDomainModelReference() != null ? TableControlSWTRenderer.this.getEMFFormsDatabinding().getObservableValue(tableDMR.getDomainModelReference(), TableControlSWTRenderer.this.getViewModelContext().getDomainModel()) : TableControlSWTRenderer.this.getEMFFormsDatabinding().getObservableValue((VDomainModelReference)tableDMR, TableControlSWTRenderer.this.getViewModelContext().getDomainModel());
                }
                catch (DatabindingFailedException ex) {
                    TableControlSWTRenderer.this.getReportService().report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
                    return;
                }
                EStructuralFeature structuralFeature = (EStructuralFeature)observableValue.getValueType();
                EObject eObject = (EObject)((IObserving)observableValue).getObserved();
                observableValue.dispose();
                TableControlSWTRenderer.this.validationIcon.setImage(TableControlSWTRenderer.this.getValidationIcon(((VTableControl)TableControlSWTRenderer.this.getVElement()).getDiagnostic().getHighestSeverity()));
                TableControlSWTRenderer.this.validationIcon.setToolTipText(ECPTooltipModifierHelper.modifyString((String)((VTableControl)TableControlSWTRenderer.this.getVElement()).getDiagnostic().getMessage(), null));
                Collection collection = (Collection)eObject.eGet(structuralFeature, true);
                if (!collection.isEmpty()) {
                    for (Object object : collection) {
                        TableControlSWTRenderer.this.tableViewer.update(object, null);
                    }
                }
            }
        });
    }

    protected Button getAddButton() {
        return this.addButton;
    }

    protected Button getRemoveButton() {
        return this.removeButton;
    }

    protected void applyEnable() {
        if (this.getAddButton() != null) {
            this.getAddButton().setVisible(((VTableControl)this.getVElement()).isEnabled() && !((VTableControl)this.getVElement()).isReadonly());
        }
        if (this.getRemoveButton() != null) {
            this.getRemoveButton().setVisible(((VTableControl)this.getVElement()).isEnabled() && !((VTableControl)this.getVElement()).isReadonly());
        }
    }

    protected void applyReadOnly() {
        if (this.getAddButton() != null) {
            this.getAddButton().setVisible(((VTableControl)this.getVElement()).isEnabled() && !((VTableControl)this.getVElement()).isReadonly());
        }
        if (this.getRemoveButton() != null) {
            this.getRemoveButton().setVisible(((VTableControl)this.getVElement()).isEnabled() && !((VTableControl)this.getVElement()).isReadonly());
        }
    }

    protected void dispose() {
        this.rendererGridDescription = null;
        this.viewModelDBC.dispose();
        super.dispose();
    }

    public class ECPCellLabelProvider
    extends ObservableMapCellLabelProvider
    implements IColorProvider {
        private final EStructuralFeature feature;
        private final CellEditor cellEditor;
        private final VTableControl vTableControl;
        private final VDomainModelReference dmr;
        private final Table table;

        public ECPCellLabelProvider(EStructuralFeature feature, CellEditor cellEditor, IObservableMap attributeMap, VTableControl vTableControl, VDomainModelReference dmr, Table table) {
            super(attributeMap);
            this.vTableControl = vTableControl;
            this.feature = feature;
            this.cellEditor = cellEditor;
            this.dmr = dmr;
            this.table = table;
        }

        public String getToolTipText(Object element) {
            String message;
            IObservableValue observableValue;
            EObject domainObject = (EObject)element;
            try {
                observableValue = TableControlSWTRenderer.this.getEMFFormsDatabinding().getObservableValue(this.dmr, domainObject);
            }
            catch (DatabindingFailedException ex) {
                TableControlSWTRenderer.this.getReportService().report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
                return null;
            }
            EStructuralFeature structuralFeature = (EStructuralFeature)observableValue.getValueType();
            EObject eObject = (EObject)((IObserving)observableValue).getObserved();
            EStructuralFeature.Setting setting = ((InternalEObject)eObject).eSetting(structuralFeature);
            observableValue.dispose();
            VDiagnostic vDiagnostic = this.vTableControl.getDiagnostic();
            if (vDiagnostic != null && (message = DiagnosticMessageExtractor.getMessage((Collection)vDiagnostic.getDiagnostic(domainObject, this.feature))) != null && !message.isEmpty()) {
                return ECPTooltipModifierHelper.modifyString((String)message, (EStructuralFeature.Setting)setting);
            }
            Object value = eObject.eGet(structuralFeature, true);
            if (value == null) {
                return null;
            }
            return ECPTooltipModifierHelper.modifyString((String)String.valueOf(value), (EStructuralFeature.Setting)setting);
        }

        public void update(ViewerCell cell) {
            EObject element = (EObject)cell.getElement();
            Object value = this.attributeMaps[0].get((Object)element);
            if (ECPCellEditor.class.isInstance(this.cellEditor)) {
                ECPCellEditor ecpCellEditor = (ECPCellEditor)this.cellEditor;
                String text = ecpCellEditor.getFormatedString(value);
                cell.setText(text == null ? "" : text);
                cell.setImage(ecpCellEditor.getImage(value));
            } else {
                cell.setText(value == null ? "" : value.toString());
                cell.getControl().setData("org.eclipse.rap.rwt.customVariant", (Object)"org_eclipse_emf_ecp_edit_cellEditor_string");
            }
            cell.setForeground(this.getForeground(element));
            cell.setBackground(this.getBackground(element));
        }

        public Color getForeground(Object element) {
            return this.table.getForeground();
        }

        public Color getBackground(Object element) {
            VDiagnostic vDiagnostic = this.vTableControl.getDiagnostic();
            if (vDiagnostic == null) {
                return TableControlSWTRenderer.this.getValidationBackgroundColor(0);
            }
            List diagnostic = vDiagnostic.getDiagnostic((EObject)element, this.feature);
            return TableControlSWTRenderer.this.getValidationBackgroundColor(diagnostic.size() == 0 ? 0 : ((Diagnostic)diagnostic.get(0)).getSeverity());
        }
    }

    private class ECPTableEditingSupport
    extends EditingSupport {
        private final CellEditor cellEditor;
        private final VTableControl tableControl;
        private final IValueProperty valueProperty;
        private final VDomainModelReference domainModelReference;
        private final EObject dmrRootEObject;
        private EditingState editingState;
        private final ColumnViewerEditorActivationListenerHelper activationListener;

        public ECPTableEditingSupport(ColumnViewer viewer, CellEditor cellEditor, VTableControl tableControl, VDomainModelReference domainModelReference, IValueProperty valueProperty, EObject dmrRootEObject) {
            super(viewer);
            this.activationListener = new ColumnViewerEditorActivationListenerHelper();
            this.cellEditor = cellEditor;
            this.tableControl = tableControl;
            this.valueProperty = valueProperty;
            this.domainModelReference = domainModelReference;
            this.dmrRootEObject = dmrRootEObject;
        }

        protected boolean canEdit(Object element) {
            boolean editable = this.tableControl.isEnabled() && !this.tableControl.isReadonly();
            IObservableValue observableValue = this.valueProperty.observe(element);
            EObject eObject = (EObject)((IObserving)observableValue).getObserved();
            EStructuralFeature structuralFeature = (EStructuralFeature)observableValue.getValueType();
            EStructuralFeature.Setting setting = ((InternalEObject)eObject).eSetting(structuralFeature);
            editable &= TableControlSWTRenderer.this.emfFormsEditSupport.canSetProperty(this.domainModelReference, (EObject)element);
            editable &= !CellReadOnlyTesterHelper.getInstance().isReadOnly((VTableControl)TableControlSWTRenderer.this.getVElement(), setting);
            if (ECPCellEditor.class.isInstance(this.cellEditor)) {
                ((ECPCellEditor)ECPCellEditor.class.cast(this.cellEditor)).setEditable(editable);
                return true;
            }
            return editable;
        }

        protected Object getValue(Object element) {
            return null;
        }

        protected void setValue(Object element, Object value) {
        }

        protected void initializeCellEditorValue(CellEditor cellEditor, ViewerCell cell) {
            IObservableValue target = this.doCreateCellEditorObservable(cellEditor);
            Assert.isNotNull((Object)target, (String)"doCreateCellEditorObservable(...) did not return an observable");
            IObservableValue model = this.valueProperty.observe(cell.getElement());
            Assert.isNotNull((Object)model, (String)"The databinding service did not return an observable");
            Binding binding = this.createBinding(target, model);
            Assert.isNotNull((Object)binding, (String)"createBinding(...) did not return a binding");
            this.editingState = new EditingState(binding, target, model);
            this.getViewer().getColumnViewerEditor().addEditorActivationListener((ColumnViewerEditorActivationListener)this.activationListener);
        }

        protected CellEditor getCellEditor(Object element) {
            return this.cellEditor;
        }

        protected Binding createBinding(IObservableValue target, IObservableValue model) {
            if (ECPCellEditor.class.isInstance(this.cellEditor)) {
                return TableControlSWTRenderer.this.getDataBindingContext().bindValue(target, model, ((ECPCellEditor)this.cellEditor).getTargetToModelStrategy(TableControlSWTRenderer.this.getDataBindingContext()), ((ECPCellEditor)this.cellEditor).getModelToTargetStrategy(TableControlSWTRenderer.this.getDataBindingContext()));
            }
            return TableControlSWTRenderer.this.getDataBindingContext().bindValue(target, model);
        }

        protected IObservableValue doCreateCellEditorObservable(CellEditor cellEditor) {
            if (ECPCellEditor.class.isInstance(cellEditor)) {
                return ((ECPCellEditor)cellEditor).getValueProperty().observe((Object)cellEditor);
            }
            return SWTObservables.observeText((Control)cellEditor.getControl(), (int)16);
        }

        protected final void saveCellEditorValue(CellEditor cellEditor, ViewerCell cell) {
            this.editingState.binding.updateTargetToModel();
        }

        private class ColumnViewerEditorActivationListenerHelper
        extends ColumnViewerEditorActivationListener {
            private ColumnViewerEditorActivationListenerHelper() {
            }

            public void afterEditorActivated(ColumnViewerEditorActivationEvent event) {
                Control control = ECPTableEditingSupport.this.cellEditor.getControl();
                if (control == null || control.isDisposed()) {
                    return;
                }
                control.setBackground(ECPTableEditingSupport.this.getViewer().getControl().getBackground());
                control.setForeground(ECPTableEditingSupport.this.getViewer().getControl().getForeground());
            }

            public void afterEditorDeactivated(ColumnViewerEditorDeactivationEvent event) {
                ECPTableEditingSupport.this.editingState.dispose();
                ECPTableEditingSupport.this.editingState = null;
                ECPTableEditingSupport.this.getViewer().getColumnViewerEditor().removeEditorActivationListener((ColumnViewerEditorActivationListener)this);
                ViewerCell focusCell = ECPTableEditingSupport.this.getViewer().getColumnViewerEditor().getFocusCell();
                if (focusCell != null) {
                    ECPTableEditingSupport.this.getViewer().update(focusCell.getElement(), null);
                }
            }

            public void beforeEditorActivated(ColumnViewerEditorActivationEvent event) {
            }

            public void beforeEditorDeactivated(ColumnViewerEditorDeactivationEvent event) {
            }
        }

        class EditingState {
            private final IObservableValue target;
            private final IObservableValue model;
            private final Binding binding;

            EditingState(Binding binding, IObservableValue target, IObservableValue model) {
                this.binding = binding;
                this.target = target;
                this.model = model;
            }

            void dispose() {
                this.binding.dispose();
                this.target.dispose();
                this.model.dispose();
            }
        }
    }

    private class ECPTableViewerComparator
    extends ViewerComparator {
        private int propertyIndex = 0;
        private static final int NONE = 0;
        private int direction = 0;

        public int getDirection() {
            switch (this.direction) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 128;
                }
                case 2: {
                    return 1024;
                }
            }
            return 0;
        }

        public void setColumn(int column) {
            if (column == this.propertyIndex) {
                this.direction = (this.direction + 1) % 3;
            } else {
                this.propertyIndex = column;
                this.direction = 1;
            }
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            Object value2;
            Object value1;
            if (this.direction == 0) {
                return 0;
            }
            int rc = 0;
            EObject object1 = (EObject)e1;
            EObject object2 = (EObject)e2;
            VDomainModelReference dmr = (VDomainModelReference)((VTableDomainModelReference)((VTableControl)TableControlSWTRenderer.this.getVElement()).getDomainModelReference()).getColumnDomainModelReferences().get(this.propertyIndex);
            EMFFormsDatabinding emfFormsDatabinding = TableControlSWTRenderer.this.getEMFFormsDatabinding();
            try {
                IObservableValue observableValue1 = emfFormsDatabinding.getObservableValue(dmr, object1);
                EStructuralFeature structuralFeature1 = (EStructuralFeature)observableValue1.getValueType();
                EObject observed1 = (EObject)((IObserving)observableValue1).getObserved();
                value1 = observed1.eGet(structuralFeature1, true);
                observableValue1.dispose();
            }
            catch (DatabindingFailedException databindingFailedException) {
                value1 = null;
            }
            try {
                IObservableValue observableValue2 = emfFormsDatabinding.getObservableValue(dmr, object2);
                EStructuralFeature structuralFeature2 = (EStructuralFeature)observableValue2.getValueType();
                EObject observed2 = (EObject)((IObserving)observableValue2).getObserved();
                value2 = observed2.eGet(structuralFeature2, true);
                observableValue2.dispose();
            }
            catch (DatabindingFailedException databindingFailedException) {
                value2 = null;
            }
            rc = value1 == null ? 1 : (value2 == null ? -1 : value1.toString().compareTo(value2.toString()));
            if (this.direction == 2) {
                rc = -rc;
            }
            return rc;
        }
    }

    private class ValidationStatusCellLabelProvider
    extends CellLabelProvider {
        private final VTableControl vTableControl;

        public ValidationStatusCellLabelProvider(VTableControl vTableControl) {
            this.vTableControl = vTableControl;
        }

        public void update(ViewerCell cell) {
            Integer mostSevere = 0;
            VDiagnostic vDiagnostic = this.vTableControl.getDiagnostic();
            if (vDiagnostic == null) {
                return;
            }
            List diagnostics = vDiagnostic.getDiagnostics((EObject)cell.getElement());
            if (diagnostics.size() != 0) {
                mostSevere = ((Diagnostic)diagnostics.get(0)).getSeverity();
            }
            cell.setImage(TableControlSWTRenderer.this.getValidationIcon(mostSevere));
        }

        public String getToolTipText(Object element) {
            VDiagnostic vDiagnostic = this.vTableControl.getDiagnostic();
            String message = DiagnosticMessageExtractor.getMessage((Collection)vDiagnostic.getDiagnostics((EObject)element));
            return ECPTooltipModifierHelper.modifyString((String)message, null);
        }
    }
}

