/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.editor.controls;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.edit.internal.swt.reference.DeleteReferenceAction;
import org.eclipse.emf.ecp.edit.internal.swt.reference.LinkControl;
import org.eclipse.emf.ecp.edit.spi.ReferenceService;
import org.eclipse.emf.ecp.view.editor.controls.AbstractFilteredReferenceAction;
import org.eclipse.emf.ecp.view.editor.controls.AbstractFilteredReferenceCommand;
import org.eclipse.emf.ecp.view.editor.controls.Helper;
import org.eclipse.emf.ecp.view.spi.model.VFeaturePathDomainModelReference;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class ControlTargetFeatureControl
extends LinkControl {
    protected int getNumButtons() {
        return 2;
    }

    protected Object getLinkText(Object value) {
        VFeaturePathDomainModelReference modelReference = (VFeaturePathDomainModelReference)this.getFirstSetting().getEObject();
        String className = "";
        String attributeName = " -> " + this.getAdapterFactoryItemDelegator().getText(value);
        String referencePath = "";
        for (EReference ref : modelReference.getDomainModelEReferencePath()) {
            if (className.isEmpty()) {
                className = ref.getEContainingClass().getName();
            }
            referencePath = String.valueOf(referencePath) + " -> " + this.getAdapterFactoryItemDelegator().getText((Object)ref);
        }
        if (className.isEmpty() && modelReference.getDomainModelEFeature() != null && modelReference.getDomainModelEFeature().getEContainingClass() != null) {
            className = modelReference.getDomainModelEFeature().getEContainingClass().getName();
        }
        String linkText = String.valueOf(className) + referencePath + attributeName;
        return linkText;
    }

    protected Button[] createButtons(Composite composite) {
        Button[] buttons = new Button[2];
        final EStructuralFeature.Setting setting = this.getFirstSetting();
        buttons[0] = this.createButtonForAction((Action)new DeleteReferenceAction(this.getEditingDomain(setting), setting, this.getItemPropertyDescriptor(setting), (ReferenceService)this.getService(ReferenceService.class)){

            public void run() {
                super.run();
                VFeaturePathDomainModelReference modelReference = (VFeaturePathDomainModelReference)setting.getEObject();
                modelReference.getDomainModelEReferencePath().clear();
                modelReference.setDomainModelEFeature(null);
            }
        }, composite);
        buttons[1] = this.createButtonForAction((Action)new FilteredReferenceAction(this.getEditingDomain(setting), setting, this.getItemPropertyDescriptor(setting), composite.getShell()), composite);
        return buttons;
    }

    protected boolean allowMultiSelection() {
        return false;
    }

    private class FilteredReferenceAction
    extends AbstractFilteredReferenceAction {
        public FilteredReferenceAction(EditingDomain editingDomain, EStructuralFeature.Setting setting, IItemPropertyDescriptor descriptor, Shell shell) {
            super(editingDomain, setting, descriptor, shell);
        }

        public void run() {
            this.getEditingDomain().getCommandStack().execute((Command)new FilteredReferenceCommand((Notifier)this.getSetting().getEObject(), ControlTargetFeatureControl.this.getComposedAdapterFactory(), this.getShell()));
        }
    }

    private class FilteredReferenceCommand
    extends AbstractFilteredReferenceCommand<EStructuralFeature> {
        public FilteredReferenceCommand(Notifier notifier, ComposedAdapterFactory composedAdapterFactory, Shell shell) {
            super(notifier, composedAdapterFactory, shell, Helper.getRootEClass((EObject)notifier), new AbstractFilteredReferenceCommand.ECPSelectionStatusValidator(){

                public IStatus validate(Object[] selection) {
                    if (selection.length != 0 && EStructuralFeature.class.isInstance(selection[0])) {
                        TreePath treePath = this.getTreePath();
                        if (!Helper.hasFeaturePropertyDescriptor(((EStructuralFeature)EStructuralFeature.class.cast(selection[0])).getEContainingClass(), treePath)) {
                            return new Status(2, "org.eclipse.emf.ecp.view.editor.controls", "The selected " + EStructuralFeature.class.getSimpleName() + " has no PropertyDescriptor.");
                        }
                        return Status.OK_STATUS;
                    }
                    return new Status(4, "org.eclipse.emf.ecp.view.editor.controls", "This is not an " + EStructuralFeature.class.getSimpleName() + ".");
                }
            }, ControlTargetFeatureControl.this.allowMultiSelection());
        }

        @Override
        protected void setSelectedValues(EStructuralFeature selectedFeature, List<EReference> bottomUpPath) {
            VFeaturePathDomainModelReference modelReference = (VFeaturePathDomainModelReference)ControlTargetFeatureControl.this.getFirstSetting().getEObject();
            modelReference.setDomainModelEFeature(selectedFeature);
            modelReference.getDomainModelEReferencePath().clear();
            modelReference.getDomainModelEReferencePath().addAll(bottomUpPath);
        }
    }
}

