/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.graph.transform;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Set;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LGraphUtil;
import org.eclipse.elk.alg.layered.graph.LLabel;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPadding;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.intermediate.LabelDummySwitcher;
import org.eclipse.elk.alg.layered.options.GraphProperties;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.alg.layered.options.NodeFlexibility;
import org.eclipse.elk.alg.layered.options.NodePlacementStrategy;
import org.eclipse.elk.core.math.ElkPadding;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.math.KVectorChain;
import org.eclipse.elk.core.options.EdgeRouting;
import org.eclipse.elk.core.options.PortConstraints;
import org.eclipse.elk.core.options.PortLabelPlacement;
import org.eclipse.elk.core.options.SizeConstraint;
import org.eclipse.elk.core.options.SizeOptions;
import org.eclipse.elk.core.util.ElkUtil;
import org.eclipse.elk.graph.ElkConnectableShape;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkEdgeSection;
import org.eclipse.elk.graph.ElkLabel;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.ElkPort;
import org.eclipse.elk.graph.util.ElkGraphUtil;

class ElkGraphLayoutTransferrer {
    private static final KVector ZERO_OFFSET = new KVector();

    ElkGraphLayoutTransferrer() {
    }

    public void applyLayout(LGraph lgraph) {
        Object graphOrigin = lgraph.getProperty(InternalProperties.ORIGIN);
        if (!(graphOrigin instanceof ElkNode)) {
            return;
        }
        ElkNode parentElkNode = (ElkNode)graphOrigin;
        LNode parentLNode = lgraph.getParentNode();
        KVector offset = new KVector(lgraph.getOffset());
        LPadding lPadding = lgraph.getPadding();
        offset.x += lPadding.left;
        offset.y += lPadding.top;
        EnumSet sizeOptions = (EnumSet)parentElkNode.getProperty(LayeredOptions.NODE_SIZE_OPTIONS);
        if (sizeOptions.contains(SizeOptions.COMPUTE_PADDING)) {
            ElkPadding padding = (ElkPadding)parentElkNode.getProperty(LayeredOptions.PADDING);
            padding.setBottom(lPadding.bottom);
            padding.setTop(lPadding.top);
            padding.setLeft(lPadding.left);
            padding.setRight(lPadding.right);
        }
        ArrayList edgeList = Lists.newArrayList();
        for (LNode lnode : lgraph.getLayerlessNodes()) {
            if (ElkGraphLayoutTransferrer.representsNode(lnode)) {
                this.applyNodeLayout(lnode, offset);
            } else if (ElkGraphLayoutTransferrer.representsExternalPort(lnode) && parentLNode == null) {
                ElkPort elkport = (ElkPort)lnode.getProperty(InternalProperties.ORIGIN);
                KVector portPosition = LGraphUtil.getExternalPortPosition(lgraph, lnode, elkport.getWidth(), elkport.getHeight());
                elkport.setLocation(portPosition.x, portPosition.y);
            }
            for (LPort port : lnode.getPorts()) {
                port.getOutgoingEdges().stream().filter(edge -> !LGraphUtil.isDescendant(edge.getTarget().getNode(), lnode)).forEach(edge -> {
                    boolean bl = edgeList.add(edge);
                });
            }
        }
        if (parentLNode != null) {
            for (LPort port : parentLNode.getPorts()) {
                port.getOutgoingEdges().stream().filter(edge -> LGraphUtil.isDescendant(edge.getTarget().getNode(), parentLNode)).forEach(edge -> {
                    boolean bl = edgeList.add(edge);
                });
            }
        }
        EdgeRouting routing = (EdgeRouting)parentElkNode.getProperty(LayeredOptions.EDGE_ROUTING);
        for (LEdge ledge : edgeList) {
            this.applyEdgeLayout(ledge, routing, offset, lPadding);
        }
        this.applyParentNodeLayout(lgraph);
        for (LNode lnode : lgraph.getLayerlessNodes()) {
            LGraph nestedGraph = lnode.getNestedGraph();
            if (nestedGraph == null) continue;
            this.applyLayout(nestedGraph);
        }
    }

    private void applyNodeLayout(LNode lnode, KVector offset) {
        ElkNode elknode = (ElkNode)lnode.getProperty(InternalProperties.ORIGIN);
        int nodeID = (Integer)lnode.getProperty(LayeredOptions.CROSSING_MINIMIZATION_POSITION_I_D);
        int layerID = (Integer)lnode.getProperty(LayeredOptions.LAYERING_LAYER_I_D);
        elknode.setProperty(LayeredOptions.CROSSING_MINIMIZATION_POSITION_I_D, (Object)nodeID);
        elknode.setProperty(LayeredOptions.LAYERING_LAYER_I_D, (Object)layerID);
        elknode.setX(lnode.getPosition().x + offset.x);
        elknode.setY(lnode.getPosition().y + offset.y);
        if (!((EnumSet)elknode.getProperty(LayeredOptions.NODE_SIZE_CONSTRAINTS)).isEmpty() || lnode.getNestedGraph() != null || lnode.getGraph().getProperty(LayeredOptions.NODE_PLACEMENT_STRATEGY) == NodePlacementStrategy.NETWORK_SIMPLEX && NodeFlexibility.getNodeFlexibility(lnode).isFlexibleSizeWhereSpacePermits()) {
            elknode.setWidth(lnode.getSize().x);
            elknode.setHeight(lnode.getSize().y);
        }
        for (LPort lport : lnode.getPorts()) {
            Object origin = lport.getProperty(InternalProperties.ORIGIN);
            if (!(origin instanceof ElkPort)) continue;
            ElkPort elkport = (ElkPort)origin;
            elkport.setLocation(lport.getPosition().x, lport.getPosition().y);
            elkport.setProperty(LayeredOptions.PORT_SIDE, (Object)lport.getSide());
        }
        boolean nodeHasLabelPlacement = !((EnumSet)lnode.getProperty(LayeredOptions.NODE_LABELS_PLACEMENT)).isEmpty();
        for (LLabel llabel : lnode.getLabels()) {
            if (!nodeHasLabelPlacement && ((EnumSet)llabel.getProperty(LayeredOptions.NODE_LABELS_PLACEMENT)).isEmpty()) continue;
            ElkLabel elklabel = (ElkLabel)llabel.getProperty(InternalProperties.ORIGIN);
            elklabel.setDimensions(llabel.getSize().x, llabel.getSize().y);
            elklabel.setLocation(llabel.getPosition().x, llabel.getPosition().y);
        }
        if (lnode.getProperty(LayeredOptions.PORT_LABELS_PLACEMENT) != PortLabelPlacement.FIXED) {
            for (LPort lport : lnode.getPorts()) {
                for (LLabel llabel : lport.getLabels()) {
                    ElkLabel elklabel = (ElkLabel)llabel.getProperty(InternalProperties.ORIGIN);
                    elklabel.setWidth(llabel.getSize().x);
                    elklabel.setHeight(llabel.getSize().y);
                    elklabel.setLocation(llabel.getPosition().x, llabel.getPosition().y);
                }
            }
        }
    }

    private void applyEdgeLayout(LEdge ledge, EdgeRouting routing, KVector offset, LPadding additionalPadding) {
        KVector sourcePoint;
        ElkEdge elkedge = (ElkEdge)ledge.getProperty(InternalProperties.ORIGIN);
        if (elkedge == null) {
            return;
        }
        KVectorChain bendPoints = ledge.getBendPoints();
        KVector edgeOffset = new KVector(offset);
        edgeOffset.add(this.calculateHierarchicalOffset(ledge));
        if (LGraphUtil.isDescendant(ledge.getTarget().getNode(), ledge.getSource().getNode())) {
            LPort sourcePort = ledge.getSource();
            sourcePoint = KVector.sum((KVector[])new KVector[]{sourcePort.getPosition(), sourcePort.getAnchor()});
            sourcePoint.sub(offset);
        } else {
            sourcePoint = ledge.getSource().getAbsoluteAnchor();
        }
        bendPoints.addFirst((Object)sourcePoint);
        KVector targetPoint = ledge.getTarget().getAbsoluteAnchor();
        if (ledge.getProperty(InternalProperties.TARGET_OFFSET) != null) {
            targetPoint.add((KVector)ledge.getProperty(InternalProperties.TARGET_OFFSET));
        }
        bendPoints.addLast((Object)targetPoint);
        bendPoints.offset(edgeOffset);
        ElkEdgeSection elkedgeSection = ElkGraphUtil.firstEdgeSection((ElkEdge)elkedge, (boolean)true, (boolean)true);
        elkedgeSection.setIncomingShape((ElkConnectableShape)elkedge.getSources().get(0));
        elkedgeSection.setOutgoingShape((ElkConnectableShape)elkedge.getTargets().get(0));
        ElkUtil.applyVectorChain((KVectorChain)bendPoints, (ElkEdgeSection)elkedgeSection);
        for (LLabel llabel : ledge.getLabels()) {
            ElkLabel elklabel = (ElkLabel)llabel.getProperty(InternalProperties.ORIGIN);
            elklabel.setWidth(llabel.getSize().x);
            elklabel.setHeight(llabel.getSize().y);
            elklabel.setLocation(llabel.getPosition().x + edgeOffset.x, llabel.getPosition().y + edgeOffset.y);
            elklabel.setProperty(LabelDummySwitcher.INCLUDE_LABEL, (Object)((Boolean)llabel.getProperty(LabelDummySwitcher.INCLUDE_LABEL)));
        }
        KVectorChain junctionPoints = (KVectorChain)ledge.getProperty(LayeredOptions.JUNCTION_POINTS);
        if (junctionPoints != null) {
            junctionPoints.offset(edgeOffset);
            elkedge.setProperty(LayeredOptions.JUNCTION_POINTS, (Object)junctionPoints);
        } else {
            elkedge.setProperty(LayeredOptions.JUNCTION_POINTS, null);
        }
        if (routing == EdgeRouting.SPLINES) {
            elkedge.setProperty(LayeredOptions.EDGE_ROUTING, (Object)EdgeRouting.SPLINES);
        } else {
            elkedge.setProperty(LayeredOptions.EDGE_ROUTING, null);
        }
    }

    private KVector calculateHierarchicalOffset(LEdge ledge) {
        LGraph targetCoordinateSystem = (LGraph)ledge.getProperty(InternalProperties.COORDINATE_SYSTEM_ORIGIN);
        if (targetCoordinateSystem != null) {
            KVector result = new KVector();
            LGraph currentGraph = ledge.getSource().getNode().getGraph();
            while (currentGraph != targetCoordinateSystem) {
                LNode representingNode = currentGraph.getParentNode();
                currentGraph = representingNode.getGraph();
                result.add(representingNode.getPosition()).add(currentGraph.getOffset()).add(currentGraph.getPadding().left, currentGraph.getPadding().top);
            }
            return result;
        }
        return ZERO_OFFSET;
    }

    private void applyParentNodeLayout(LGraph lgraph) {
        ElkNode elknode = (ElkNode)lgraph.getProperty(InternalProperties.ORIGIN);
        boolean sizeConstraintsIncludedPortLabels = ((EnumSet)elknode.getProperty(LayeredOptions.NODE_SIZE_CONSTRAINTS)).contains(SizeConstraint.PORT_LABELS);
        if (lgraph.getParentNode() == null) {
            Set graphProps = (Set)lgraph.getProperty(InternalProperties.GRAPH_PROPERTIES);
            KVector actualGraphSize = lgraph.getActualSize();
            if (graphProps.contains((Object)GraphProperties.EXTERNAL_PORTS)) {
                elknode.setProperty(LayeredOptions.PORT_CONSTRAINTS, (Object)PortConstraints.FIXED_POS);
                ElkUtil.resizeNode((ElkNode)elknode, (double)actualGraphSize.x, (double)actualGraphSize.y, (boolean)false, (boolean)true);
            } else {
                ElkUtil.resizeNode((ElkNode)elknode, (double)actualGraphSize.x, (double)actualGraphSize.y, (boolean)true, (boolean)true);
            }
        }
        if (sizeConstraintsIncludedPortLabels) {
            elknode.setProperty(LayeredOptions.NODE_SIZE_CONSTRAINTS, EnumSet.of(SizeConstraint.PORT_LABELS));
        } else {
            elknode.setProperty(LayeredOptions.NODE_SIZE_CONSTRAINTS, (Object)SizeConstraint.fixed());
        }
    }

    private static boolean representsNode(LNode lnode) {
        return lnode.getProperty(InternalProperties.ORIGIN) instanceof ElkNode;
    }

    private static boolean representsExternalPort(LNode lnode) {
        return lnode.getProperty(InternalProperties.ORIGIN) instanceof ElkPort;
    }
}

