/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p5edges.orthogonal;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.eclipse.elk.alg.layered.p5edges.orthogonal.HyperEdgeSegment;
import org.eclipse.elk.alg.layered.p5edges.orthogonal.SegmentDependency;

public final class HyperEdgeCycleBreaker {
    private HyperEdgeCycleBreaker() {
        assert (false);
    }

    /*
     * Unable to fully structure code
     */
    public static void breakCycles(List<HyperEdgeSegment> nodes, Random random) {
        sources = Lists.newLinkedList();
        sinks = Lists.newLinkedList();
        nextMark = -1;
        for (HyperEdgeSegment node : nodes) {
            node.setMark(nextMark--);
            inweight = 0;
            outweight = 0;
            for (SegmentDependency dependency : node.getOutgoingDependencies()) {
                outweight += dependency.getWeight();
            }
            for (SegmentDependency dependency : node.getIncomingDependencies()) {
                inweight += dependency.getWeight();
            }
            node.setInWeight(inweight);
            node.setOutWeight(outweight);
            if (outweight == 0) {
                sinks.add(node);
                continue;
            }
            if (inweight != 0) continue;
            sources.add(node);
        }
        unprocessed = Sets.newTreeSet(nodes);
        markBase = nodes.size();
        nextRight = markBase - 1;
        nextLeft = markBase + 1;
        maxNodes = new ArrayList<HyperEdgeSegment>();
        ** GOTO lbl61
        {
            sink = (HyperEdgeSegment)sinks.removeFirst();
            unprocessed.remove(sink);
            sink.setMark(nextRight--);
            HyperEdgeCycleBreaker.updateNeighbors(sink, sources, sinks);
            do {
                if (!sinks.isEmpty()) continue block3;
                while (!sources.isEmpty()) {
                    source = (HyperEdgeSegment)sources.removeFirst();
                    unprocessed.remove(source);
                    source.setMark(nextLeft++);
                    HyperEdgeCycleBreaker.updateNeighbors(source, sources, sinks);
                }
                maxOutflow = -2147483648;
                for (HyperEdgeSegment node : unprocessed) {
                    outflow = node.getOutWeight() - node.getInWeight();
                    if (outflow < maxOutflow) continue;
                    if (outflow > maxOutflow) {
                        maxNodes.clear();
                        maxOutflow = outflow;
                    }
                    maxNodes.add(node);
                }
                if (maxNodes.isEmpty()) continue;
                maxNode = (HyperEdgeSegment)maxNodes.get(random.nextInt(maxNodes.size()));
                unprocessed.remove(maxNode);
                maxNode.setMark(nextLeft++);
                HyperEdgeCycleBreaker.updateNeighbors(maxNode, sources, sinks);
                maxNodes.clear();
lbl61:
                // 3 sources

            } while (!unprocessed.isEmpty());
        }
        shiftBase = nodes.size() + 1;
        for (HyperEdgeSegment node : nodes) {
            if (node.getMark() >= markBase) continue;
            node.setMark(node.getMark() + shiftBase);
        }
        for (HyperEdgeSegment source : nodes) {
            depIter = source.getOutgoingDependencies().listIterator();
            while (depIter.hasNext()) {
                dependency = depIter.next();
                target = dependency.getTarget();
                if (source.getMark() <= target.getMark()) continue;
                depIter.remove();
                target.getIncomingDependencies().remove(dependency);
                if (dependency.getWeight() <= 0) continue;
                dependency.setSource(target);
                target.getOutgoingDependencies().add(dependency);
                dependency.setTarget(source);
                source.getIncomingDependencies().add(dependency);
            }
        }
    }

    private static void updateNeighbors(HyperEdgeSegment node, List<HyperEdgeSegment> sources, List<HyperEdgeSegment> sinks) {
        for (SegmentDependency dep : node.getOutgoingDependencies()) {
            HyperEdgeSegment target = dep.getTarget();
            if (target.getMark() >= 0 || dep.getWeight() <= 0) continue;
            target.setInWeight(target.getInWeight() - dep.getWeight());
            if (target.getInWeight() > 0 || target.getOutWeight() <= 0) continue;
            sources.add(target);
        }
        for (SegmentDependency dep : node.getIncomingDependencies()) {
            HyperEdgeSegment source = dep.getSource();
            if (source.getMark() >= 0 || dep.getWeight() <= 0) continue;
            source.setOutWeight(source.getOutWeight() - dep.getWeight());
            if (source.getOutWeight() > 0 || source.getInWeight() <= 0) continue;
            sinks.add(source);
        }
    }
}

