/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p3order;

import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.intermediate.greedyswitch.BetweenLayerEdgeTwoNodeCrossingsCounter;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.alg.layered.p3order.ISweepPortDistributor;
import org.eclipse.elk.alg.layered.p3order.counting.CrossingsCounter;
import org.eclipse.elk.alg.layered.p3order.counting.IInitializable;
import org.eclipse.elk.core.options.PortConstraints;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.util.Pair;

public class GreedyPortDistributor
implements ISweepPortDistributor,
IInitializable {
    private CrossingsCounter crossingsCounter;
    private int nPorts;
    private int[] portPos;
    private BetweenLayerEdgeTwoNodeCrossingsCounter hierarchicalCrossingsCounter;

    @Override
    public boolean distributePortsWhileSweeping(LNode[][] nodeOrder, int currentIndex, boolean isForwardSweep) {
        this.initialize(nodeOrder, currentIndex, isForwardSweep);
        return this.distributePortsInLayer(nodeOrder, currentIndex, isForwardSweep);
    }

    private boolean distributePortsInLayer(LNode[][] nodeOrder, int currentIndex, boolean isForwardSweep) {
        PortSide side = isForwardSweep ? PortSide.WEST : PortSide.EAST;
        boolean improved = false;
        LNode[] lNodeArray = nodeOrder[currentIndex];
        int n = lNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            LNode node = lNodeArray[n2];
            if (!((PortConstraints)node.getProperty(LayeredOptions.PORT_CONSTRAINTS)).isOrderFixed()) {
                boolean useHierarchicalCrossCounter;
                LGraph nestedGraph = (LGraph)node.getProperty(InternalProperties.NESTED_LGRAPH);
                boolean bl = useHierarchicalCrossCounter = !node.getPortSideView(side).isEmpty() && nestedGraph != null;
                if (useHierarchicalCrossCounter) {
                    LNode[][] innerGraph = nestedGraph.toNodeArray();
                    this.hierarchicalCrossingsCounter = new BetweenLayerEdgeTwoNodeCrossingsCounter(innerGraph, isForwardSweep ? 0 : innerGraph.length - 1);
                }
                improved |= this.distributePortsOnNode(node, side, useHierarchicalCrossCounter);
            }
            ++n2;
        }
        return improved;
    }

    private boolean distributePortsOnNode(LNode node, PortSide side, boolean useHierarchicalCrosscounter) {
        boolean continueSwitching;
        List ports = node.getPortSideView(side);
        if (side == PortSide.SOUTH || side == PortSide.WEST) {
            ports = Lists.reverse(ports);
        }
        boolean improved = false;
        do {
            continueSwitching = false;
            int i = 0;
            while (i < ports.size() - 1) {
                LPort lowerPort;
                LPort upperPort = (LPort)((Object)ports.get(i));
                if (this.switchingDecreasesCrossings(upperPort, lowerPort = (LPort)((Object)ports.get(i + 1)), node, useHierarchicalCrosscounter)) {
                    improved = true;
                    this.switchPorts(ports, node, i, i + 1);
                    continueSwitching = true;
                }
                ++i;
            }
        } while (continueSwitching);
        return improved;
    }

    private void initForLayers(LNode[] leftLayer, LNode[] rightLayer) {
        this.crossingsCounter.initForCountingBetween(leftLayer, rightLayer);
    }

    private boolean switchingDecreasesCrossings(LPort upperPort, LPort lowerPort, LNode node, boolean useHierarchicalCrosscounter) {
        Pair<Integer, Integer> originalNSwitchedCrossings = this.crossingsCounter.countCrossingsBetweenPortsInBothOrders(upperPort, lowerPort);
        int upperLowerCrossings = (Integer)originalNSwitchedCrossings.getFirst();
        int lowerUpperCrossings = (Integer)originalNSwitchedCrossings.getSecond();
        if (useHierarchicalCrosscounter) {
            LNode upperNode = (LNode)((Object)upperPort.getProperty(InternalProperties.PORT_DUMMY));
            LNode lowerNode = (LNode)((Object)lowerPort.getProperty(InternalProperties.PORT_DUMMY));
            if (upperNode != null && lowerNode != null) {
                this.hierarchicalCrossingsCounter.countBothSideCrossings(upperNode, lowerNode);
                upperLowerCrossings += this.hierarchicalCrossingsCounter.getUpperLowerCrossings();
                lowerUpperCrossings += this.hierarchicalCrossingsCounter.getLowerUpperCrossings();
            }
        }
        return upperLowerCrossings > lowerUpperCrossings;
    }

    private void switchPorts(List<LPort> ports, LNode node, int topPort, int bottomPort) {
        this.crossingsCounter.switchPorts(ports.get(topPort), ports.get(bottomPort));
        LPort lower = ports.get(bottomPort);
        ports.set(bottomPort, ports.get(topPort));
        ports.set(topPort, lower);
    }

    private void initialize(LNode[][] nodeOrder, int currentIndex, boolean isForwardSweep) {
        if (isForwardSweep && currentIndex > 0) {
            this.initForLayers(nodeOrder[currentIndex - 1], nodeOrder[currentIndex]);
        } else if (!isForwardSweep && currentIndex < nodeOrder.length - 1) {
            this.initForLayers(nodeOrder[currentIndex], nodeOrder[currentIndex + 1]);
        } else {
            this.crossingsCounter.initPortPositionsForInLayerCrossings(nodeOrder[currentIndex], isForwardSweep ? PortSide.WEST : PortSide.EAST);
        }
    }

    @Override
    public void initAtNodeLevel(int l, int n, LNode[][] nodeOrder) {
        LNode node = nodeOrder[l][n];
        this.nPorts += node.getPorts().size();
    }

    @Override
    public void initAfterTraversal() {
        this.portPos = new int[this.nPorts];
        this.crossingsCounter = new CrossingsCounter(this.portPos);
    }
}

