/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p3order;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.eclipse.elk.alg.layered.ILayoutPhase;
import org.eclipse.elk.alg.layered.IntermediateProcessingConfiguration;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.intermediate.IntermediateProcessorStrategy;
import org.eclipse.elk.alg.layered.p3order.GraphInfoHolder;
import org.eclipse.elk.alg.layered.p3order.SweepCopy;
import org.eclipse.elk.alg.layered.p3order.counting.CrossMinUtil;
import org.eclipse.elk.alg.layered.properties.InternalProperties;
import org.eclipse.elk.alg.layered.properties.LayeredOptions;
import org.eclipse.elk.core.options.PortConstraints;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public class LayerSweepCrossingMinimizer
implements ILayoutPhase {
    private List<GraphInfoHolder> graphInfoHolders;
    private Set<GraphInfoHolder> graphsWhoseNodeOrderChanged;
    private Random random;
    private long randomSeed;
    private final CrossMinType crossMinType;
    private static final IntermediateProcessingConfiguration INTERMEDIATE_PROCESSING_CONFIGURATION = IntermediateProcessingConfiguration.createEmpty().addBeforePhase3(IntermediateProcessorStrategy.LONG_EDGE_SPLITTER).addBeforePhase4(IntermediateProcessorStrategy.IN_LAYER_CONSTRAINT_PROCESSOR).addAll(IntermediateProcessingConfiguration.Slot.AFTER_PHASE_5, Lists.newArrayList((Object[])new IntermediateProcessorStrategy[]{IntermediateProcessorStrategy.LONG_EDGE_JOINER, IntermediateProcessorStrategy.HIERARCHICAL_NODE_RESIZER}));

    public LayerSweepCrossingMinimizer(CrossMinType cT) {
        this.crossMinType = cT;
    }

    @Override
    public boolean operatesOnFullHierarchy() {
        return true;
    }

    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("Minimize Crossings " + (Object)((Object)this.crossMinType), 1.0f);
        if (layeredGraph.getLayers().isEmpty()) {
            progressMonitor.done();
            return;
        }
        List<GraphInfoHolder> graphsToSweepOn = this.initialize(layeredGraph);
        Consumer<GraphInfoHolder> minimizingMethod = this.chooseMinimizingMethod(graphsToSweepOn);
        this.minimizeCrossings(graphsToSweepOn, minimizingMethod);
        this.transferNodeAndPortOrdersToGraph();
        progressMonitor.done();
    }

    private Consumer<GraphInfoHolder> chooseMinimizingMethod(List<GraphInfoHolder> graphsToSweepOn) {
        GraphInfoHolder parent = graphsToSweepOn.get(0);
        if (!parent.crossMinDeterministic()) {
            return g -> this.compareDifferentRandomizedLayouts((GraphInfoHolder)g);
        }
        if (parent.crossMinAlwaysImproves()) {
            return g -> this.minimizeCrossingsNoCounter((GraphInfoHolder)g);
        }
        return g -> {
            int n = this.minimizeCrossingsWithCounter((GraphInfoHolder)g);
        };
    }

    private void minimizeCrossings(List<GraphInfoHolder> graphsToSweepOn, Consumer<GraphInfoHolder> minimizingMethod) {
        for (GraphInfoHolder gData : graphsToSweepOn) {
            minimizingMethod.accept(gData);
            if (!gData.hasParent()) continue;
            this.setPortOrderOnParentGraph(gData);
        }
    }

    private void setPortOrderOnParentGraph(GraphInfoHolder gData) {
        if (gData.hasExternalPorts()) {
            SweepCopy bestSweep = gData.getBestSweep();
            this.sortPortsByDummyPositionsInLastLayer(bestSweep.nodes(), gData.parent(), true);
            this.sortPortsByDummyPositionsInLastLayer(bestSweep.nodes(), gData.parent(), false);
            gData.parent().setProperty(LayeredOptions.PORT_CONSTRAINTS, PortConstraints.FIXED_ORDER);
        }
    }

    private void minimizeCrossingsNoCounter(GraphInfoHolder gData) {
        boolean isForwardSweep = this.random.nextBoolean();
        boolean improved = true;
        while (improved) {
            improved = false;
            improved = gData.crossMinimizer().setFirstLayerOrder(gData.currentNodeOrder(), isForwardSweep);
            improved |= this.sweepReducingCrossings(gData, isForwardSweep, false);
            boolean bl = isForwardSweep = !isForwardSweep;
        }
        this.setCurrentlyBestNodeOrders();
    }

    private void compareDifferentRandomizedLayouts(GraphInfoHolder gData) {
        this.random.setSeed(this.randomSeed);
        this.graphsWhoseNodeOrderChanged.clear();
        int bestCrossings = Integer.MAX_VALUE;
        int thouroughness = (Integer)gData.lGraph().getProperty(LayeredOptions.THOROUGHNESS);
        int i = 0;
        while (i < thouroughness) {
            int crossings = this.minimizeCrossingsWithCounter(gData);
            if (crossings < bestCrossings) {
                bestCrossings = crossings;
                this.saveAllNodeOrdersOfChangedGraphs();
                if (bestCrossings == 0) break;
            }
            ++i;
        }
    }

    private int minimizeCrossingsWithCounter(GraphInfoHolder gData) {
        int oldNumberOfCrossings;
        boolean isForwardSweep = this.random.nextBoolean();
        gData.crossMinimizer().setFirstLayerOrder(gData.currentNodeOrder(), isForwardSweep);
        this.sweepReducingCrossings(gData, isForwardSweep, true);
        int crossingsInGraph = this.countCurrentNumberOfCrossings(gData);
        do {
            this.setCurrentlyBestNodeOrders();
            if (crossingsInGraph == 0) {
                return 0;
            }
            isForwardSweep = !isForwardSweep;
            oldNumberOfCrossings = crossingsInGraph;
            this.sweepReducingCrossings(gData, isForwardSweep, false);
        } while (oldNumberOfCrossings > (crossingsInGraph = this.countCurrentNumberOfCrossings(gData)));
        return oldNumberOfCrossings;
    }

    private int countCurrentNumberOfCrossings(GraphInfoHolder currentGraph) {
        int totalCrossings = 0;
        ArrayDeque<GraphInfoHolder> countCrossingsIn = new ArrayDeque<GraphInfoHolder>();
        countCrossingsIn.push(currentGraph);
        while (!countCrossingsIn.isEmpty()) {
            GraphInfoHolder gD = (GraphInfoHolder)countCrossingsIn.pop();
            totalCrossings += gD.crossCounter().countAllCrossings(gD.currentNodeOrder());
            for (LGraph childLGraph : gD.childGraphs()) {
                GraphInfoHolder child = this.graphInfoHolders.get(childLGraph.id);
                if (child.dontSweepInto()) continue;
                totalCrossings += this.countCurrentNumberOfCrossings(child);
            }
        }
        return totalCrossings;
    }

    private boolean sweepReducingCrossings(GraphInfoHolder graph, boolean forward, boolean firstSweep) {
        LNode[][] nodes = graph.currentNodeOrder();
        int length = nodes.length;
        boolean improved = graph.portDistributor().distributePortsWhileSweeping(nodes, this.firstIndex(forward, length), forward);
        LNode[] firstLayer = nodes[this.firstIndex(forward, length)];
        improved |= this.sweepInHierarchicalNodes(firstLayer, forward, firstSweep);
        int i = this.firstFree(forward, length);
        while (this.isNotEnd(length, i, forward)) {
            improved |= graph.crossMinimizer().minimizeCrossings(nodes, i, forward, firstSweep);
            improved |= graph.portDistributor().distributePortsWhileSweeping(nodes, i, forward);
            improved |= this.sweepInHierarchicalNodes(nodes[i], forward, firstSweep);
            i += this.next(forward);
        }
        this.graphsWhoseNodeOrderChanged.add(graph);
        return improved;
    }

    private boolean sweepInHierarchicalNodes(LNode[] layer, boolean isForwardSweep, boolean isFirstSweep) {
        boolean improved = false;
        LNode[] lNodeArray = layer;
        int n = layer.length;
        int n2 = 0;
        while (n2 < n) {
            LNode node = lNodeArray[n2];
            if (this.hasNestedGraph(node).booleanValue() && !this.graphInfoHolders.get(this.nestedGraphOf((LNode)node).id).dontSweepInto()) {
                improved |= this.sweepInHierarchicalNode(isForwardSweep, node, isFirstSweep);
            }
            ++n2;
        }
        return improved;
    }

    private boolean sweepInHierarchicalNode(boolean isForwardSweep, LNode node, boolean isFirstSweep) {
        int startIndex;
        LGraph nestedLGraph = this.nestedGraphOf(node);
        GraphInfoHolder nestedGraph = this.graphInfoHolders.get(nestedLGraph.id);
        LNode[][] nestedGraphNodeOrder = nestedGraph.currentNodeOrder();
        LNode firstNode = nestedGraphNodeOrder[startIndex = this.firstIndex(isForwardSweep, nestedGraphNodeOrder.length)][0];
        if (this.isExternalPortDummy(firstNode)) {
            nestedGraphNodeOrder[startIndex] = this.sortPortDummiesByPortPositions(node, nestedGraphNodeOrder[startIndex], this.sideOpposedSweepDirection(isForwardSweep));
        } else {
            nestedGraph.crossMinimizer().setFirstLayerOrder(nestedGraphNodeOrder, isForwardSweep);
        }
        boolean improved = this.sweepReducingCrossings(nestedGraph, isForwardSweep, isFirstSweep);
        this.sortPortsByDummyPositionsInLastLayer(nestedGraph.currentNodeOrder(), nestedGraph.parent(), isForwardSweep);
        return improved;
    }

    private void sortPortsByDummyPositionsInLastLayer(LNode[][] nodeOrder, LNode parent, boolean onRightMostLayer) {
        int endIndex = this.endIndex(onRightMostLayer, nodeOrder.length);
        LNode[] lastLayer = nodeOrder[endIndex];
        if (!this.isExternalPortDummy(lastLayer[0])) {
            return;
        }
        int j = this.firstIndex(onRightMostLayer, lastLayer.length);
        List<LPort> ports = parent.getPorts();
        int i = 0;
        while (i < ports.size()) {
            LPort port = ports.get(i);
            if (this.isOnEndOfSweepSide(port, onRightMostLayer) && this.isHierarchical(port)) {
                ports.set(i, this.originPort(lastLayer[j]));
                j += this.next(onRightMostLayer);
            }
            ++i;
        }
    }

    private LNode[] sortPortDummiesByPortPositions(LNode parentNode, LNode[] layerCloseToNodeEdge, PortSide side) {
        Iterable<LPort> ports = CrossMinUtil.inNorthSouthEastWestOrder(parentNode, side);
        LNode[] sortedDummies = new LNode[layerCloseToNodeEdge.length];
        int i = 0;
        for (LPort port : ports) {
            if (!this.isHierarchical(port)) continue;
            sortedDummies[i++] = this.dummyNodeFor(port);
        }
        return sortedDummies;
    }

    private void saveAllNodeOrdersOfChangedGraphs() {
        for (GraphInfoHolder graph : this.graphsWhoseNodeOrderChanged) {
            graph.setBestNodeNPortOrder(new SweepCopy(graph.currentlyBestNodeAndPortOrder()));
        }
    }

    private void setCurrentlyBestNodeOrders() {
        for (GraphInfoHolder graph : this.graphsWhoseNodeOrderChanged) {
            graph.setCurrentlyBestNodeAndPortOrder(new SweepCopy(graph.currentNodeOrder()));
        }
    }

    private int firstIndex(boolean isForwardSweep, int length) {
        return isForwardSweep ? 0 : length - 1;
    }

    private int endIndex(boolean isForwardSweep, int length) {
        return isForwardSweep ? length - 1 : 0;
    }

    private int firstFree(boolean isForwardSweep, int length) {
        return isForwardSweep ? 1 : length - 2;
    }

    private int next(boolean isForwardSweep) {
        return isForwardSweep ? 1 : -1;
    }

    private boolean isNotEnd(int length, int freeLayerIndex, boolean isForwardSweep) {
        return isForwardSweep ? freeLayerIndex < length : freeLayerIndex >= 0;
    }

    private LGraph nestedGraphOf(LNode node) {
        return (LGraph)node.getProperty(InternalProperties.NESTED_LGRAPH);
    }

    private Boolean hasNestedGraph(LNode node) {
        if (this.nestedGraphOf(node) != null) {
            return true;
        }
        return false;
    }

    private PortSide sideOpposedSweepDirection(boolean isForwardSweep) {
        return isForwardSweep ? PortSide.WEST : PortSide.EAST;
    }

    private boolean isExternalPortDummy(LNode firstNode) {
        return firstNode.getType() == LNode.NodeType.EXTERNAL_PORT;
    }

    private LPort originPort(LNode node) {
        return (LPort)((Object)node.getProperty(InternalProperties.ORIGIN));
    }

    private boolean isHierarchical(LPort port) {
        return (Boolean)port.getProperty(InternalProperties.INSIDE_CONNECTIONS);
    }

    private LNode dummyNodeFor(LPort port) {
        return (LNode)((Object)port.getProperty(InternalProperties.PORT_DUMMY));
    }

    private boolean isOnEndOfSweepSide(LPort port, boolean isForwardSweep) {
        return isForwardSweep ? port.getSide() == PortSide.EAST : port.getSide() == PortSide.WEST;
    }

    private List<GraphInfoHolder> initialize(LGraph rootGraph) {
        this.graphInfoHolders = Lists.newArrayList();
        this.random = (Random)rootGraph.getProperty(InternalProperties.RANDOM);
        this.randomSeed = this.random.nextLong();
        LinkedList graphsToSweepOn = Lists.newLinkedList();
        ArrayList graphs = Lists.newArrayList((Object[])new LGraph[]{rootGraph});
        int i = 0;
        while (i < graphs.size()) {
            LGraph graph = (LGraph)graphs.get(i);
            graph.id = i++;
            GraphInfoHolder gData = new GraphInfoHolder(graph, this.crossMinType, this.graphInfoHolders);
            graphs.addAll(gData.childGraphs());
            this.graphInfoHolders.add(gData);
            if (!gData.dontSweepInto()) continue;
            graphsToSweepOn.add(0, gData);
        }
        this.graphsWhoseNodeOrderChanged = Sets.newHashSet();
        return graphsToSweepOn;
    }

    private void transferNodeAndPortOrdersToGraph() {
        for (GraphInfoHolder gD : this.graphInfoHolders) {
            gD.getBestSweep().transferNodeAndPortOrdersToGraph(gD.lGraph());
        }
    }

    @Override
    public IntermediateProcessingConfiguration getIntermediateProcessingConfiguration(LGraph graph) {
        IntermediateProcessingConfiguration configuration = IntermediateProcessingConfiguration.fromExisting(INTERMEDIATE_PROCESSING_CONFIGURATION);
        configuration.addBeforePhase3(IntermediateProcessorStrategy.PORT_LIST_SORTER);
        return configuration;
    }

    public List<GraphInfoHolder> getGraphData() {
        return this.graphInfoHolders;
    }

    private static interface Consumer<T> {
        public void accept(T var1);
    }

    public static enum CrossMinType {
        BARYCENTER,
        ONE_SIDED_GREEDY_SWITCH,
        TWO_SIDED_GREEDY_SWITCH;

    }
}

