/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lfs;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.List;
import java.util.Map;

public interface Protocol {
    public static final String OPERATION_DOWNLOAD = "download";
    public static final String OPERATION_UPLOAD = "upload";
    public static final String CONTENTTYPE_VND_GIT_LFS_JSON = "application/vnd.git-lfs+json; charset=utf-8";
    public static final String HDR_AUTH = "Authorization";
    public static final String HDR_AUTH_SSH_PREFIX = "Ssh: ";
    public static final String INFO_LFS_ENDPOINT = "/info/lfs";
    public static final String OBJECTS_LFS_ENDPOINT = "/objects/batch";

    public static Gson gson() {
        return new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).disableHtmlEscaping().create();
    }

    public static class Action {
        public String href;
        public Map<String, String> header;
    }

    public static class Error {
        public int code;
        public String message;
    }

    public static class ExpiringAction
    extends Action {
        public String expiresAt;
        public String expiresIn;
    }

    public static class ObjectInfo
    extends ObjectSpec {
        public Map<String, Action> actions;
        public Error error;
    }

    public static class ObjectSpec {
        public String oid;
        public long size;
    }

    public static class Request {
        public String operation;
        public List<ObjectSpec> objects;
    }

    public static class Response {
        public List<ObjectInfo> objects;
    }
}

