/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.util;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.RawParseUtils;

public final class RevCommitUtils {
    private RevCommitUtils() {
    }

    public static RevCommit getCommonAncestor(Repository repo, AnyObjectId commit1, AnyObjectId commit2) throws IOException {
        Assert.isNotNull((Object)repo);
        Assert.isNotNull((Object)commit1);
        Assert.isNotNull((Object)commit2);
        Throwable throwable = null;
        Object var4_5 = null;
        try (RevWalk rw = new RevWalk(repo);){
            rw.setRetainBody(false);
            rw.setRevFilter(RevFilter.MERGE_BASE);
            RevCommit srcRev = rw.lookupCommit(commit1);
            RevCommit dstRev = rw.lookupCommit(commit2);
            rw.markStart(dstRev);
            rw.markStart(srcRev);
            RevCommit result = rw.next();
            if (result != null) {
                rw.parseBody((RevObject)result);
            }
            return result;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static RevCommit getTheirs(Repository repository) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (RevWalk walk = new RevWalk(repository);){
            return RevCommitUtils.getTheirs(repository, walk);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static RevCommit getTheirs(Repository repository, RevWalk walk) throws IOException {
        String target;
        switch (repository.getRepositoryState()) {
            case MERGING: {
                target = "MERGE_HEAD";
                break;
            }
            case CHERRY_PICKING: {
                target = "CHERRY_PICK_HEAD";
                break;
            }
            case REBASING_MERGE: 
            case REBASING_INTERACTIVE: {
                target = RevCommitUtils.readFile(repository.getDirectory(), "rebase-merge" + File.separatorChar + "stopped-sha");
                break;
            }
            case REVERTING: {
                target = "REVERT_HEAD";
                break;
            }
            default: {
                target = "ORIG_HEAD";
            }
        }
        ObjectId theirs = repository.resolve(target);
        if (theirs == null) {
            throw new IOException(MessageFormat.format(CoreText.ValidationUtils_CanNotResolveRefMessage, target));
        }
        return walk.parseCommit((AnyObjectId)theirs);
    }

    private static String readFile(File directory, String fileName) throws IOException {
        byte[] content = IO.readFully((File)new File(directory, fileName));
        int end = content.length;
        while (end > 0 && content[end - 1] == 10) {
            --end;
        }
        return RawParseUtils.decode((byte[])content, (int)0, (int)end);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isContainedInAnyRef(Repository repo, ObjectId commitId, Collection<Ref> refs) throws IOException {
        for (Ref ref : refs) {
            if (!commitId.equals((AnyObjectId)ref.getObjectId())) continue;
            return true;
        }
        int skew = 86400;
        Object object = null;
        Object var5_7 = null;
        try (RevWalk walk = new RevWalk(repo);){
            Ref ref;
            RevCommit refCommit;
            RevCommit commit = walk.parseCommit((AnyObjectId)commitId);
            Iterator<Ref> iterator = refs.iterator();
            do {
                if (iterator.hasNext()) continue;
                walk.dispose();
                return false;
            } while ((refCommit = walk.parseCommit((AnyObjectId)(ref = iterator.next()).getObjectId())).getCommitTime() + 86400 < commit.getCommitTime() || !walk.isMergedInto(commit, refCommit));
            return true;
        }
        catch (Throwable throwable) {
            if (object == null) {
                object = throwable;
                throw object;
            }
            if (object == throwable) throw object;
            ((Throwable)object).addSuppressed(throwable);
            throw object;
        }
    }
}

