/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.java.engine;

import org.eclipse.egf.common.constant.EGFCommonConstants;
import org.eclipse.egf.model.pattern.MethodCall;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternException;
import org.eclipse.egf.model.pattern.PatternMethod;
import org.eclipse.egf.pattern.common.java.AbstractJavaAssemblyContentProvider;
import org.eclipse.egf.pattern.engine.PatternHelper;
import org.eclipse.egf.pattern.utils.JavaMethodGenerationHelper;

public class JavaAssemblyContentProvider
extends AbstractJavaAssemblyContentProvider {
    public JavaAssemblyContentProvider(Pattern pattern) {
        super(pattern, new JavaMethodGenerationHelper("out"));
    }

    protected void call(MethodCall object) throws PatternException {
        this.javaMethodHelper.addCallStatement(object.getCalled());
        this.content.append(EGFCommonConstants.LINE_SEPARATOR);
    }

    protected void addMethodBodies() throws PatternException {
        for (PatternMethod method : PatternHelper.getUserMethods((Pattern)this.pattern)) {
            this.javaMethodHelper.addSignature(method);
            this.content.append(EGFCommonConstants.LINE_SEPARATOR);
            this.content.append("{").append(EGFCommonConstants.LINE_SEPARATOR);
            this.content.append(this.getMethodContent(method)).append(EGFCommonConstants.LINE_SEPARATOR);
            this.content.append("}").append(EGFCommonConstants.LINE_SEPARATOR).append(EGFCommonConstants.LINE_SEPARATOR);
        }
        PatternMethod conditionMethod = this.pattern.getConditionMethod();
        if (conditionMethod != null) {
            this.javaMethodHelper.addConditionSignature(conditionMethod);
            this.content.append(EGFCommonConstants.LINE_SEPARATOR);
            this.content.append("{").append(EGFCommonConstants.LINE_SEPARATOR);
            String methodContent = this.getMethodContent(conditionMethod);
            if (methodContent == null || "".equals(methodContent.trim())) {
                methodContent = this.pattern.getSuperPattern() == null || this.pattern.getSuperPattern().getConditionMethod() == null ? "return true;" : "return super.preCondition();";
            }
            this.content.append(methodContent).append(EGFCommonConstants.LINE_SEPARATOR);
            this.content.append("}").append(EGFCommonConstants.LINE_SEPARATOR).append(EGFCommonConstants.LINE_SEPARATOR);
        }
    }
}

