/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.ui.dialogs;

import java.util.Arrays;
import org.eclipse.egf.common.ui.EGFCommonUIPlugin;
import org.eclipse.egf.core.EGFCorePlugin;
import org.eclipse.egf.core.genmodel.IPlatformGenModel;
import org.eclipse.egf.core.ui.l10n.CoreUIMessages;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class PlatformPackageDialog
extends ElementListSelectionDialog {
    protected boolean isTarget = true;

    public PlatformPackageDialog(Shell parent) {
        super(parent, (ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element == null || !(element instanceof IPlatformGenModel)) {
                    return element == null ? "" : element.toString();
                }
                return ((IPlatformGenModel)element).getURI().toString();
            }

            public Image getImage(Object element) {
                return EGFCommonUIPlugin.getDefault().getImage("elcl16/EPackage.gif");
            }
        });
        this.setMultipleSelection(true);
        this.setMessage(CoreUIMessages._UI_SelectRegisteredPackageURI);
        this.setFilter("*");
        this.setTitle(CoreUIMessages._UI_RegisteredPackageSelection_label);
    }

    public boolean isTarget() {
        return this.isTarget;
    }

    protected void updateElements() {
        Object[] result = null;
        result = this.isTarget ? EGFCorePlugin.getPlatformGenModels() : EPackage.Registry.INSTANCE.keySet().toArray(new Object[EPackage.Registry.INSTANCE.size()]);
        Arrays.sort(result);
        this.setListElements(result);
    }

    protected Control createDialogArea(Composite parent) {
        Composite result = (Composite)super.createDialogArea(parent);
        Composite buttonGroup = new Composite(result, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        buttonGroup.setLayout((Layout)layout);
        final Button targetButton = new Button(buttonGroup, 16);
        targetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PlatformPackageDialog.this.isTarget = targetButton.getSelection();
                PlatformPackageDialog.this.updateElements();
            }
        });
        targetButton.setText(CoreUIMessages._UI_TargetPlatform_label);
        Button runtimeTimeVersionButton = new Button(buttonGroup, 16);
        runtimeTimeVersionButton.setText(CoreUIMessages._UI_RuntimeVersion_label);
        targetButton.setSelection(true);
        this.updateElements();
        return result;
    }
}

