/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.presentation;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.ETypeParameter;
import org.eclipse.emf.ecore.presentation.EGFAdapterFactoryEditingDomain;
import org.eclipse.emf.ecore.presentation.EGFEcoreActionBarContributor;
import org.eclipse.emf.ecore.presentation.EcoreEditor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.ModelEntry;
import org.eclipse.pde.internal.core.IPluginModelListener;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelDelta;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;

public class EGFEcoreEditor
extends EcoreEditor
implements IPluginModelListener {
    public void init(IEditorSite site, IEditorInput editorInput) {
        super.init(site, editorInput);
        PDECore.getDefault().getModelManager().addPluginModelListener((IPluginModelListener)this);
    }

    public void dispose() {
        PDECore.getDefault().getModelManager().removePluginModelListener((IPluginModelListener)this);
        super.dispose();
    }

    public void modelsChanged(PluginModelDelta event) {
        if ((event.getKind() & 2) != 0) {
            ModelEntry[] modelEntryArray = event.getRemovedEntries();
            int n = modelEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                ModelEntry entry = modelEntryArray[n2];
                String id = entry.getId();
                if (id != null && entry.getModel().getUnderlyingResource() == null) {
                    this.handleRemove(entry.getModel());
                }
                ++n2;
            }
        }
    }

    private void handleRemove(IPluginModelBase base) {
        final ArrayList<Resource> innerRemovedResources = new ArrayList<Resource>();
        String model = URI.createPlatformPluginURI((String)(String.valueOf(base.getPluginBase().getId()) + "/"), (boolean)false).toString();
        for (Resource resource : this.editingDomain.getResourceSet().getResources()) {
            if (!resource.getURI().toString().startsWith(model)) continue;
            innerRemovedResources.add(resource);
        }
        if (!innerRemovedResources.isEmpty()) {
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    EGFEcoreEditor.this.removedResources.addAll(innerRemovedResources);
                    if (!EGFEcoreEditor.this.isDirty()) {
                        EGFEcoreEditor.this.getSite().getPage().closeEditor((IEditorPart)EGFEcoreEditor.this, false);
                    }
                }
            });
        }
    }

    public void createModel() {
        this.createModelGen();
        if (!this.editingDomain.getResourceSet().getResources().isEmpty()) {
            TreeIterator i = ((Resource)this.editingDomain.getResourceSet().getResources().get(0)).getAllContents();
            while (i.hasNext()) {
                EObject eObject = (EObject)i.next();
                if (!(eObject instanceof ETypeParameter) && (!(eObject instanceof EGenericType) || ((EGenericType)eObject).getETypeArguments().isEmpty())) continue;
                ((EGFEcoreActionBarContributor)this.getActionBarContributor()).showGenerics(true);
                break;
            }
        }
    }

    protected void initializeEditingDomain() {
        super.initializeEditingDomain();
        this.editingDomain = new EGFAdapterFactoryEditingDomain(this.editingDomain.getAdapterFactory(), this.editingDomain.getCommandStack(), new HashMap<Resource, Boolean>());
    }
}

