/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.common.helper;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.egf.common.EGFCommonPlugin;
import org.eclipse.egf.common.helper.FileHelper;
import org.eclipse.egf.common.l10n.EGFCommonMessages;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaHelper {
    private JavaHelper() {
    }

    private static IFolder findFolder(IPath path) {
        if (path == null) {
            return null;
        }
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
        if (resource == null || !(resource instanceof IFolder)) {
            return null;
        }
        return (IFolder)resource;
    }

    public static String getFileName(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        return "/" + clazz.getName().replaceAll("[.]", "/") + ".class";
    }

    public static URL getResourceURL(Class<?> clazz) {
        try {
            String name = JavaHelper.getFileName(clazz);
            if (name == null) {
            }
            return clazz.getResource(name);
        }
        finally {
            return null;
        }
    }

    public static URL getFileURL(Class<?> clazz) {
        String name;
        block4: {
            name = JavaHelper.getFileName(clazz);
            if (name != null) break block4;
            return null;
        }
        try {
            URL url = clazz.getResource(name);
            if (url != null) {
                return FileLocator.resolve((URL)url);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static ClassLoader getProjectClassLoader(IJavaProject project) throws CoreException {
        final List<URL> urls = JavaHelper.getProjectURLs(project, new HashSet<IJavaProject>());
        return AccessController.doPrivileged(new PrivilegedAction<URLClassLoader>(){

            @Override
            public URLClassLoader run() {
                return new URLClassLoader(urls.toArray(new URL[urls.size()]), JavaHelper.class.getClassLoader()){

                    @Override
                    public final synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                        int i;
                        SecurityManager sm = System.getSecurityManager();
                        if (sm != null && (i = name.lastIndexOf(46)) != -1) {
                            sm.checkPackageAccess(name.substring(0, i));
                        }
                        return super.loadClass(name, resolve);
                    }
                };
            }
        });
    }

    public static List<URL> getProjectURLs(IJavaProject javaProject, Set<IJavaProject> visited) throws CoreException {
        UniqueEList urls = new UniqueEList();
        if (visited.contains(javaProject)) {
            return urls;
        }
        visited.add(javaProject);
        try {
            IFolder folder = JavaHelper.findFolder(javaProject.getOutputLocation());
            if (folder != null) {
                urls.add(new URL("file://" + folder.getLocation().toOSString() + '/'));
            }
            IClasspathEntry[] iClasspathEntryArray = javaProject.getResolvedClasspath(true);
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathContainer classpathContainer;
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() == 3) {
                    folder = JavaHelper.findFolder(entry.getOutputLocation());
                    if (folder != null) {
                        urls.add(new URL("file://" + folder.getLocation().toOSString() + '/'));
                    }
                } else if (entry.getEntryKind() == 2) {
                    IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(entry.getPath().toString());
                    IJavaProject innerJavaProject = JavaCore.create((IProject)project);
                    if (project.exists()) {
                        urls.addAll(JavaHelper.getProjectURLs(innerJavaProject, visited));
                    }
                } else if (entry.getEntryKind() == 1 || entry.getEntryKind() == 4) {
                    urls.add(JavaHelper.getURL(entry.getPath()));
                } else if (entry.getEntryKind() == 5 && (classpathContainer = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)javaProject)) != null) {
                    IClasspathEntry[] iClasspathEntryArray2 = classpathContainer.getClasspathEntries();
                    int n3 = iClasspathEntryArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IClasspathEntry classpathEntry = iClasspathEntryArray2[n4];
                        urls.add(JavaHelper.getURL(classpathEntry.getPath()));
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        catch (Throwable t) {
            throw new CoreException(EGFCommonPlugin.getDefault().newStatus(4, NLS.bind((String)EGFCommonMessages.JavaHelper_AnalysingFailure, (Object)javaProject.getProject().getName()), t));
        }
        return urls;
    }

    private static URL getURL(IPath entry) throws MalformedURLException {
        String path = null;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IPath location = root.getFile(entry).getLocation();
        if (location != null) {
            path = location.toOSString();
        }
        if (path == null) {
            path = entry.toOSString();
        }
        if (entry.toFile() != null && !entry.toFile().isDirectory()) {
            return new URL("file://" + path);
        }
        return new URL("file://" + path + '/');
    }

    public static List<IFolder> getOutputFolders(IJavaProject project) throws CoreException {
        UniqueEList folders = new UniqueEList();
        if (project == null || !project.exists()) {
            return folders;
        }
        IFolder folder = JavaHelper.findFolder(project.getOutputLocation());
        if (folder != null) {
            folders.add(folder);
        }
        IClasspathEntry[] iClasspathEntryArray = project.getResolvedClasspath(true);
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFolder innerFolder;
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() == 3 && (innerFolder = JavaHelper.findFolder(entry.getOutputLocation())) != null) {
                folders.add(innerFolder);
            }
            ++n2;
        }
        return folders;
    }

    public static List<String> getStringOutputFolders(IJavaProject project) throws CoreException {
        UniqueEList outputFoldersAsString = new UniqueEList();
        if (!project.exists()) {
            return outputFoldersAsString;
        }
        List<IFolder> outputFolders = JavaHelper.getOutputFolders(project);
        for (IFolder outputFolder : outputFolders) {
            outputFoldersAsString.add(outputFolder.getFullPath().removeFirstSegments(1).toString());
        }
        return outputFoldersAsString;
    }

    public static boolean deleteJavaFile(IJavaProject project, IPath path, boolean deleteParent) throws CoreException {
        if (project == null || path == null) {
            return false;
        }
        IFolder sourceFolder = JavaHelper.getSourceFolder(project, path);
        if (sourceFolder == null) {
            return false;
        }
        IResource resource = sourceFolder.findMember(path);
        if (resource == null || !(resource instanceof IFile)) {
            return false;
        }
        if (!FileHelper.deleteResource(resource)) {
            return false;
        }
        if (deleteParent) {
            IContainer container = (IContainer)sourceFolder.findMember(path.removeLastSegments(1));
            while (!container.equals((Object)sourceFolder)) {
                try {
                    IResource[] members = container.members();
                    if (members != null && members.length != 0 || !FileHelper.deleteResource((IResource)container)) break;
                    container = container.getParent();
                }
                catch (CoreException ce) {
                    break;
                }
            }
        }
        return true;
    }

    public static IFile getSourceFile(IJavaProject project, IPath path) throws CoreException {
        if (project == null || path == null) {
            return null;
        }
        List<IFolder> folders = JavaHelper.getSourceFolders(project);
        for (IFolder folder : folders) {
            IResource resource = folder.findMember(path);
            if (resource == null || !(resource instanceof IFile)) continue;
            return (IFile)resource;
        }
        return null;
    }

    public static IFolder getSourceFolder(IJavaProject project, IPath path) throws CoreException {
        if (project == null || path == null) {
            return null;
        }
        List<IFolder> folders = JavaHelper.getSourceFolders(project);
        for (IFolder folder : folders) {
            IResource resource = folder.findMember(path);
            if (resource == null) continue;
            return folder;
        }
        return null;
    }

    public static List<IFolder> getSourceFolders(IJavaProject project) throws CoreException {
        UniqueEList folders = new UniqueEList();
        if (project == null || !project.exists()) {
            return folders;
        }
        IClasspathEntry[] iClasspathEntryArray = project.getResolvedClasspath(true);
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFolder innerFolder;
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() == 3 && (innerFolder = JavaHelper.findFolder(entry.getPath())) != null) {
                folders.add(innerFolder);
            }
            ++n2;
        }
        return folders;
    }

    public static List<IFolder> getSourceAndOutputFolders(IJavaProject project) throws CoreException {
        UniqueEList folders = new UniqueEList();
        folders.addAll(JavaHelper.getSourceFolders(project));
        folders.addAll(JavaHelper.getOutputFolders(project));
        return folders;
    }
}

