/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.ui.workbench.views.fc;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.egf.common.ui.helper.ViewerHelper;
import org.eclipse.egf.core.ui.viewers.AbstractAdaptedModelElementContentProvider;
import org.eclipse.egf.core.ui.workbench.EgfWorkbenchActivator;
import org.eclipse.egf.core.ui.workbench.Messages;
import org.eclipse.egf.model.FactoryComponent;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.view.ExtendedPropertySheetPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.INavigatorContentExtension;
import org.eclipse.ui.navigator.INavigatorContentService;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFactoryComponentView
extends CommonNavigator {
    private static final Logger __logger = Logger.getLogger((String)AbstractFactoryComponentView.class.getPackage().getName());
    private static final String TAG_MEMENTO = "memento";
    private static final String TAG_PATTERN_FILTER = "patternFilter";
    private IMemento _memento;
    private IDialogSettings _viewSettings = this.getDialogSettingsSection();
    private PropertySheetPage _propertySheetPage;
    private CommandStackListener _commandStackListener;
    private Text _filterText;
    private PatternFilter _patternFilter = new PatternFilter(){

        protected boolean isParentMatch(Viewer viewer_p, Object element_p) {
            return false;
        }

        protected boolean isLeafMatch(Viewer viewer_p, Object element_p) {
            boolean result = true;
            if (element_p instanceof FactoryComponent) {
                result = super.isLeafMatch(viewer_p, element_p);
            }
            return result;
        }
    };
    private String _enteredPatternFilter;

    protected AbstractFactoryComponentView() {
        this._commandStackListener = new CommandStackListener(){

            public void commandStackChanged(EventObject event_P) {
                final Command mostRecentCommand = ((CommandStack)event_P.getSource()).getMostRecentCommand();
                AbstractFactoryComponentView.this.getViewSite().getShell().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (mostRecentCommand != null) {
                            Collection affectedObjects = mostRecentCommand.getAffectedObjects();
                            AbstractFactoryComponentView.this.handleAffectedObjects(affectedObjects);
                        }
                        if (AbstractFactoryComponentView.this._propertySheetPage != null) {
                            AbstractFactoryComponentView.this._propertySheetPage.refresh();
                        }
                    }
                });
            }
        };
        this.getCommandStack().addCommandStackListener(this._commandStackListener);
    }

    private IDialogSettings getDialogSettingsSection() {
        String sectionName;
        IDialogSettings dialogSettings = EgfWorkbenchActivator.getDefault().getDialogSettings();
        IDialogSettings section = dialogSettings.getSection(sectionName = ((Object)((Object)this)).getClass().getName());
        if (section == null) {
            section = dialogSettings.addNewSection(sectionName);
        }
        return section;
    }

    protected void handleAffectedObjects(Collection<?> affectedObjects_p) {
        this.setSelectionToViewer(affectedObjects_p);
    }

    protected abstract AdapterFactoryEditingDomain getEditingDomain();

    protected CommandStack getCommandStack() {
        return this.getEditingDomain().getCommandStack();
    }

    public Object getAdapter(Class adapter_p) {
        Object result = null;
        result = adapter_p == IPropertySheetPage.class ? this.getPropertySheetPage() : super.getAdapter(adapter_p);
        return result;
    }

    protected abstract String getContentProviderId();

    public IPropertySheetPage getPropertySheetPage() {
        if (this._propertySheetPage == null) {
            AdapterFactoryEditingDomain editingDomain = this.getEditingDomain();
            this._propertySheetPage = new ExtendedPropertySheetPage(editingDomain){

                public void setSelectionToViewer(List<?> selection_p) {
                    AbstractFactoryComponentView.this.setSelectionToViewer(selection_p);
                    AbstractFactoryComponentView.this.setFocus();
                }

                public void setActionBars(IActionBars actionBars_p) {
                    super.setActionBars(actionBars_p);
                }
            };
            ITreeContentProvider contentProvider = this.getContentProvider();
            AdapterFactoryContentProvider propertySourceProvider = null;
            if (contentProvider instanceof AbstractAdaptedModelElementContentProvider) {
                propertySourceProvider = ((AbstractAdaptedModelElementContentProvider)contentProvider).getAdapterFactoryContentProvider();
            } else {
                StringBuilder loggerMessage = new StringBuilder("AbstractFactoryComponentView.getPropertySheetPage(..) _ ");
                loggerMessage.append("no content provider found for current view!!!");
                __logger.error((Object)loggerMessage.toString());
            }
            this._propertySheetPage.setPropertySourceProvider((IPropertySourceProvider)propertySourceProvider);
        }
        return this._propertySheetPage;
    }

    protected ITreeContentProvider getContentProvider() {
        INavigatorContentService navigatorContentService = this.getCommonViewer().getNavigatorContentService();
        INavigatorContentExtension contentExt = navigatorContentService.getContentExtensionById(this.getContentProviderId());
        ITreeContentProvider contentProvider = contentExt.getContentProvider();
        return contentProvider;
    }

    public void setSelectionToViewer(Collection<?> collection) {
        final Collection<?> theSelection = collection;
        if (theSelection != null && !theSelection.isEmpty()) {
            Runnable runnable = new Runnable(){

                public void run() {
                    CommonViewer viewer = AbstractFactoryComponentView.this.getCommonViewer();
                    if (viewer != null) {
                        viewer.setSelection((ISelection)new StructuredSelection(theSelection.toArray()), true);
                    }
                }
            };
            runnable.run();
        }
    }

    public void createPartControl(Composite parent_p) {
        Composite composite = new Composite(parent_p, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.createFilterWidget(composite);
        super.createPartControl(composite);
        CommonViewer commonViewer = this.getCommonViewer();
        commonViewer.getControl().setLayoutData((Object)new GridData(1808));
        commonViewer.addFilter((ViewerFilter)this._patternFilter);
    }

    protected IMemento getMemento() {
        return this._memento;
    }

    public void init(IViewSite site_p, IMemento memento_p) throws PartInitException {
        this._memento = this.restoreViewSettings(memento_p);
        super.init(site_p, this._memento);
    }

    private IMemento restoreViewSettings(IMemento memento_p) {
        String persistedMemento;
        IMemento memento = memento_p;
        if (memento == null && (persistedMemento = this._viewSettings.get(TAG_MEMENTO)) != null) {
            try {
                memento = XMLMemento.createReadRoot((Reader)new StringReader(persistedMemento));
            }
            catch (WorkbenchException workbenchException) {}
        }
        return memento;
    }

    public void dispose() {
        this.saveViewSettings();
        this.getCommonViewer().removeFilter((ViewerFilter)this._patternFilter);
        CommandStack commandStack = this.getCommandStack();
        commandStack.removeCommandStackListener(this._commandStackListener);
        commandStack.flush();
        super.dispose();
    }

    private void saveViewSettings() {
        String rootName = ((Object)((Object)this)).getClass().getSimpleName();
        XMLMemento memento = XMLMemento.createWriteRoot((String)rootName);
        this.saveState((IMemento)memento);
        StringWriter writer = new StringWriter();
        try {
            memento.save((Writer)writer);
            this._viewSettings.put(TAG_MEMENTO, writer.getBuffer().toString());
        }
        catch (IOException iOException) {}
    }

    public void saveState(IMemento memento_p) {
        if (this._enteredPatternFilter != null) {
            memento_p.putString(TAG_PATTERN_FILTER, this._enteredPatternFilter);
        }
        super.saveState(memento_p);
    }

    private void restorePatternFilter(Text text_p, IMemento memento_p) {
        if (memento_p == null || text_p == null) {
            return;
        }
        String patternFilter = memento_p.getString(TAG_PATTERN_FILTER);
        if (patternFilter != null) {
            text_p.setText(patternFilter);
            this.getPatternFilter().setPattern(patternFilter);
            this._enteredPatternFilter = patternFilter;
        }
    }

    protected Label createMessageArea(Composite parent_p) {
        Label label = new Label(parent_p, 0);
        label.setText(Messages.FactoryComponentView_PatternFilterText_Title);
        label.setFont(parent_p.getFont());
        GridData data = new GridData();
        data.grabExcessVerticalSpace = false;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        label.setLayoutData((Object)data);
        return label;
    }

    protected Text createFilterText(Composite parent_p) {
        Text text = new Text(parent_p, 2048);
        GridData data = new GridData();
        data.grabExcessVerticalSpace = false;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        text.setLayoutData((Object)data);
        text.setFont(parent_p.getFont());
        this.restorePatternFilter(text, this.getMemento());
        text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    AbstractFactoryComponentView.this.setFocus();
                }
            }
        });
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event_p) {
                AbstractFactoryComponentView.this._enteredPatternFilter = AbstractFactoryComponentView.this.getFilterTextValue();
                AbstractFactoryComponentView.this.getPatternFilter().setPattern(AbstractFactoryComponentView.this._enteredPatternFilter);
                ViewerHelper.refresh((StructuredViewer)AbstractFactoryComponentView.this.getCommonViewer(), (boolean)false);
            }
        });
        return text;
    }

    protected void createFilterWidget(Composite composite_p) {
        this.createMessageArea(composite_p);
        this._filterText = this.createFilterText(composite_p);
    }

    protected String getFilterTextValue() {
        return this._filterText.getText();
    }

    protected PatternFilter getPatternFilter() {
        return this._patternFilter;
    }
}

