/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.ui.workbench.action.open;

import java.lang.reflect.InvocationTargetException;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.egf.core.ui.EgfUiActivator;
import org.eclipse.egf.core.ui.workbench.action.open.OpenModelElementAction;
import org.eclipse.egf.model.Domain;
import org.eclipse.egf.model.FactoryComponent;
import org.eclipse.egf.model.NamedModelElementWithId;
import org.eclipse.egf.model.data.helper.ModelHelper;
import org.eclipse.egf.model.edit.helper.FactoryComponentHelper;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecoretools.diagram.part.EcoreDiagramEditorUtil;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.part.FileEditorInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenDomainAction
extends OpenModelElementAction {
    private static final Logger __logger = Logger.getLogger((String)OpenDomainAction.class.getPackage().getName());

    public OpenDomainAction(Shell shell_p, ISelectionProvider selectionProvider_p, boolean readOnlyMode_p) {
        super(shell_p, selectionProvider_p, readOnlyMode_p);
    }

    @Override
    protected String getEditorId() {
        String editorId = null;
        if (this.isReadOnly()) {
            editorId = "org.eclipse.emf.ecore.presentation.EcoreEditorID";
        } else {
            IPreferenceStore preferenceStore = EgfUiActivator.getDefault().getPreferenceStore();
            editorId = preferenceStore.getString("Domain_Editor_Id");
        }
        return editorId;
    }

    @Override
    protected Class<?> getModelElementClass() {
        return Domain.class;
    }

    public boolean isEnabled() {
        boolean isEnabled = super.isEnabled();
        if (isEnabled) {
            Domain domain = this.getDomain();
            isEnabled = ModelHelper.isDomainDefined((Domain)domain);
        }
        return isEnabled;
    }

    protected URI getDomainURI(Domain domain_p) {
        FactoryComponent fcContainer = ModelHelper.getFactoryComponentContainer((NamedModelElementWithId)domain_p);
        URI domainUri = FactoryComponentHelper.getDomainURI((String)fcContainer.getId());
        return domainUri;
    }

    @Override
    protected IEditorInput getEditorInput() {
        Object result = null;
        Domain domain = this.getDomain();
        URI domainUri = this.getDomainURI(domain);
        if (domainUri != null) {
            result = this.isReadOnly() ? new URIEditorInput(domainUri) : this.handleEditorInputForDomainLocatedInWorkspace(domain, domainUri);
        }
        return result;
    }

    private IEditorInput handleEditorInputForDomainLocatedInWorkspace(Domain domain_p, URI domainUri_p) {
        URIEditorInput result = null;
        String editorId = this.getEditorId();
        if ("org.eclipse.emf.ecore.presentation.EcoreEditorID".equals(editorId)) {
            result = new URIEditorInput(domainUri_p);
        } else if ("org.eclipse.emf.ecoretools.diagram.part.EcoreDiagramEditorID".equals(editorId)) {
            IFile ecoreDiagramFile;
            Path ecoreDiagramPath = new Path(domain_p.getPath());
            ecoreDiagramPath = ecoreDiagramPath.removeFileExtension();
            ecoreDiagramPath = ecoreDiagramPath.addFileExtension("ecorediag");
            IProject project = ModelHelper.getProject((NamedModelElementWithId)domain_p);
            if (project != null && (ecoreDiagramFile = project.getFile((IPath)ecoreDiagramPath)) != null) {
                if (ecoreDiagramFile.exists()) {
                    result = new FileEditorInput(ecoreDiagramFile);
                } else {
                    this.createAndOpenEcoreDiagram(domainUri_p, URI.createPlatformResourceURI((String)ecoreDiagramFile.getFullPath().toString(), (boolean)true));
                    result = null;
                }
            }
        }
        return result;
    }

    private void createAndOpenEcoreDiagram(final URI domainUri_p, final URI diagramUri_p) {
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            protected void execute(final IProgressMonitor monitor_p) throws CoreException, InvocationTargetException, InterruptedException {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        try {
                            EObject diagramEObject = OpenDomainAction.this.getDiagramEObject(domainUri_p);
                            Resource diagram = EcoreDiagramEditorUtil.createDiagramOnly((URI)diagramUri_p, (URI)domainUri_p, (EObject)diagramEObject, (boolean)true, (IProgressMonitor)monitor_p);
                            EcoreDiagramEditorUtil.openDiagram((Resource)diagram);
                        }
                        catch (PartInitException exception_p) {
                            StringBuilder loggerMessage = new StringBuilder(".run(..) _ ");
                            __logger.warn((Object)loggerMessage.toString(), (Throwable)exception_p);
                        }
                    }
                });
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, false, (IRunnableWithProgress)operation);
        }
        catch (InvocationTargetException exception_p) {
            StringBuilder loggerMessage = new StringBuilder("OpenGraphicalDomainAction.run(..) _ ");
            __logger.warn((Object)loggerMessage.toString(), (Throwable)exception_p);
        }
        catch (InterruptedException exception_p) {
            StringBuilder loggerMessage = new StringBuilder("OpenGraphicalDomainAction.run(..) _ ");
            __logger.warn((Object)loggerMessage.toString(), (Throwable)exception_p);
        }
    }

    private EObject getDiagramEObject(URI domainUri_p) {
        EObject result = null;
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource domain = resourceSet.getResource(domainUri_p, true);
        result = (EObject)domain.getContents().get(0);
        return result;
    }

    private Domain getDomain() {
        Domain domain = (Domain)this.getModelElement();
        return domain;
    }
}

