/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.ui.workbench.action.explorer;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.egf.common.progress.IProgressRunnable;
import org.eclipse.egf.common.progress.ProgressReporter;
import org.eclipse.egf.core.ui.workbench.Messages;
import org.eclipse.egf.core.ui.workbench.action.explorer.AbstractCleanPatternElementAction;
import org.eclipse.egf.model.AbstractPatternElement;
import org.eclipse.egf.model.PatternLibrary;
import org.eclipse.egf.model.PatternModel;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CleanPatternLibraryAction
extends AbstractCleanPatternElementAction {
    public CleanPatternLibraryAction(Shell shell_p, ISelectionProvider selectionProvider_p, boolean readOnlyMode_p) {
        super(shell_p, selectionProvider_p, readOnlyMode_p);
    }

    @Override
    protected String getConfirmationMessage() {
        return Messages.CleanPatternLibraryActionConfirmDialog_Message;
    }

    @Override
    protected Class<?> getModelElementClass() {
        return PatternLibrary.class;
    }

    @Override
    protected void doCleanPatternElement() {
        final PatternLibrary library = (PatternLibrary)this.getModelElement();
        ProgressReporter.asyncExec((IProgressRunnable)new IProgressRunnable(){

            public String getReportingTitle() {
                return String.valueOf(Messages.CleanPatternAction_Title) + ' ' + library.getName();
            }

            public boolean run(IProgressMonitor progressMonitor_p) {
                int work = library.getPatternElements().size();
                SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progressMonitor_p, (int)work);
                monitor.setWorkRemaining(work);
                try {
                    CleanPatternLibraryAction.this.clean(library, monitor);
                }
                finally {
                    monitor.setWorkRemaining(0);
                }
                return true;
            }
        });
    }

    private void clean(PatternLibrary library_p, SubMonitor monitor_p) {
        String taskName = String.valueOf(Messages.CleanPatternAction_Title) + ' ' + library_p.getName();
        monitor_p.setTaskName(taskName);
        EList patternElementList = library_p.getPatternElements();
        for (AbstractPatternElement currentPatternElement : patternElementList) {
            if (currentPatternElement instanceof PatternLibrary) {
                PatternLibrary library = (PatternLibrary)currentPatternElement;
                SubMonitor subMonitor = monitor_p.newChild(1);
                int work = library.getPatternElements().size();
                subMonitor.setWorkRemaining(work);
                try {
                    this.clean(library, subMonitor);
                    continue;
                }
                finally {
                    subMonitor.setWorkRemaining(0);
                    monitor_p.setTaskName(taskName);
                }
            }
            if (!(currentPatternElement instanceof PatternModel)) continue;
            monitor_p.subTask(String.valueOf(Messages.CleanPatternAction_Title) + ' ' + currentPatternElement.getName());
            this.clean((PatternModel)currentPatternElement, (IProgressMonitor)monitor_p);
        }
    }
}

