/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.internal.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.egf.common.descriptor.IDescriptor;
import org.eclipse.egf.common.descriptor.pattern.helper.IPatternDescriptorHandler;
import org.eclipse.egf.common.descriptor.pattern.helper.PatternDescriptorStrategy;
import org.eclipse.egf.core.data.FactoryComponentRegistry;
import org.eclipse.egf.core.data.helper.DataHelper;
import org.eclipse.egf.core.internal.reader.FactoryComponentReaderChain;
import org.eclipse.egf.model.AbstractPatternElement;
import org.eclipse.egf.model.Context;
import org.eclipse.egf.model.ContextElement;
import org.eclipse.egf.model.ContractElement;
import org.eclipse.egf.model.ContractElementReference;
import org.eclipse.egf.model.Domain;
import org.eclipse.egf.model.Factory;
import org.eclipse.egf.model.FactoryComponent;
import org.eclipse.egf.model.FactoryComponentInvocation;
import org.eclipse.egf.model.MappingModel;
import org.eclipse.egf.model.ModelFactory;
import org.eclipse.egf.model.PatternLibrary;
import org.eclipse.egf.model.PatternModel;
import org.eclipse.egf.model.PatternViewpoint;
import org.eclipse.egf.model.ProductionPlan;
import org.eclipse.egf.model.TaskFactoryHolder;
import org.eclipse.egf.model.Type;
import org.eclipse.egf.model.ViewpointType;
import org.eclipse.egf.model.contract.type.ITypeHolder;
import org.eclipse.egf.model.data.helper.IFactoryComponentLoadingHelper;
import org.eclipse.egf.model.data.helper.ModelHelper;
import org.eclipse.egf.model.data.reader.descriptor.IContextDescriptor;
import org.eclipse.egf.model.data.reader.descriptor.IContextElementDescriptor;
import org.eclipse.egf.model.data.reader.descriptor.IContractDescriptor;
import org.eclipse.egf.model.data.reader.descriptor.IContractElementDescriptor;
import org.eclipse.egf.model.data.reader.descriptor.IContractElementReferenceDescriptor;
import org.eclipse.egf.model.data.reader.descriptor.IFactoryComponentDescriptor;
import org.eclipse.egf.model.data.reader.descriptor.IFactoryComponentInvocationDescriptor;
import org.eclipse.egf.model.data.reader.descriptor.IProductionPlanDescriptor;
import org.eclipse.egf.model.data.reader.descriptor.ITaskFactoryDescriptor;
import org.eclipse.egf.model.internal.data.ModelElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FactoryComponentLoadingHelper
implements IFactoryComponentLoadingHelper {
    static final Logger __logger = Logger.getLogger((String)FactoryComponentLoadingHelper.class.getPackage().getName());
    private FactoryComponentRegistry _factoryComponentRegistry = FactoryComponentRegistry.getInstance();

    public FactoryComponent getFactoryComponent(String factoryComponentId_p) {
        FactoryComponent factoryComponent = null;
        if (factoryComponentId_p == null) {
            return factoryComponent;
        }
        factoryComponent = this.getFactoryComponentFromRegistry(factoryComponentId_p);
        if (factoryComponent == null) {
            factoryComponent = this.loadFactoryComponent(factoryComponentId_p);
            this._factoryComponentRegistry.addFactoryComponent(factoryComponentId_p, factoryComponent);
        }
        return factoryComponent;
    }

    public FactoryComponent getFactoryComponent(IFactoryComponentDescriptor factoryComponentDescriptor_p) {
        FactoryComponent factoryComponent = null;
        if (factoryComponentDescriptor_p == null) {
            return factoryComponent;
        }
        String factoryComponentId = factoryComponentDescriptor_p.getId();
        factoryComponent = this.getFactoryComponentFromRegistry(factoryComponentId);
        if (factoryComponent == null) {
            factoryComponent = this.createFactoryComponent(factoryComponentDescriptor_p);
            this._factoryComponentRegistry.addFactoryComponent(factoryComponentId, factoryComponent);
        }
        return factoryComponent;
    }

    private FactoryComponent getFactoryComponentFromRegistry(String factoryComponentId_p) {
        return this._factoryComponentRegistry.getFactoryComponent(factoryComponentId_p);
    }

    protected FactoryComponent createFactoryComponent(IFactoryComponentDescriptor fcDescriptor_p) {
        FactoryComponent factoryComponent = null;
        if (fcDescriptor_p != null) {
            String contractId;
            factoryComponent = ModelFactory.eINSTANCE.createFactoryComponent();
            ((ModelElement)factoryComponent).setFactoryComponentReader(fcDescriptor_p.getFactoryComponentReader());
            String fcId = fcDescriptor_p.getId();
            factoryComponent.setId(fcId);
            factoryComponent.setName(fcDescriptor_p.getName());
            factoryComponent.setDescription(fcDescriptor_p.getDescription());
            Domain domain = ModelFactory.eINSTANCE.createDomain();
            factoryComponent.setDomain(domain);
            String domainPath = fcDescriptor_p.getDomainPath();
            if (domainPath != null && !"".equals(domainPath)) {
                domain.setPath(domainPath);
            }
            if ((contractId = fcDescriptor_p.getContractId()) != null && !"".equals(contractId)) {
                ModelHelper.addViewpointTypeId((String)contractId, (ViewpointType)ViewpointType.CONTRACT, (FactoryComponent)factoryComponent);
            }
            ModelHelper.addViewpointTypeId((String)ModelFactory.eINSTANCE.createPatternViewpoint().getId(), (ViewpointType)ViewpointType.PATTERN, (FactoryComponent)factoryComponent);
            ModelHelper.addViewpointTypeId((String)ModelFactory.eINSTANCE.createMappingViewpoint().getId(), (ViewpointType)ViewpointType.MAPPING, (FactoryComponent)factoryComponent);
            String productionPlanId = fcDescriptor_p.getProductionPlanId();
            Factory factory = ModelFactory.eINSTANCE.createFactory();
            factoryComponent.setFactory(factory);
            if (productionPlanId != null && !"".equals(productionPlanId)) {
                factory.setProductionPlanId(productionPlanId);
            } else if (!DataHelper.isBootstrapFactoryComponent(fcId)) {
                StringBuffer loggerMessage = new StringBuffer("FactoryComponentLoadingHelper.createFactoryComponent(..) _ ");
                loggerMessage.append("No production plan defined for factory component ");
                loggerMessage.append(fcId);
                __logger.error((Object)loggerMessage.toString());
            }
        }
        return factoryComponent;
    }

    protected FactoryComponent loadFactoryComponent(String factoryComponentId_p) {
        IFactoryComponentDescriptor descriptor = FactoryComponentReaderChain.getInstance().readFactoryComponent(factoryComponentId_p);
        return this.createFactoryComponent(descriptor);
    }

    public List<ContractElement> loadContract(String contractId_p, String factoryComponentId_p) {
        ArrayList<ContractElement> result = new ArrayList<ContractElement>(0);
        if (contractId_p == null || factoryComponentId_p == null) {
            return result;
        }
        IContractDescriptor descriptor = FactoryComponentReaderChain.getInstance().readContract(contractId_p, factoryComponentId_p);
        if (descriptor != null) {
            for (IContractElementDescriptor contractElementDescriptor : descriptor.getContractElementDescriptors()) {
                ContractElement contractElement = this.loadContractElement(contractElementDescriptor);
                contractElement.setFactoryComponentId(factoryComponentId_p);
                result.add(contractElement);
            }
        }
        return result;
    }

    private ContractElement loadContractElement(IContractElementDescriptor contractElementDescriptor_p) {
        ContractElement contractElement = ModelFactory.eINSTANCE.createContractElement();
        contractElement.setId(contractElementDescriptor_p.getId());
        String contractElementName = contractElementDescriptor_p.getContractElementName();
        contractElement.setName(contractElementName);
        ModelHelper.setContractType((ContractElement)contractElement, (String)contractElementDescriptor_p.getTypeHolderClassName());
        ITypeHolder typeHolder = contractElementDescriptor_p.getTypeHolder();
        if (typeHolder != null) {
            contractElement.getContractType().setTypeHolder((Object)typeHolder);
        }
        contractElement.setMandatory(contractElementDescriptor_p.isMandatory());
        contractElement.setDescription(contractElementDescriptor_p.getDescription());
        contractElement.getContractReferenceIds().addAll((Collection)contractElementDescriptor_p.getContractReferenceIds());
        return contractElement;
    }

    public ContractElementReference loadContractElementReference(String contractReferenceId_p, String factoryComponentId_p) {
        ContractElementReference referenceToContractElement = null;
        if (contractReferenceId_p == null) {
            return referenceToContractElement;
        }
        IContractElementReferenceDescriptor descriptor = FactoryComponentReaderChain.getInstance().readContractElementReference(contractReferenceId_p, factoryComponentId_p);
        if (descriptor != null) {
            referenceToContractElement = ModelFactory.eINSTANCE.createContractElementReference();
            referenceToContractElement.setId(contractReferenceId_p);
            String contractElementId = descriptor.getContractElementId();
            if (contractElementId != null && !"".equals(contractElementId)) {
                referenceToContractElement.setReferencedContractElementId(contractElementId);
            } else {
                referenceToContractElement.setReferencedContractElementName(descriptor.getContractElementName());
            }
            String referencedFcId = descriptor.getReferencedFcId();
            if (referencedFcId != null && !"".equals(referencedFcId)) {
                referenceToContractElement.setReferencedFactoryComponentId(referencedFcId);
            }
        }
        return referenceToContractElement;
    }

    public ProductionPlan loadProductionPlan(String productionPlanId_p, String factoryComponentId_p) {
        ProductionPlan productionPlan = null;
        if (productionPlanId_p == null) {
            return productionPlan;
        }
        IProductionPlanDescriptor descriptor = FactoryComponentReaderChain.getInstance().readProductionPlan(productionPlanId_p, factoryComponentId_p);
        if (descriptor != null) {
            productionPlan = ModelFactory.eINSTANCE.createProductionPlan();
            productionPlan.setId(productionPlanId_p);
            String contextId = descriptor.getContextId();
            if (contextId != null && !"".equals(contextId)) {
                productionPlan.setContextId(contextId);
            }
            List fcInvocationIds = descriptor.getFactoryComponentInvocationIds();
            productionPlan.getFactoryComponentInvocationIds().addAll((Collection)fcInvocationIds);
        } else {
            StringBuffer loggerMessage = new StringBuffer("FactoryComponentLoadingHelper.loadProductionPlan(..) _ ");
            loggerMessage.append("Production plan ");
            loggerMessage.append(productionPlanId_p);
            loggerMessage.append(" is not found !");
            __logger.warn((Object)loggerMessage.toString());
        }
        return productionPlan;
    }

    public FactoryComponentInvocation loadFactoryComponentInvocation(String factoryComponentInvocationId_p, String factoryComponentId_p) {
        FactoryComponentInvocation fcInvocation = null;
        if (factoryComponentInvocationId_p == null) {
            return fcInvocation;
        }
        IFactoryComponentInvocationDescriptor descriptor = FactoryComponentReaderChain.getInstance().readFactoryComponentInvocation(factoryComponentInvocationId_p, factoryComponentId_p);
        if (descriptor != null) {
            String contextId;
            String taskFactoryId;
            fcInvocation = ModelFactory.eINSTANCE.createFactoryComponentInvocation();
            fcInvocation.setId(factoryComponentInvocationId_p);
            fcInvocation.setName(descriptor.getName());
            String referencedFcId = descriptor.getReferencedFactoryComponentId();
            if (referencedFcId != null && !"".equals(referencedFcId)) {
                fcInvocation.setFactoryComponentId(referencedFcId);
            }
            if ((taskFactoryId = descriptor.getTaskFactoryId()) != null && !"".equals(taskFactoryId)) {
                fcInvocation.setTaskFactoryId(taskFactoryId);
            }
            if ((contextId = descriptor.getContextId()) != null && !"".equals(contextId)) {
                fcInvocation.setContextId(contextId);
            }
        }
        return fcInvocation;
    }

    public TaskFactoryHolder loadTaskFactory(String taskFactoryId_p, String factoryComponentId_p) {
        TaskFactoryHolder taskFactoryHolder = null;
        if (taskFactoryId_p == null) {
            return taskFactoryHolder;
        }
        ITaskFactoryDescriptor descriptor = FactoryComponentReaderChain.getInstance().readTaskFactory(taskFactoryId_p, factoryComponentId_p);
        if (descriptor != null) {
            taskFactoryHolder = ModelFactory.eINSTANCE.createTaskFactoryHolder();
            taskFactoryHolder.setId(taskFactoryId_p);
            taskFactoryHolder.setFactoryClass(descriptor.getTaskFactoryClass());
            Object taskFactory = descriptor.getTaskFactory();
            if (taskFactory != null) {
                taskFactoryHolder.setFactory(taskFactory);
            }
        }
        return taskFactoryHolder;
    }

    public Context loadContext(String contextId_p, String factoryComponentId_p) {
        Context context = null;
        if (contextId_p == null) {
            return context;
        }
        IContextDescriptor descriptor = FactoryComponentReaderChain.getInstance().readContext(contextId_p, factoryComponentId_p);
        if (descriptor != null) {
            context = ModelFactory.eINSTANCE.createContext();
            context.setId(contextId_p);
            for (IContextElementDescriptor contextElementDescriptor : descriptor.getContextElementDescriptors()) {
                ContextElement contextElement = this.loadContextElement(contextElementDescriptor);
                if (contextElement == null) continue;
                context.getContextElements().add((Object)contextElement);
            }
        }
        return context;
    }

    private ContextElement loadContextElement(IContextElementDescriptor contextElementDescriptor_p) {
        ContextElement contextElement = ModelFactory.eINSTANCE.createContextElement();
        String contextElementId = contextElementDescriptor_p.getId();
        contextElement.setId(contextElementId);
        contextElement.setPluginId(contextElementDescriptor_p.getPluginId());
        String contractRefIdOrKeyValue = contextElementDescriptor_p.getContractReferenceId();
        if (contractRefIdOrKeyValue != null) {
            contextElement.setContractReferenceId(contractRefIdOrKeyValue);
        } else {
            contractRefIdOrKeyValue = contextElementDescriptor_p.getKey();
            if (contractRefIdOrKeyValue != null) {
                contextElement.setKey(contractRefIdOrKeyValue);
            }
        }
        String readableValue = contextElementDescriptor_p.getReadableValue();
        if (readableValue == null) {
            StringBuffer loggerMessage = new StringBuffer("FactoryComponentLoadingHelper.loadContextElement(..) _ ");
            loggerMessage.append("Context element readable value must be set!");
            __logger.error((Object)loggerMessage.toString());
        } else {
            contextElement.setReadableValue(readableValue);
        }
        Type type = contextElementDescriptor_p.getType();
        if (type != null) {
            contextElement.setContextType(type);
        } else if (contextElement.getContractReferenceId() == null) {
            StringBuilder loggerMessage = new StringBuilder("FactoryComponentLoadingHelper.loadContextElement(..) _ ");
            loggerMessage.append("Could not instanciate type holder for ").append(contextElement.getId()).append(" !").append('\n');
            loggerMessage.append("No reference to a contract element could be found either !").append('\n');
            loggerMessage.append("It is likely this context element will be useless.");
            __logger.error((Object)loggerMessage.toString());
        }
        return contextElement;
    }

    public void loadPatternLibraries(String factoryComponentId_p, PatternViewpoint patternViewpoint_p) {
        if (factoryComponentId_p == null || patternViewpoint_p == null) {
            return;
        }
        IDescriptor libraryDescriptors = FactoryComponentReaderChain.getInstance().readPatternLibraries(factoryComponentId_p);
        PatternDescriptorHandler handler = new PatternDescriptorHandler(patternViewpoint_p);
        PatternDescriptorStrategy patternStrategy = new PatternDescriptorStrategy();
        patternStrategy.iterateThroughPatternExtensionDescriptor((IPatternDescriptorHandler)handler, libraryDescriptors);
    }

    public List<MappingModel> loadMappings(String factoryComponentId_p) {
        ArrayList<MappingModel> result = new ArrayList<MappingModel>(0);
        if (factoryComponentId_p == null) {
            return result;
        }
        IDescriptor mappingDescriptors = FactoryComponentReaderChain.getInstance().readMappings(factoryComponentId_p);
        for (IDescriptor currentMappingDescriptor : mappingDescriptors.getChildren()) {
            MappingModel mapping = ModelFactory.eINSTANCE.createMappingModel();
            mapping.setId((String)currentMappingDescriptor.getValue("id"));
            mapping.setName((String)currentMappingDescriptor.getValue("name"));
            mapping.setPath((String)currentMappingDescriptor.getValue("path"));
            mapping.setSource((String)currentMappingDescriptor.getValue("assetIdAsSource"));
            mapping.setTarget((String)currentMappingDescriptor.getValue("assetIdAsTarget"));
            result.add(mapping);
        }
        return result;
    }

    class PatternDescriptorHandler
    implements IPatternDescriptorHandler {
        private PatternViewpoint _patternViewpoint;

        public PatternDescriptorHandler(PatternViewpoint patternViewpoint_p) {
            this._patternViewpoint = patternViewpoint_p;
        }

        public void handleDescriptor(IDescriptor descriptor_p) {
        }

        public void handleLibraryDescriptor(IDescriptor descriptor_p, String libraryFullId_p) {
            PatternLibrary newPatternLibrary = ModelFactory.eINSTANCE.createPatternLibrary();
            newPatternLibrary.setId(libraryFullId_p);
            newPatternLibrary.setName((String)descriptor_p.getValue("name"));
            newPatternLibrary.setProductionOrchestration((String)descriptor_p.getValue("productionOrchestration"));
            newPatternLibrary.setRuntimeOrchestration((String)descriptor_p.getValue("runtimeOrchestration"));
            PatternLibrary parentLibrary = this.getParentLibrary((AbstractPatternElement)newPatternLibrary);
            if (parentLibrary != null) {
                parentLibrary.getPatternElements().add((Object)newPatternLibrary);
            } else {
                this._patternViewpoint.getLibraries().add((Object)newPatternLibrary);
            }
        }

        public void handlePatternDescriptor(IDescriptor descriptor_p, String patternFullId_p) {
            PatternModel newPatternModel = ModelFactory.eINSTANCE.createPatternModel();
            newPatternModel.setId(patternFullId_p);
            newPatternModel.setName((String)descriptor_p.getValue("name"));
            newPatternModel.setPath((String)descriptor_p.getValue("model"));
            PatternLibrary parentLibrary = this.getParentLibrary((AbstractPatternElement)newPatternModel);
            if (parentLibrary != null) {
                parentLibrary.getPatternElements().add((Object)newPatternModel);
            } else {
                StringBuilder loggerMessage = new StringBuilder("PatternDescriptorHandler.handlePatternDescriptor(..) _ ");
                loggerMessage.append("Pattern model id:").append(patternFullId_p).append(" must have a parent library!");
                __logger.error((Object)loggerMessage.toString());
            }
        }

        private PatternLibrary getParentLibrary(AbstractPatternElement patternElement_p) {
            PatternLibrary parentLibrary = null;
            String parentLibraryId = ModelHelper.getParentLibraryId((AbstractPatternElement)patternElement_p);
            if (parentLibraryId != null) {
                parentLibrary = ModelHelper.getLibrary((String)parentLibraryId, (PatternViewpoint)this._patternViewpoint);
            }
            return parentLibrary;
        }
    }
}

