/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.internal.editor.page.implementation;

import org.eclipse.core.runtime.Path;
import org.eclipse.egf.common.misc.Couple;
import org.eclipse.egf.common.ui.helper.MessageFormatHelper;
import org.eclipse.egf.pattern.ecore.AnnotationHandler;
import org.eclipse.egf.pattern.ecore.PatternHandler;
import org.eclipse.egf.pattern.ui.editor.page.util.DisplayHelper;
import org.eclipse.egf.pattern.ui.internal.editor.page.implementation.Messages;
import org.eclipse.egf.pattern.ui.internal.editor.page.implementation.MethodActionHandler;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.jface.viewers.LabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodPatternCodeLabelProvider
extends LabelProvider {
    private PatternHandler.PatternData _patternData;
    private DisplayHelper _displayHelper;

    public void setPatternData(PatternHandler.PatternData patternData_p) {
        this._patternData = patternData_p;
    }

    public String getText(Object element_p) {
        String result = null;
        Couple<String, String> action = MethodPatternCodeLabelProvider.getAction(element_p);
        String actionType = (String)action.getKey();
        if ("CALL".equals(actionType)) {
            result = MessageFormatHelper.formatMessage((String)Messages.MethodPatternCodeLabelProvider_PatternCode_CALL_Message, (Object[])new Object[]{this.getMethodeNameFromReference((String)action.getValue())});
        } else if ("PATTERN".equals(actionType)) {
            result = MessageFormatHelper.formatMessage((String)Messages.MethodPatternCodeLabelProvider_PatternCode_PATTERN_Message, (Object[])new Object[]{this.getPatternNameFromFullId((String)action.getValue())});
        } else if ("READ".equals(actionType)) {
            result = MessageFormatHelper.formatMessage((String)Messages.MethodPatternCodeLabelProvider_PatternCode_READ_Message, (Object[])new Object[]{this.getMethodNameFromTemplateRelativePath((String)action.getValue())});
        } else if ("SUPER".equals(actionType)) {
            result = MessageFormatHelper.formatMessage((String)Messages.MethodPatternCodeLabelProvider_PatternCode_SUPER_CALL_Message, (Object[])new Object[]{this.getMethodeNameFromReference((String)action.getValue())});
        }
        return result;
    }

    protected static Couple<String, String> getAction(Object object_p) {
        return ((MethodActionHandler)object_p).getAction();
    }

    protected String getMethodeNameFromReference(String reference_p) {
        if (reference_p == null) {
            return "";
        }
        return reference_p;
    }

    protected String getMethodNameFromTemplateRelativePath(String templateRelativePath_p) {
        if (templateRelativePath_p == null) {
            return "";
        }
        String methodId = new Path(templateRelativePath_p).removeFileExtension().lastSegment();
        EOperation method = null;
        if (methodId != null) {
            AnnotationHandler handler = new AnnotationHandler();
            EList operations = this._patternData.getPattern().getEAllOperations();
            for (EOperation operation : operations) {
                if (!methodId.equals(handler.getUid(operation))) continue;
                method = operation;
                break;
            }
        }
        return method != null ? method.getName() : methodId;
    }

    protected String getPatternNameFromFullId(String patternFullId_p) {
        if (this._displayHelper == null) {
            this._displayHelper = new DisplayHelper();
        }
        return this._displayHelper.getPatternOrLibraryFullName(patternFullId_p);
    }
}

