/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.editor.page;

import java.util.List;
import org.eclipse.egf.common.misc.Couple;
import org.eclipse.egf.common.ui.helper.DataBindingHelper;
import org.eclipse.egf.common.ui.helper.FormHelper;
import org.eclipse.egf.common.ui.helper.MessageFormatHelper;
import org.eclipse.egf.common.ui.viewers.IContentHandler;
import org.eclipse.egf.common.ui.viewers.IOrderedContentProvider;
import org.eclipse.egf.common.ui.viewers.OrderedListViewerWithAddAndRemove;
import org.eclipse.egf.pattern.ecore.PatternHandler;
import org.eclipse.egf.pattern.relations.ParameterRelation;
import org.eclipse.egf.pattern.relations.RelationsFactory;
import org.eclipse.egf.pattern.ui.PatternUiActivator;
import org.eclipse.egf.pattern.ui.editor.page.AbstractPatternBlock;
import org.eclipse.egf.pattern.ui.editor.page.AbstractPatternDetails;
import org.eclipse.egf.pattern.ui.editor.page.AbstractPatternPage;
import org.eclipse.egf.pattern.ui.editor.page.Messages;
import org.eclipse.egf.pattern.ui.internal.editor.DefaultPatternModificationNotification;
import org.eclipse.egf.pattern.ui.internal.editor.IPatternModificationListener;
import org.eclipse.egf.pattern.ui.internal.editor.IPatternModificationNotification;
import org.eclipse.egf.pattern.ui.internal.editor.page.AbstractPatternPageContentProvider;
import org.eclipse.egf.pattern.ui.internal.editor.page.DefaultContentHandler;
import org.eclipse.egf.pattern.ui.internal.editor.page.implementation.IParameterHandler;
import org.eclipse.egf.pattern.ui.internal.editor.page.specification.ConditionViewer;
import org.eclipse.egf.pattern.ui.internal.editor.page.specification.wizard.ParameterWizard;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.DetailsPart;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IDetailsPageProvider;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class PatternSpecificationPage
extends AbstractPatternPage {
    public static final String ID = "egf_pattern_specification_page";
    protected static final String HELP_CONTEXT_ID = String.valueOf(PatternUiActivator.getDefault().getPluginID()) + '.' + "egf_pattern_specification_page";
    protected StructuredViewer _parametersViewer;
    private ConditionViewer _conditionViewer;

    public PatternSpecificationPage(FormEditor editor_p) {
        super(editor_p, ID, Messages.PatternSpecificationPage_Title);
        this.getExternalSelectionManager().addExternalHandlerFor(IParameterHandler.class, this);
    }

    public void dispose() {
        super.dispose();
        if (this._conditionViewer != null) {
            this._conditionViewer.dispose();
        }
        this.getExternalSelectionManager().removeExternalHandler(this, IParameterHandler.class);
    }

    public void handleSelection(Object firstSelectedObject_p, IStructuredSelection selection_p) {
        IParameterHandler selectedHandler = (IParameterHandler)firstSelectedObject_p;
        if (!selectedHandler.isInherited()) {
            if (!this.isActive()) {
                this.getEditor().setActivePage(ID);
            }
            if (this._parametersViewer != null) {
                this._parametersViewer.setSelection((ISelection)new StructuredSelection((Object)selectedHandler.getParameter()));
            }
        }
    }

    protected void doCreateFormContent(FormToolkit toolkit_p, Composite parent_p, PatternHandler.PatternData patternData_p, IManagedForm managedForm_p) {
        super.doCreateFormContent(toolkit_p, parent_p, patternData_p, managedForm_p);
        this._conditionViewer = new ConditionViewer(parent_p, toolkit_p, patternData_p, this.getEditor().getPatternHandler(), this.isEditable());
    }

    protected AbstractPatternBlock createPatternBlock() {
        return new SpecificationBlock();
    }

    protected void dataSaved() {
        if (this._parametersViewer != null) {
            this._parametersViewer.setInput((Object)"");
            this._parametersViewer.setSelection((ISelection)StructuredSelection.EMPTY);
        }
    }

    public String getHelpContextId() {
        return HELP_CONTEXT_ID;
    }

    protected abstract class ParameterDetails
    extends AbstractPatternDetails
    implements DisposeListener,
    IPatternModificationListener {
        private ParameterDetailsHandler _handler;
        private Text _parameterTypeText;

        public ParameterDetails(IFormPart masterPart_p) {
            super(masterPart_p);
        }

        protected void doCreateContents(FormToolkit toolkit_p, Composite parent_p, Object initialContent_p) {
            ParameterRelation parameter = (ParameterRelation)initialContent_p;
            this._handler = new ParameterDetailsHandler(parameter);
            FormHelper.updateCompositeLayoutWithLayoutType((Composite)parent_p, (FormHelper.LayoutType)FormHelper.LayoutType.GRID_LAYOUT, (int)1, (boolean)false);
            Couple parameterCouple = FormHelper.createSectionWithChildComposite((FormToolkit)toolkit_p, (Composite)parent_p, (int)320, (FormHelper.LayoutType)FormHelper.LayoutType.GRID_LAYOUT, (int)3, (boolean)false);
            ((Section)parameterCouple.getKey()).setText(Messages.PatternSpecificationPage_ParameterPropertiesSectionTitle);
            Composite parameterComposite = (Composite)parameterCouple.getValue();
            Couple parameterName = FormHelper.createLabelAndText((FormToolkit)toolkit_p, (Composite)parameterComposite, (String)Messages.PatternSpecificationPage_ParameterNameLabel, null, (boolean)true);
            Text parameterNameText = (Text)parameterName.getValue();
            GridData actionNameTextData = (GridData)parameterNameText.getLayoutData();
            actionNameTextData.horizontalSpan = 2;
            ParameterNameValidator parameterNameValidator = null;
            if (PatternSpecificationPage.this.isEditable()) {
                parameterNameValidator = new ParameterNameValidator((Control)parameterNameText, parameter);
            }
            DataBindingHelper.bindTextToProperty((Control)parameterNameText, (String)"parameterName", (Object)this._handler, parameterNameValidator);
            Couple parameterType = FormHelper.createLabelTextAndButton((FormToolkit)toolkit_p, (Composite)parameterComposite, (String)Messages.PatternSpecificationPage_ParameterTypeLabel, (String)Messages.PatternSpecificationPage_ParameterTypeButtonLabel, (SelectionListener)this._handler);
            this._parameterTypeText = (Text)parameterType.getKey();
            this._parameterTypeText.setEditable(false);
            this._parameterTypeText.addDisposeListener((DisposeListener)this);
            DataBindingHelper.bindTextToProperty((Control)this._parameterTypeText, (String)"parameterType", (Object)this._handler, null);
            PatternSpecificationPage.this.getEditor().addPatternModificationListener(this);
            parameterComposite.setEnabled(PatternSpecificationPage.this.isEditable());
        }

        public void widgetDisposed(DisposeEvent e_p) {
            PatternSpecificationPage.this.getEditor().removePatternModificationListener(this);
        }

        public void notifyChanged(IPatternModificationNotification notification_p) {
            ParameterRelation parameter;
            int type = notification_p.getEventType();
            if (4 != type) {
                return;
            }
            Object notifier = notification_p.getNotifier();
            if (notifier instanceof ParameterRelation && (parameter = (ParameterRelation)notifier) == this.getInitialContent()) {
                this._parameterTypeText.setText(this._handler.getParameterType());
            }
        }
    }

    protected class ParameterDetailsHandler
    extends DefaultContentHandler
    implements SelectionListener {
        protected static final String DATA_BINDING_PARAMETER_NAME = "parameterName";
        protected static final String DATA_BINDING_PARAMETER_TYPE = "parameterType";
        private ParameterRelation _parameter;

        protected ParameterDetailsHandler(ParameterRelation parameter_p) {
            super(null, PatternSpecificationPage.this);
            this._parameter = parameter_p;
        }

        public void setParameterName(String newName_p) {
            if (!"".equals(newName_p.trim())) {
                String oldName = this._parameter.getName();
                this._parameter.setName(newName_p);
                this.notifyModification();
                DefaultPatternModificationNotification notification = DefaultPatternModificationNotification.createNotification(4, this._parameter, oldName, newName_p);
                this.notifyListeners(notification);
            }
        }

        public String getParameterName() {
            return this._parameter.getName();
        }

        public void setParameterType(String newType_p) {
        }

        public String getParameterType() {
            String parameterTypeValue = this._parameter.getType().getName();
            if (parameterTypeValue == null) {
                parameterTypeValue = "";
            }
            return parameterTypeValue;
        }

        public void widgetDefaultSelected(SelectionEvent e_p) {
        }

        protected void notifyListeners(IPatternModificationNotification notification_p) {
            PatternSpecificationPage.this.getEditor().sendNotification(notification_p);
        }

        public void widgetSelected(SelectionEvent e_p) {
            ParameterRelation temporaryParameter = RelationsFactory.eINSTANCE.createParameterRelation();
            temporaryParameter.setType(this._parameter.getType());
            WizardDialog wizardDialog = new WizardDialog(PatternSpecificationPage.this.getSite().getShell(), (IWizard)new ParameterWizard(temporaryParameter));
            int returnCode = wizardDialog.open();
            if (returnCode == 0) {
                EClass type = temporaryParameter.getType();
                EClass oldType = this._parameter.getType();
                this._parameter.setType(type);
                this.notifyModification();
                DefaultPatternModificationNotification notification = DefaultPatternModificationNotification.createNotification(4, this._parameter, oldType, type);
                this.notifyListeners(notification);
            }
        }
    }

    protected class ParameterNameValidator
    extends AbstractPatternPage.TextValidator
    implements IPatternModificationListener {
        protected static final String ERROR_KEY_NOT_UNIQUE_NAME = "NotUniqueParameterName";
        private ParameterRelation _currentParameter;

        protected ParameterNameValidator(Control control_p, ParameterRelation currentParameter_p) {
            super(control_p);
            this.setRegularExpression(Messages.PatternSpecificationPage_ParameterNameRegularExpression);
            this._currentParameter = currentParameter_p;
            PatternSpecificationPage.this.getEditor().addPatternModificationListener(this);
        }

        protected boolean onError(String text_p) {
            boolean result = super.onError(text_p);
            if (!result) {
                List parameters = PatternSpecificationPage.this.getPatternHandler().recomputeAllParameters();
                for (ParameterRelation parameterRelation : parameters) {
                    boolean bl = result = parameterRelation != this._currentParameter && parameterRelation.getName().equals(text_p);
                    if (!result) continue;
                    this.addErrorKey(ERROR_KEY_NOT_UNIQUE_NAME);
                    break;
                }
            }
            return result;
        }

        protected String getErrorMessageFor(String errorKey_p, String value_p) {
            Object[] parameters = new Object[]{value_p};
            if ("RegExp" == errorKey_p) {
                return MessageFormatHelper.formatMessage((String)Messages.PatternSpecificationPage_ParameterNameMalformedError, (Object[])parameters);
            }
            if (ERROR_KEY_NOT_UNIQUE_NAME == errorKey_p) {
                return MessageFormatHelper.formatMessage((String)Messages.PatternSpecificationPage_ParameterNameNotUniqueError, (Object[])parameters);
            }
            return null;
        }

        public void notifyChanged(IPatternModificationNotification notification_p) {
            ParameterRelation parameter;
            int type = notification_p.getEventType();
            if (2 != type) {
                return;
            }
            Object oldValue = notification_p.getOldValue();
            if (oldValue instanceof ParameterRelation && (parameter = (ParameterRelation)oldValue) == this._currentParameter) {
                PatternSpecificationPage.this.clearErrors(this.getControl());
                PatternSpecificationPage.this.getEditor().removePatternModificationListener(this);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ParametersContentHandler
    extends DefaultContentHandler {
        private int _parameterNameIncrement;

        public ParametersContentHandler() {
            super(null, PatternSpecificationPage.this);
        }

        public List<ParameterRelation> getParameters() {
            return this.getPatternData().getPattern().getParameters();
        }

        protected String getNewParameterName() {
            String result = "";
            List parameters = PatternSpecificationPage.this.getPatternHandler().recomputeAllParameters();
            block0: while ("".equals(result)) {
                result = MessageFormatHelper.formatMessage((String)Messages.PatternSpecificationPage_NewParameterNamePattern, (Object[])new Object[]{this._parameterNameIncrement++});
                for (ParameterRelation parameterRelation : parameters) {
                    if (!result.equals(parameterRelation.getName())) continue;
                    result = "";
                    continue block0;
                }
            }
            return result;
        }

        @Override
        public Object createNewElement() {
            ParameterRelation newParameter = RelationsFactory.eINSTANCE.createParameterRelation();
            newParameter.setName(this.getNewParameterName());
            newParameter.setType(EcorePackage.Literals.ECLASS);
            this.getParameters().add(newParameter);
            this.notifyModification();
            DefaultPatternModificationNotification notification = DefaultPatternModificationNotification.createNotification(1, this.getPattern(), null, newParameter);
            PatternSpecificationPage.this.getEditor().sendNotification(notification);
            return newParameter;
        }

        @Override
        public void removeElement(Object element_p) {
            ParameterRelation parameter = (ParameterRelation)element_p;
            this.getParameters().remove(parameter);
            this.notifyModification();
            DefaultPatternModificationNotification notification = DefaultPatternModificationNotification.createNotification(2, this.getPattern(), parameter, null);
            PatternSpecificationPage.this.getEditor().sendNotification(notification);
        }

        protected void swapParameters(int firstIndex_p, int secondIndex_p) {
            ((EList)this.getParameters()).move(firstIndex_p, secondIndex_p);
            this.notifyModification();
        }
    }

    protected class ParametersContentProvider
    extends AbstractPatternPageContentProvider
    implements IOrderedContentProvider,
    IPatternModificationListener {
        private ParametersContentHandler _contentHandler;

        protected ParametersContentProvider(ParametersContentHandler handler_p) {
            this._contentHandler = handler_p;
        }

        protected void doDispose() {
        }

        protected ListViewer getViewer() {
            return (ListViewer)super.getViewer();
        }

        protected void doHandleElementsAdded(Object addedElements_p) {
            this.getViewer().add(addedElements_p);
        }

        protected void doHandleElementsRemoved(Object removedElements_p) {
            this.getViewer().remove(removedElements_p);
        }

        protected void doHandleElementUpdated(Object oldInput_p, Object newInput_p) {
            this.getViewer().update(oldInput_p, null);
        }

        public Object[] getElements(Object inputElement_p) {
            return this._contentHandler.getParameters().toArray();
        }

        public void swap(int elementPosition1_p, int elementPosition2_p) {
            this._contentHandler.swapParameters(elementPosition1_p, elementPosition2_p);
            this.getViewer().refresh();
        }

        public void notifyChanged(IPatternModificationNotification notification_p) {
            int type = notification_p.getEventType();
            if (4 != type) {
                return;
            }
            Object notifier = notification_p.getNotifier();
            if (notifier instanceof ParameterRelation) {
                ParameterRelation parameter = (ParameterRelation)notifier;
                this.doHandleElementUpdated(parameter, parameter);
            }
        }
    }

    protected class ParametersLabelProvider
    extends LabelProvider {
        protected ParametersLabelProvider() {
        }

        public String getText(Object element_p) {
            ParameterRelation parameter = (ParameterRelation)element_p;
            String displayableParameter = MessageFormatHelper.formatMessage((String)Messages.PatternSpecificationPage_ParameterLabelPattern, (Object[])new Object[]{parameter.getName(), parameter.getType().getName()});
            return displayableParameter;
        }
    }

    protected class ParametersViewer
    extends OrderedListViewerWithAddAndRemove {
        protected ParametersContentHandler _contentHandler;

        public ParametersViewer(Composite parent_p) {
            super(parent_p);
        }

        protected StructuredViewer createViewer(Composite composite_p) {
            FormToolkit toolkit = PatternSpecificationPage.this.getEditor().getToolkit();
            Composite listComposite = FormHelper.createCompositeWithLayoutType((FormToolkit)toolkit, (Composite)composite_p, (FormHelper.LayoutType)FormHelper.LayoutType.GRID_LAYOUT, (int)1, (boolean)false);
            PatternSpecificationPage.this._parametersViewer = new ListViewer(listComposite, 2820);
            Control listControl = PatternSpecificationPage.this._parametersViewer.getControl();
            FormHelper.updateControlLayoutDataWithLayoutTypeData((Control)listControl, (FormHelper.LayoutType)FormHelper.LayoutType.GRID_LAYOUT);
            this._contentHandler = new ParametersContentHandler();
            ParametersContentProvider parametersContentProvider = new ParametersContentProvider(this._contentHandler);
            PatternSpecificationPage.this.getEditor().addPatternModificationListener(parametersContentProvider);
            PatternSpecificationPage.this._parametersViewer.setContentProvider((IContentProvider)parametersContentProvider);
            PatternSpecificationPage.this._parametersViewer.setLabelProvider((IBaseLabelProvider)new ParametersLabelProvider());
            toolkit.adapt(listComposite);
            PatternSpecificationPage.this._parametersViewer.setInput((Object)"");
            return PatternSpecificationPage.this._parametersViewer;
        }

        protected IContentHandler getContentHandler() {
            return this._contentHandler;
        }

        protected boolean isEditable() {
            return PatternSpecificationPage.this.isEditable();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SpecificationBlock
    extends AbstractPatternBlock
    implements IDetailsPageProvider {
        protected SpecificationBlock() {
        }

        @Override
        protected Couple<Viewer, IFormPart> doCreateMasterFormContent(FormToolkit toolkit_p, Composite parent_p, PatternHandler.PatternData patternData_p, IManagedForm managedForm_p) {
            return this.createParametersSection(toolkit_p, parent_p, patternData_p);
        }

        protected Couple<Viewer, IFormPart> createParametersSection(FormToolkit toolkit_p, Composite parent_p, PatternHandler.PatternData patternData_p) {
            Couple result = null;
            Composite parametersParentComposite = FormHelper.createCompositeWithLayoutType((FormToolkit)toolkit_p, (Composite)parent_p, (FormHelper.LayoutType)FormHelper.LayoutType.GRID_LAYOUT, (int)1, (boolean)false);
            Couple parametersCouple = FormHelper.createSectionWithChildComposite((FormToolkit)toolkit_p, (Composite)parametersParentComposite, (int)320, (FormHelper.LayoutType)FormHelper.LayoutType.GRID_LAYOUT, (int)1, (boolean)false);
            Section parametersSection = (Section)parametersCouple.getKey();
            parametersSection.setText(Messages.PatternSpecificationPage_Section_Parameters_Text);
            Composite parametersComposite = (Composite)parametersCouple.getValue();
            Label parametersLabel = toolkit_p.createLabel(parametersComposite, Messages.PatternSpecificationPage_Parameters_Label_Text);
            GridData plData = new GridData(768);
            plData.horizontalSpan = 2;
            parametersLabel.setLayoutData((Object)plData);
            ParametersViewer parametersViewer = new ParametersViewer(parametersComposite);
            result = new Couple((Object)parametersViewer.getDecoratedViewer(), (Object)new SectionPart(parametersSection));
            return result;
        }

        protected void registerPages(DetailsPart detailsPart_p) {
            detailsPart_p.setPageProvider((IDetailsPageProvider)this);
            detailsPart_p.setPageLimit(10);
        }

        public IDetailsPage getPage(final Object key_p) {
            ParameterDetails result = null;
            if (key_p instanceof ParameterRelation) {
                result = new ParameterDetails(PatternSpecificationPage.this, this.getMasterPart()){

                    protected Object getInitialContent() {
                        return key_p;
                    }
                };
            }
            return result;
        }

        public Object getPageKey(Object object_p) {
            return object_p;
        }
    }
}

