/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.editor.page;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.egf.common.misc.Couple;
import org.eclipse.egf.common.ui.helper.DataBindingHelper;
import org.eclipse.egf.common.ui.helper.FormHelper;
import org.eclipse.egf.common.ui.helper.MessageFormatHelper;
import org.eclipse.egf.common.ui.toolkit.widgets.handler.SelectionChangedHandler;
import org.eclipse.egf.common.ui.viewers.IButtonClickedListener;
import org.eclipse.egf.common.ui.viewers.ViewerWithAddAndRemove;
import org.eclipse.egf.pattern.Pattern;
import org.eclipse.egf.pattern.ecore.AbstractPatternGenerator;
import org.eclipse.egf.pattern.ecore.AnnotationHandler;
import org.eclipse.egf.pattern.ecore.PatternHandler;
import org.eclipse.egf.pattern.production.template.TemplateHelper;
import org.eclipse.egf.pattern.ui.PatternUiActivator;
import org.eclipse.egf.pattern.ui.editor.page.AbstractPatternBlock;
import org.eclipse.egf.pattern.ui.editor.page.AbstractPatternDetails;
import org.eclipse.egf.pattern.ui.editor.page.AbstractPatternPage;
import org.eclipse.egf.pattern.ui.editor.page.Messages;
import org.eclipse.egf.pattern.ui.internal.editor.DefaultPatternModificationNotification;
import org.eclipse.egf.pattern.ui.internal.editor.IPatternModificationListener;
import org.eclipse.egf.pattern.ui.internal.editor.IPatternModificationNotification;
import org.eclipse.egf.pattern.ui.internal.editor.page.AbstractPatternPageContentProvider;
import org.eclipse.egf.pattern.ui.internal.editor.page.DefaultContentHandler;
import org.eclipse.egf.pattern.ui.internal.editor.page.implementation.InternalMethodHandler;
import org.eclipse.egf.pattern.ui.internal.editor.page.implementation.InternalMethodHelper;
import org.eclipse.egf.pattern.ui.internal.editor.page.implementation.InternalMethodsLabelProvider;
import org.eclipse.egf.pattern.ui.internal.editor.page.implementation.MethodActionHandler;
import org.eclipse.egf.pattern.ui.internal.editor.page.implementation.MethodPatternCodeDetailsViewer;
import org.eclipse.egf.pattern.ui.internal.editor.page.implementation.MethodPatternCodeViewer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.DetailsPart;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IDetailsPageProvider;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class PatternImplementationPage
extends AbstractPatternPage {
    public static final String ID = "egf_pattern_implementation_page";
    protected static final String HELP_CONTEXT_ID = String.valueOf(PatternUiActivator.getDefault().getPluginID()) + '.' + "egf_pattern_implementation_page";
    protected List<InternalMethodHandler> _handledMethods;
    protected StructuredViewer _internalMethodsviewer;
    protected MethodPatternCodeViewer _publicMethodViewer;
    private IBlockFactory _temporaryFactory;

    public PatternImplementationPage(FormEditor editor_p) {
        super(editor_p, ID, Messages.PatternImplementationPage_Title);
        this.getExternalSelectionManager().addExternalHandlerFor(InternalMethodHandler.class, this);
    }

    public void dispose() {
        this.getExternalSelectionManager().removeExternalHandler(this, InternalMethodHandler.class);
        super.dispose();
    }

    public void handleSelection(Object firstSelectedObject_p, IStructuredSelection selection_p) {
        if (!this.isActive()) {
            this.getEditor().setActivePage(ID);
        }
        if (this._internalMethodsviewer != null) {
            this._internalMethodsviewer.setSelection((ISelection)new StructuredSelection(firstSelectedObject_p));
        }
    }

    protected void doCreateFormContent(FormToolkit toolkit_p, Composite parent_p, PatternHandler.PatternData patternData_p, IManagedForm managedForm_p) {
        this._temporaryFactory = new IBlockFactory(){

            public AbstractPatternBlock createBlock() {
                return new InternalMethodsBlock();
            }
        };
        super.doCreateFormContent(toolkit_p, parent_p, patternData_p, managedForm_p);
        this._temporaryFactory = new IBlockFactory(){

            public AbstractPatternBlock createBlock() {
                return new GenerateMethodBlock();
            }
        };
        super.doCreateFormContent(toolkit_p, parent_p, patternData_p, managedForm_p);
    }

    protected AbstractPatternBlock createPatternBlock() {
        AbstractPatternBlock result = this._temporaryFactory.createBlock();
        this._temporaryFactory = null;
        return result;
    }

    public void editorAboutToBeSaved() {
        if (this._publicMethodViewer != null) {
            this._publicMethodViewer.savePatternCode();
        }
    }

    protected void dataSaved() {
        if (this._handledMethods != null) {
            this._handledMethods.clear();
            if (this._internalMethodsviewer != null) {
                this._internalMethodsviewer.setInput((Object)this.getPatternData());
                this._internalMethodsviewer.setSelection((ISelection)StructuredSelection.EMPTY);
            }
            if (this._publicMethodViewer != null) {
                this._publicMethodViewer.setInput(this.getPatternData().getGenerateOperation());
                this._publicMethodViewer.setSelection((ISelection)StructuredSelection.EMPTY);
            }
        }
    }

    public String getHelpContextId() {
        return HELP_CONTEXT_ID;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class GenerateMethodBlock
    extends AbstractPatternBlock
    implements IDetailsPageProvider {
        protected GenerateMethodBlock() {
        }

        @Override
        protected Couple<Viewer, IFormPart> doCreateMasterFormContent(FormToolkit toolkit_p, Composite parent_p, PatternHandler.PatternData patternData_p, IManagedForm managedForm_p) {
            return this.createPublicMethodSection(toolkit_p, parent_p, patternData_p);
        }

        protected Couple<Viewer, IFormPart> createPublicMethodSection(FormToolkit toolkit_p, Composite parent_p, PatternHandler.PatternData patternData_p) {
            Couple result = null;
            Composite methodParentComposite = FormHelper.createCompositeWithLayoutType((FormToolkit)toolkit_p, (Composite)parent_p, (FormHelper.LayoutType)FormHelper.LayoutType.GRID_LAYOUT, (int)1, (boolean)false);
            Couple methodCouple = FormHelper.createSectionWithChildComposite((FormToolkit)toolkit_p, (Composite)methodParentComposite, (int)320, (FormHelper.LayoutType)FormHelper.LayoutType.GRID_LAYOUT, (int)1, (boolean)false);
            Section methodSection = (Section)methodCouple.getKey();
            methodSection.setText(Messages.PatternImplementationPage_GenerateMethodSectionText);
            Composite methodComposite = (Composite)methodCouple.getValue();
            toolkit_p.createLabel(methodComposite, Messages.PatternImplementationPage_GenerateMethodSectionDescription);
            PatternImplementationPage.this._publicMethodViewer = new MethodPatternCodeViewer(PatternImplementationPage.this, methodComposite){

                protected boolean isEditable() {
                    return PatternImplementationPage.this.isEditable();
                }
            };
            List<String> availableActions = Arrays.asList("CALL", "PATTERN", "SUPER");
            PatternImplementationPage.this._publicMethodViewer.initialize(availableActions, true, false);
            PatternImplementationPage.this._publicMethodViewer.setInput(PatternImplementationPage.this.getPatternData().getGenerateOperation());
            result = new Couple((Object)PatternImplementationPage.this._publicMethodViewer.getDecoratedViewer(), (Object)new SectionPart(methodSection));
            return result;
        }

        protected void registerPages(DetailsPart detailsPart_p) {
            detailsPart_p.setPageLimit(0);
            detailsPart_p.setPageProvider((IDetailsPageProvider)this);
        }

        public IDetailsPage getPage(final Object key_p) {
            MethodPatternCodeDetailsViewer result = null;
            if (key_p instanceof MethodActionHandler) {
                result = new MethodPatternCodeDetailsViewer(this.getMasterPart(), PatternImplementationPage.this){

                    protected Object getInitialContent() {
                        return key_p;
                    }
                };
            }
            return result;
        }

        public Object getPageKey(Object object_p) {
            return object_p;
        }
    }

    private static interface IBlockFactory {
        public AbstractPatternBlock createBlock();
    }

    protected class InternalMethodLinkListener
    extends HyperlinkAdapter {
        protected static final String DATA_BINDING_METHOD_NAME = "methodName";
        private InternalMethodHandler _selectedHandler;

        protected InternalMethodLinkListener() {
        }

        protected void setSelectedHandler(InternalMethodHandler handler_p) {
            this._selectedHandler = handler_p;
        }

        protected boolean isModifiable() {
            boolean result = false;
            if (this._selectedHandler != null) {
                result = this._selectedHandler.isModifiable();
            }
            return result;
        }

        protected EOperation getMethod() {
            EOperation result = null;
            if (this._selectedHandler != null) {
                result = this._selectedHandler.getMethod();
            }
            return result;
        }

        public void setMethodName(String newName_p) {
            this._selectedHandler.setMethodName(newName_p);
        }

        public String getMethodName() {
            if (this._selectedHandler != null) {
                return this._selectedHandler.getMethodName();
            }
            return "";
        }

        public void linkActivated(HyperlinkEvent he_p) {
            InternalMethodHelper.openMethodContent(PatternImplementationPage.this.getPatternData(), this._selectedHandler, PatternImplementationPage.this.isEditable());
        }

        public void addPropertyChangeListener(String propertyName_p, PropertyChangeListener listener_p) {
        }

        public void removePropertyChangeListener(String propertyName_p, PropertyChangeListener listener_p) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class InternalMethodsBlock
    extends AbstractPatternBlock
    implements IDetailsPageProvider {
        protected InternalMethodsBlock() {
        }

        @Override
        protected Couple<Viewer, IFormPart> doCreateMasterFormContent(FormToolkit toolkit_p, Composite parent_p, PatternHandler.PatternData patternData_p, IManagedForm managedForm_p) {
            return this.createInternalMethodsSection(toolkit_p, parent_p, patternData_p);
        }

        protected Couple<Viewer, IFormPart> createInternalMethodsSection(FormToolkit toolkit_p, Composite parent_p, PatternHandler.PatternData patternData_p) {
            Couple result = null;
            Composite methodsParentComposite = FormHelper.createCompositeWithLayoutType((FormToolkit)toolkit_p, (Composite)parent_p, (FormHelper.LayoutType)FormHelper.LayoutType.GRID_LAYOUT, (int)1, (boolean)false);
            Couple methodsCouple = FormHelper.createSectionWithChildComposite((FormToolkit)toolkit_p, (Composite)methodsParentComposite, (int)320, (FormHelper.LayoutType)FormHelper.LayoutType.GRID_LAYOUT, (int)1, (boolean)false);
            Section methodsSection = (Section)methodsCouple.getKey();
            methodsSection.setText(Messages.PatternImplementationPage_InternalMethodsSectionText);
            Composite methodsComposite = (Composite)methodsCouple.getValue();
            toolkit_p.createLabel(methodsComposite, Messages.PatternImplementationPage_InternalMethodsSectionDescriptionLabel);
            InternalMethodsViewer viewer = new InternalMethodsViewer(methodsComposite);
            result = new Couple((Object)viewer.getDecoratedViewer(), (Object)new SectionPart(methodsSection));
            return result;
        }

        protected void registerPages(DetailsPart detailsPart_p) {
            detailsPart_p.setPageProvider((IDetailsPageProvider)this);
            detailsPart_p.setPageLimit(10);
        }

        public IDetailsPage getPage(final Object key_p) {
            InternalMethodsDetails result = null;
            if (key_p instanceof InternalMethodHandler) {
                result = new InternalMethodsDetails(PatternImplementationPage.this, this.getMasterPart()){

                    protected Object getInitialContent() {
                        return key_p;
                    }
                };
            }
            return result;
        }

        public Object getPageKey(Object object_p) {
            return object_p;
        }
    }

    protected class InternalMethodsContentProvider
    extends AbstractPatternPageContentProvider {
        protected InternalMethodsContentProvider() {
        }

        protected ListViewer getViewer() {
            return (ListViewer)super.getViewer();
        }

        protected void doDispose() {
        }

        protected void doHandleElementUpdated(Object oldInput_p, Object newInput_p) {
            this.getViewer().update(newInput_p, null);
        }

        protected void doHandleElementsAdded(Object addedElements_p) {
            PatternImplementationPage.this._handledMethods.add((InternalMethodHandler)addedElements_p);
            this.getViewer().add(addedElements_p);
        }

        protected void doHandleElementsRemoved(Object removedElements_p) {
            PatternImplementationPage.this._handledMethods.remove(removedElements_p);
            this.getViewer().remove(removedElements_p);
        }

        public Object[] getElements(Object inputElement_p) {
            Object[] handlers = null;
            if (inputElement_p instanceof PatternHandler.PatternData) {
                final PatternHandler.PatternData patternData = (PatternHandler.PatternData)inputElement_p;
                if (PatternImplementationPage.this._handledMethods == null) {
                    PatternImplementationPage.this._handledMethods = new ArrayList<InternalMethodHandler>(0);
                } else {
                    PatternImplementationPage.this._handledMethods.clear();
                }
                InternalMethodHelper.IInternalMethodHandlerFactory factory = new InternalMethodHelper.IInternalMethodHandlerFactory(){

                    public InternalMethodHandler createNewHandler(EOperation method_p) {
                        return new InternalMethodHandler(PatternImplementationPage.this, method_p, patternData, InternalMethodsContentProvider.this.getViewer().getContentProvider());
                    }
                };
                handlers = InternalMethodHelper.getInternalMethodsFromInput(patternData, factory);
                Collections.addAll(PatternImplementationPage.this._handledMethods, handlers);
            }
            return handlers;
        }
    }

    protected abstract class InternalMethodsDetails
    extends AbstractPatternDetails {
        public InternalMethodsDetails(IFormPart masterPart_p) {
            super(masterPart_p);
        }

        protected void doCreateContents(FormToolkit toolkit_p, Composite parent_p, Object initialContent_p) {
            InternalMethodHandler methodHandler = (InternalMethodHandler)initialContent_p;
            InternalMethodLinkListener listener = new InternalMethodLinkListener();
            listener.setSelectedHandler(methodHandler);
            FormHelper.updateCompositeLayoutWithLayoutType((Composite)parent_p, (FormHelper.LayoutType)FormHelper.LayoutType.GRID_LAYOUT, (int)1, (boolean)false);
            Couple methodCouple = FormHelper.createSectionWithChildComposite((FormToolkit)toolkit_p, (Composite)parent_p, (int)320, (FormHelper.LayoutType)FormHelper.LayoutType.GRID_LAYOUT, (int)2, (boolean)false);
            Section methodSection = (Section)methodCouple.getKey();
            methodSection.setText(Messages.PatternImplementationPage_InternalMethodPropertiesSectionText);
            Composite methodComposite = (Composite)methodCouple.getValue();
            Couple methodName = FormHelper.createLabelAndText((FormToolkit)toolkit_p, (Composite)methodComposite, (String)Messages.PatternImplementationPage_InternalMethodPropertiesSectionNameLabel, null, (boolean)listener.isModifiable());
            Text methodNameText = (Text)methodName.getValue();
            MethodNameValidator methodNameValidator = null;
            if (PatternImplementationPage.this.isEditable()) {
                methodNameValidator = new MethodNameValidator((Control)methodNameText, methodHandler);
            }
            DataBindingHelper.bindTextToProperty((Control)methodNameText, (String)"methodName", (Object)((Object)listener), methodNameValidator);
            methodNameText.setEditable(PatternImplementationPage.this.isEditable());
            Image image = JavaPlugin.getDefault().getImageRegistry().get("org.eclipse.jdt.ui.template_obj.gif");
            FormHelper.createLinkWithDescription((FormToolkit)toolkit_p, (Composite)methodComposite, (Image)image, (String)Messages.PatternImplementationPage_InternalMethodPropertiesSectionContentLabel, null, (String)Messages.PatternImplementationPage_InternalMethodPropertiesSectionContentDescription, (IHyperlinkListener)listener);
            Composite methodContentComposite = FormHelper.createCompositeWithLayoutType((FormToolkit)toolkit_p, (Composite)methodComposite, (FormHelper.LayoutType)FormHelper.LayoutType.GRID_LAYOUT, (int)1, (boolean)false);
            GridData layoutData = (GridData)methodContentComposite.getLayoutData();
            layoutData.horizontalSpan = 2;
            MethodPatternCodeViewer patternCodeViewer = new MethodPatternCodeViewer(PatternImplementationPage.this, methodContentComposite){

                protected boolean isEditable() {
                    return PatternImplementationPage.this.isEditable();
                }
            };
            List<String> availableActions = Arrays.asList("SUPER");
            patternCodeViewer.initialize(availableActions, false, true);
            patternCodeViewer.setInput(listener.getMethod());
        }
    }

    protected class InternalMethodsHandler
    extends DefaultContentHandler
    implements IButtonClickedListener {
        private int _methodNameIncrement;
        private StructuredViewer _viewer;

        protected InternalMethodsHandler(PatternHandler.PatternData patternData_p, StructuredViewer viewer_p) {
            super(patternData_p, PatternImplementationPage.this);
            this._viewer = viewer_p;
            this._methodNameIncrement = 0;
        }

        protected String getNewMethodName(Pattern pattern_p) {
            String result = "";
            EList existingOperations = pattern_p.getEOperations();
            block0: while ("".equals(result)) {
                result = MessageFormatHelper.formatMessage((String)Messages.PatternImplementationPage_NewMethodNamePattern, (Object[])new Object[]{this._methodNameIncrement++});
                for (EOperation operation : existingOperations) {
                    if (!result.equals(operation.getName())) continue;
                    result = "";
                    continue block0;
                }
            }
            return result;
        }

        protected InternalMethodHandler createNewMethod() {
            AnnotationHandler annotationHandler = new AnnotationHandler();
            Pattern pattern = this.getPattern();
            EOperation newOperation = AbstractPatternGenerator.addOperation((Pattern)pattern, (String)this.getNewMethodName(pattern));
            String UID = annotationHandler.addUidAnnotation(newOperation);
            String fileRelativePath = TemplateHelper.getTemplateRelativePath((String)this.getPatternData().getPattern().getShortId(), (String)this.getPatternData().getFactoryComponentId(), (String)newOperation.getName(), (String)UID);
            annotationHandler.addReadFilePatternCode(newOperation, fileRelativePath);
            annotationHandler.translateAnnotations(Collections.singletonList(newOperation));
            return new InternalMethodHandler(PatternImplementationPage.this, newOperation, this.getPatternData(), this._viewer.getContentProvider());
        }

        protected void removeMethod(InternalMethodHandler handler_p) {
            EOperation removedMethod = handler_p.getMethod();
            AbstractPatternGenerator.removeOperation((Pattern)this.getPatternData().getPattern(), (EOperation)removedMethod);
        }

        protected InternalMethodHandler getSelectedHandler() {
            InternalMethodHandler selectedHandler = null;
            ISelection selection = this._viewer.getSelection();
            if (selection instanceof IStructuredSelection) {
                selectedHandler = (InternalMethodHandler)((IStructuredSelection)selection).getFirstElement();
            }
            return selectedHandler;
        }

        public void buttonClicked(Button clickedButton_p, Object data_p) {
            IContentProvider contentProvider = this._viewer.getContentProvider();
            boolean notifyChange = false;
            if ("LV_ADD".equals(data_p)) {
                InternalMethodHandler newHandler = this.createNewMethod();
                DefaultPatternModificationNotification notification = DefaultPatternModificationNotification.createNotification(1, this.getPattern(), null, newHandler.getMethod());
                PatternImplementationPage.this.getEditor().sendNotification(notification);
                contentProvider.inputChanged((Viewer)this._viewer, null, (Object)newHandler);
                notifyChange = true;
            } else if ("LV_REMOVE".equals(data_p)) {
                InternalMethodHandler oldHandler = this.getSelectedHandler();
                this.removeMethod(oldHandler);
                DefaultPatternModificationNotification notification = DefaultPatternModificationNotification.createNotification(2, this.getPattern(), oldHandler.getMethod(), null);
                PatternImplementationPage.this.getEditor().sendNotification(notification);
                contentProvider.inputChanged((Viewer)this._viewer, (Object)oldHandler, null);
                notifyChange = true;
            }
            if (notifyChange) {
                this.notifyModification();
            }
        }
    }

    protected class InternalMethodsViewer
    extends ViewerWithAddAndRemove {
        protected InternalMethodsViewer(Composite parent_p) {
            super(parent_p);
        }

        protected boolean isEditable() {
            return PatternImplementationPage.this.isEditable();
        }

        protected InternalMethodHandler getSelectedHandler() {
            InternalMethodHandler selectedHandler = null;
            ISelection selection = this.getDecoratedViewer().getSelection();
            if (selection instanceof IStructuredSelection) {
                selectedHandler = (InternalMethodHandler)((IStructuredSelection)selection).getFirstElement();
            }
            return selectedHandler;
        }

        protected SelectionChangedHandler createRemoveHandler() {
            SelectionChangedHandler removeHandler = new SelectionChangedHandler(){

                protected boolean doHandleSelection(ISelection selection_p) {
                    boolean result = false;
                    InternalMethodHandler selectedHandler = InternalMethodsViewer.this.getSelectedHandler();
                    if (selectedHandler != null) {
                        result = selectedHandler.isModifiable();
                    }
                    return result;
                }
            };
            return removeHandler;
        }

        protected StructuredViewer createViewer(Composite composite_p) {
            FormToolkit toolkit = PatternImplementationPage.this.getManagedForm().getToolkit();
            Composite listComposite = FormHelper.createCompositeWithLayoutType((FormToolkit)toolkit, (Composite)composite_p, (FormHelper.LayoutType)FormHelper.LayoutType.GRID_LAYOUT, (int)1, (boolean)false);
            PatternImplementationPage.this._internalMethodsviewer = new ListViewer(listComposite, 2820);
            FormHelper.updateControlLayoutDataWithLayoutTypeData((Control)PatternImplementationPage.this._internalMethodsviewer.getControl(), (FormHelper.LayoutType)FormHelper.LayoutType.GRID_LAYOUT);
            PatternImplementationPage.this._internalMethodsviewer.setContentProvider((IContentProvider)new InternalMethodsContentProvider());
            PatternImplementationPage.this._internalMethodsviewer.setLabelProvider((IBaseLabelProvider)new InternalMethodsLabelProvider());
            PatternImplementationPage.this._internalMethodsviewer.setSorter(new ViewerSorter());
            PatternImplementationPage.this._internalMethodsviewer.setInput((Object)PatternImplementationPage.this.getPatternData());
            toolkit.adapt(listComposite);
            this.setButtonClickedListener(new InternalMethodsHandler(PatternImplementationPage.this.getPatternData(), PatternImplementationPage.this._internalMethodsviewer));
            return PatternImplementationPage.this._internalMethodsviewer;
        }
    }

    protected class MethodNameValidator
    extends AbstractPatternPage.TextValidator
    implements IPatternModificationListener {
        protected static final String ERROR_KEY_NOT_UNIQUE_NAME = "NotUniqueMethodName";
        private InternalMethodHandler _methodHandler;

        protected MethodNameValidator(Control control_p, InternalMethodHandler currentMethodHandler_p) {
            super(control_p);
            this.setRegularExpression(Messages.PatternImplementationPage_MethodNameRegularExpression);
            this._methodHandler = currentMethodHandler_p;
            PatternImplementationPage.this.getEditor().addPatternModificationListener(this);
        }

        protected boolean onError(String text_p) {
            boolean result = super.onError(text_p);
            if (!result) {
                EList operations = PatternImplementationPage.this.getPatternData().getPattern().getEOperations();
                for (EOperation operation : operations) {
                    boolean bl = result = operation != this._methodHandler.getMethod() && operation.getName().equals(text_p);
                    if (!result) continue;
                    this.addErrorKey(ERROR_KEY_NOT_UNIQUE_NAME);
                    break;
                }
            }
            return result;
        }

        protected String getErrorMessageFor(String errorKey_p, String value_p) {
            Object[] parameters = new Object[]{value_p};
            if ("RegExp" == errorKey_p) {
                return MessageFormatHelper.formatMessage((String)Messages.PatternImplementationPage_MethodNameMalformedError, (Object[])parameters);
            }
            if (ERROR_KEY_NOT_UNIQUE_NAME == errorKey_p) {
                return MessageFormatHelper.formatMessage((String)Messages.PatternImplementationPage_MethodNameNotUniqueError, (Object[])parameters);
            }
            return null;
        }

        public void notifyChanged(IPatternModificationNotification notification_p) {
            if (2 != notification_p.getEventType()) {
                return;
            }
            Object removedObject = notification_p.getOldValue();
            if (this._methodHandler.getMethod() == removedObject) {
                PatternImplementationPage.this.clearErrors(this.getControl());
                PatternImplementationPage.this.getEditor().removePatternModificationListener(this);
            }
        }
    }
}

