/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.editor.page;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.egf.pattern.ecore.PatternHandler;
import org.eclipse.egf.pattern.ui.editor.PatternEditor;
import org.eclipse.egf.pattern.ui.editor.page.AbstractPatternBlock;
import org.eclipse.egf.pattern.ui.editor.page.ExternalSelectionManager;
import org.eclipse.egf.pattern.ui.editor.page.IExternalSelectionHandler;
import org.eclipse.egf.pattern.ui.editor.page.Messages;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class AbstractPatternPage
extends FormPage
implements IExternalSelectionHandler {
    private boolean _isDirty;
    private IMessageManager _messageManager;
    private Map<Control, Integer> _errorsCount;

    public AbstractPatternPage(FormEditor editor_p, String id_p, String title_p) {
        super(editor_p, id_p, title_p);
    }

    public void handleSelection(Object firstSelectedObject_p, IStructuredSelection selection_p) {
    }

    public abstract String getHelpContextId();

    public void editorAboutToBeSaved() {
    }

    public final void editorSaved() {
        this.setDirty(false);
        this.dataSaved();
    }

    public void setDirty(boolean isDirty_p) {
        this._isDirty = isDirty_p;
        this.getEditor().editorDirtyStateChanged();
    }

    public boolean isDirty() {
        return this._isDirty;
    }

    public boolean isEditable() {
        return this.getPatternHandler().isEditable();
    }

    protected void dataSaved() {
    }

    public PatternHandler.PatternData getPatternData() {
        return this.getEditor().getPatternData(null);
    }

    protected PatternHandler getPatternHandler() {
        return this.getEditor().getPatternHandler();
    }

    protected ExternalSelectionManager getExternalSelectionManager() {
        return (ExternalSelectionManager)this.getEditor().getAdapter(ExternalSelectionManager.class);
    }

    public boolean hasErrors() {
        return this._errorsCount != null && this._errorsCount.size() > 0;
    }

    private void incrementErrorCount(Control control_p) {
        Integer count;
        if (this._errorsCount == null) {
            this._errorsCount = new HashMap<Control, Integer>(0);
        }
        if ((count = this._errorsCount.get(control_p)) == null) {
            count = new Integer(1);
        } else {
            Integer n = count;
            count = n + 1;
            count = n;
        }
        this._errorsCount.put(control_p, count);
    }

    private void removeErrorCount(Control control_p) {
        if (this._errorsCount != null) {
            this._errorsCount.remove(control_p);
        }
    }

    protected void reportError(Control control_p, String errorText_p, String errorKey_p) {
        if (errorText_p != null && control_p != null && errorKey_p != null) {
            this._messageManager.addMessage((Object)errorKey_p, errorText_p, null, 3, control_p);
            this.incrementErrorCount(control_p);
        }
    }

    protected void clearErrors(Control control_p) {
        if (control_p != null) {
            this._messageManager.removeMessages(control_p);
            this.removeErrorCount(control_p);
        }
    }

    public PatternEditor getEditor() {
        return (PatternEditor)super.getEditor();
    }

    protected void createFormContent(IManagedForm managedForm_p) {
        FormToolkit toolkit = managedForm_p.getToolkit();
        Composite body = managedForm_p.getForm().getBody();
        this._messageManager = managedForm_p.getMessageManager();
        PatternHandler.PatternData patternData = this.getPatternData();
        if (patternData != null) {
            this.doCreateFormContent(toolkit, body, patternData, managedForm_p);
        } else {
            toolkit.createLabel(body, Messages.AbstractPatternPage_NoPatternDataLabel);
        }
    }

    protected abstract AbstractPatternBlock createPatternBlock();

    protected void doCreateFormContent(FormToolkit toolkit_p, Composite parent_p, PatternHandler.PatternData patternData_p, IManagedForm managedForm_p) {
        AbstractPatternBlock block = this.createPatternBlock();
        if (block != null) {
            block.setPatternData(patternData_p);
            block.createContent(managedForm_p);
        }
    }

    protected abstract class TextValidator
    implements IValueChangeListener {
        protected static final String ERROR_KEY_REG_EXP = "RegExp";
        private Control _control;
        private String _regularExpression;
        private List<String> _errorKeys;

        protected TextValidator(Control textControl_p) {
            this._control = textControl_p;
        }

        protected Control getControl() {
            return this._control;
        }

        public void handleValueChange(ValueChangeEvent event_p) {
            if (this._errorKeys == null) {
                this._errorKeys = new ArrayList<String>(0);
            } else {
                this._errorKeys.clear();
            }
            String newValue = (String)event_p.getObservableValue().getValue();
            if (this.onError(newValue)) {
                for (String errorKey : this._errorKeys) {
                    AbstractPatternPage.this.reportError(this._control, this.getErrorMessageFor(errorKey, newValue), errorKey);
                }
            } else {
                AbstractPatternPage.this.clearErrors(this._control);
            }
        }

        protected void setRegularExpression(String regularExpression_p) {
            this._regularExpression = regularExpression_p;
        }

        protected void addErrorKey(String errorKey_p) {
            if (this._errorKeys != null) {
                this._errorKeys.add(errorKey_p);
            }
        }

        protected boolean onError(String text_p) {
            boolean result;
            boolean bl = result = this._regularExpression != null && !text_p.matches(this._regularExpression);
            if (result) {
                this.addErrorKey(ERROR_KEY_REG_EXP);
            }
            return result;
        }

        protected abstract String getErrorMessageFor(String var1, String var2);
    }
}

