/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egf.common.ui.helper.MessageFormatHelper;
import org.eclipse.egf.model.PatternModel;
import org.eclipse.egf.model.provider.FactoryComponentEditPlugin;
import org.eclipse.egf.pattern.Pattern;
import org.eclipse.egf.pattern.ecore.PatternHandler;
import org.eclipse.egf.pattern.ui.editor.Messages;
import org.eclipse.egf.pattern.ui.editor.page.AbstractPatternPage;
import org.eclipse.egf.pattern.ui.editor.page.ExternalSelectionManager;
import org.eclipse.egf.pattern.ui.editor.page.IExternalSelectionProvider;
import org.eclipse.egf.pattern.ui.editor.page.PatternImplementationPage;
import org.eclipse.egf.pattern.ui.editor.page.PatternInheritancePage;
import org.eclipse.egf.pattern.ui.editor.page.PatternOverviewPage;
import org.eclipse.egf.pattern.ui.editor.page.PatternProductionPage;
import org.eclipse.egf.pattern.ui.editor.page.PatternSpecificationPage;
import org.eclipse.egf.pattern.ui.editor.util.PatternEditorPageLinkListener;
import org.eclipse.egf.pattern.ui.internal.editor.DefaultPatternModificationNotification;
import org.eclipse.egf.pattern.ui.internal.editor.IPatternModificationListener;
import org.eclipse.egf.pattern.ui.internal.editor.IPatternModificationNotification;
import org.eclipse.egf.pattern.ui.internal.editor.PatternEditorContentOutlinePage;
import org.eclipse.egf.pattern.validation.PatternValidationHelper;
import org.eclipse.emf.common.ui.dialogs.DiagnosticDialog;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.editor.SharedHeaderFormEditor;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class PatternEditor
extends SharedHeaderFormEditor
implements ISelectionListener {
    private static final Logger __logger = Logger.getLogger((String)PatternEditor.class.getPackage().getName());
    public static final String ID = PatternEditor.class.getName();
    private PatternEditorPageLinkListener _pageLinksListener;
    private HashMap<Integer, AbstractPatternPage> _pages;
    private Collection<IPatternModificationListener> _modificationListeners;
    private IContentOutlinePage _contentOutlinePage;
    private ExternalSelectionManager _externalSelectionProvider;

    public void dispose() {
        super.dispose();
        this.getEditorSite().getPage().removeSelectionListener((ISelectionListener)this);
        if (this._externalSelectionProvider != null) {
            this._externalSelectionProvider.dispose();
            this._externalSelectionProvider = null;
        }
        if (this._modificationListeners != null) {
            this._modificationListeners.clear();
            this._modificationListeners = null;
        }
        if (this._pages != null) {
            this._pages.clear();
            this._pages = null;
        }
    }

    public void addPatternModificationListener(IPatternModificationListener listener_p) {
        if (this._modificationListeners == null) {
            this._modificationListeners = new HashSet<IPatternModificationListener>(1);
        }
        this._modificationListeners.add(listener_p);
    }

    public void removePatternModificationListener(IPatternModificationListener listener_p) {
        if (this._modificationListeners != null) {
            this._modificationListeners.remove(listener_p);
        }
    }

    public IPatternModificationListener[] getModificationListeners() {
        IPatternModificationListener[] result = null;
        if (this._modificationListeners != null) {
            result = this._modificationListeners.toArray(new IPatternModificationListener[this._modificationListeners.size()]);
        }
        if (result == null) {
            result = new IPatternModificationListener[]{};
        }
        return result;
    }

    public void sendNotification(IPatternModificationNotification notification_p) {
        IPatternModificationListener[] listeners;
        Assert.isNotNull((Object)notification_p);
        if (notification_p instanceof DefaultPatternModificationNotification) {
            ((DefaultPatternModificationNotification)notification_p).setPatternData(this.getPatternData(null));
        }
        IPatternModificationListener[] iPatternModificationListenerArray = listeners = this.getModificationListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IPatternModificationListener patternModificationListener = iPatternModificationListenerArray[n2];
            try {
                patternModificationListener.notifyChanged(notification_p);
            }
            catch (Exception e_p) {
                StringBuilder loggerMessage = new StringBuilder("PatternEditor.sendNotification(..) _ ");
                loggerMessage.append("Unhandled exception !");
                __logger.warn((Object)loggerMessage.toString(), (Throwable)e_p);
            }
            ++n2;
        }
    }

    public PatternHandler.PatternData getPatternData(IEditorInput editorInput_p) {
        PatternHandler.PatternData result = null;
        IEditorInput editorInput = editorInput_p;
        if (editorInput == null) {
            editorInput = this.getEditorInput();
        }
        if (editorInput != null) {
            result = (PatternHandler.PatternData)editorInput.getAdapter(PatternHandler.PatternData.class);
        }
        return result;
    }

    public PatternHandler getPatternHandler() {
        return (PatternHandler)this.getEditorInput().getAdapter(PatternHandler.class);
    }

    protected String getPatternDisplayableName(PatternHandler.PatternData patternData_p) {
        String displayableName = Messages.PatternEditor_DisplayableName;
        return MessageFormatHelper.formatMessage((String)displayableName, (Object[])new String[]{patternData_p.getPatternLogicalName()});
    }

    public void init(IEditorSite site_p, IEditorInput input_p) throws PartInitException {
        super.init(site_p, input_p);
        this.setPartName(this.getPatternDisplayableName(this.getPatternData(input_p)));
    }

    public int addPage(IFormPage page_p) throws PartInitException {
        int result = super.addPage(page_p);
        if (page_p instanceof AbstractPatternPage) {
            if (this._pages == null) {
                this._pages = new HashMap(1);
            }
            this._pages.put(result, (AbstractPatternPage)page_p);
        }
        return result;
    }

    protected void addPages() {
        try {
            this.addPage((IFormPage)new PatternOverviewPage((FormEditor)this));
            this.addPage((IFormPage)new PatternProductionPage((FormEditor)this));
            this.addPage((IFormPage)new PatternSpecificationPage((FormEditor)this));
            this.addPage((IFormPage)new PatternInheritancePage((FormEditor)this));
            this.addPage((IFormPage)new PatternImplementationPage((FormEditor)this));
            this.setActivePage(0);
        }
        catch (PartInitException exception_p) {
            StringBuilder loggerMessage = new StringBuilder("PatternEditor.addPages(..) _ ");
            __logger.warn((Object)loggerMessage.toString(), (Throwable)exception_p);
        }
        this.getEditorSite().getPage().addSelectionListener((ISelectionListener)this);
    }

    protected AbstractPatternPage[] getPages() {
        Collection<Object> result = this._pages != null ? this._pages.values() : new ArrayList(0);
        return result.toArray(new AbstractPatternPage[result.size()]);
    }

    public void doSave(IProgressMonitor monitor_p) {
        PatternHandler patternHandler = this.getPatternHandler();
        if (patternHandler != null) {
            AbstractPatternPage[] patternPages = this.getPages();
            boolean validationOk = this.handlePatternValidation(patternPages);
            if (!validationOk) {
                return;
            }
            try {
                AbstractPatternPage abstractPatternPage;
                AbstractPatternPage[] abstractPatternPageArray = patternPages;
                int n = patternPages.length;
                int n2 = 0;
                while (n2 < n) {
                    abstractPatternPage = abstractPatternPageArray[n2];
                    abstractPatternPage.editorAboutToBeSaved();
                    ++n2;
                }
                patternHandler.save((PatternModel)this.getEditorInput().getAdapter(PatternModel.class));
                this.setPartName(this.getPatternDisplayableName(this.getPatternData(null)));
                abstractPatternPageArray = patternPages;
                n = patternPages.length;
                n2 = 0;
                while (n2 < n) {
                    abstractPatternPage = abstractPatternPageArray[n2];
                    abstractPatternPage.editorSaved();
                    ++n2;
                }
                this.updateHeaderContents();
                this.editorDirtyStateChanged();
                DefaultPatternModificationNotification notification = DefaultPatternModificationNotification.createNotification(5, this.getPatternData(null), null, null);
                this.sendNotification(notification);
            }
            catch (Exception exception_p) {
                StringBuilder loggerMessage = new StringBuilder("PatternEditor.doSave(..) _ ");
                __logger.warn((Object)loggerMessage.toString(), (Throwable)exception_p);
            }
        }
    }

    protected boolean handlePatternValidation(AbstractPatternPage[] patternPages_p) {
        Pattern pattern = this.getPatternData(null).getPattern();
        final Object[] data = new Object[]{pattern};
        BasicDiagnostic diagnosticChain = new BasicDiagnostic("org.eclipse.emf.ecore", 0, Messages.PatternEditor_SaveError_PatternModelMessage, data);
        Diagnostic diagnostic = PatternValidationHelper.validatePattern((Pattern)pattern, (PatternValidationHelper.IValidationHandler)new PatternValidationHelper.IValidationHandler((DiagnosticChain)diagnosticChain){
            private final /* synthetic */ DiagnosticChain val$diagnosticChain;
            {
                this.val$diagnosticChain = diagnosticChain;
            }

            public DiagnosticChain createErrorRootDiagnostic() {
                BasicDiagnostic validationDiagnostic = new BasicDiagnostic(4, "org.eclipse.egf.pattern", 0, Messages.PatternEditor_ValidationErrorMessage, data);
                this.val$diagnosticChain.add((Diagnostic)validationDiagnostic);
                return validationDiagnostic;
            }
        });
        boolean validationError = 4 == diagnostic.getSeverity();
        BasicDiagnostic pagesDiagnostic = new BasicDiagnostic(4, "org.eclipse.egf.pattern", 0, Messages.PatternEditor_SaveError_PagesMessage, data);
        boolean syntaxError = false;
        AbstractPatternPage[] abstractPatternPageArray = patternPages_p;
        int n = patternPages_p.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractPatternPage pageOnError = abstractPatternPageArray[n2];
            if (pageOnError.hasErrors()) {
                if (!syntaxError) {
                    validationError = true;
                    syntaxError = true;
                    diagnosticChain.add((Diagnostic)pagesDiagnostic);
                }
                pagesDiagnostic.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.egf.pattern", 0, pageOnError.getTitle(), data));
            }
            ++n2;
        }
        if (validationError) {
            DiagnosticDialog.open((Shell)this.getSite().getShell(), (String)Messages.PatternEditor_SaveErrorTitle, (String)Messages.PatternEditor_SaveErrorMessage, (Diagnostic)((Diagnostic)diagnosticChain));
        }
        return !validationError;
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    protected ScrolledForm updateHeaderContents() {
        ScrolledForm form = this.getHeaderForm().getForm();
        form.setText(this.getPatternDisplayableName(this.getPatternData(null)));
        form.setImage(ExtendedImageRegistry.INSTANCE.getImage(FactoryComponentEditPlugin.INSTANCE.getImage("full/obj16/PatternModel")));
        this.getToolkit().decorateFormHeading(form.getForm());
        return form;
    }

    protected void createHeaderContents(IManagedForm headerForm_p) {
        final ScrolledForm form = this.updateHeaderContents();
        Action helpAction = new Action(){

            public void run() {
                BusyIndicator.showWhile((Display)form.getDisplay(), (Runnable)new Runnable(){

                    public void run() {
                        AbstractPatternPage activePage = (AbstractPatternPage)PatternEditor.this.getActivePageInstance();
                        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)form, activePage.getHelpContextId());
                        PlatformUI.getWorkbench().getHelpSystem().displayHelp(activePage.getHelpContextId());
                    }
                });
            }
        };
        helpAction.setToolTipText(Messages.PatternEditor_HelpButtonToolTip);
        helpAction.setImageDescriptor(JavaPlugin.getDefault().getImageRegistry().getDescriptor("org.eclipse.jdt.ui.help.gif"));
        form.getToolBarManager().add((IAction)helpAction);
        form.updateToolBar();
    }

    public Object getAdapter(Class adapter_p) {
        Object result = null;
        if (PatternEditorPageLinkListener.class.equals((Object)adapter_p)) {
            if (this._pageLinksListener == null) {
                this._pageLinksListener = new PatternEditorPageLinkListener(this);
            }
            result = this._pageLinksListener;
        } else if (IContentOutlinePage.class.equals((Object)adapter_p)) {
            if (this._contentOutlinePage == null) {
                PatternEditorContentOutlinePage patternEditorContentOutlinePage = new PatternEditorContentOutlinePage(this.getPatternData(null), this.getPatternHandler().isEditable());
                this.addPatternModificationListener(patternEditorContentOutlinePage);
                this._contentOutlinePage = patternEditorContentOutlinePage;
            }
            result = this._contentOutlinePage;
        } else if (IExternalSelectionProvider.class.equals((Object)adapter_p) || ExternalSelectionManager.class.equals((Object)adapter_p)) {
            if (this._externalSelectionProvider == null) {
                this._externalSelectionProvider = new ExternalSelectionManager();
            }
            result = this._externalSelectionProvider;
        }
        if (result == null) {
            result = super.getAdapter(adapter_p);
        }
        return result;
    }

    public void selectionChanged(IWorkbenchPart part_p, ISelection selection_p) {
        if (!(part_p instanceof ContentOutline) || !(selection_p instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)selection_p;
        Object selectedElement = selection.getFirstElement();
        IExternalSelectionProvider provider = (IExternalSelectionProvider)this.getAdapter(IExternalSelectionProvider.class);
        provider.fireExternalSelection(selectedElement, selection);
    }
}

