/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.production;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.egf.common.helper.FileHelper;
import org.eclipse.egf.common.helper.ProjectHelper;
import org.eclipse.egf.common.helper.StringHelper;
import org.eclipse.egf.common.misc.Couple;
import org.eclipse.egf.core.CoreActivator;
import org.eclipse.egf.model.Context;
import org.eclipse.egf.model.FactoryComponent;
import org.eclipse.egf.model.FactoryComponentInvocation;
import org.eclipse.egf.model.ModelFactory;
import org.eclipse.egf.model.data.helper.ModelHelper;
import org.eclipse.egf.pattern.PatternActivator;
import org.eclipse.egf.pattern.ecore.PatternHandler;
import org.eclipse.egf.pattern.ecore.condition.ConditionClassOutput;
import org.eclipse.egf.pattern.internal.ConditionMergeHelper;
import org.eclipse.egf.pattern.internal.production.jet.JetProductionContributor;
import org.eclipse.egf.pattern.production.IProductionContributor;
import org.eclipse.egf.pattern.production.template.TemplateHelper;
import org.eclipse.egf.pattern.relations.ParameterRelation;
import org.eclipse.egf.pde.EgfPdeActivator;
import org.eclipse.egf.pde.pattern.plugin.command.PatternConditionExtensionFactory;
import org.eclipse.egf.pde.plugin.command.IPluginChangesCommandRunner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneratedContentProducer {
    protected static final String CONDITION_SOURCE_FOLDER = "/src";
    private IProductionContributor _contributor = new JetProductionContributor();

    public IProductionContributor getProductionContributor() {
        return this._contributor;
    }

    public void produceConditionStructures(String fileRelativePath_p) throws Exception {
        PatternHandler.PatternData patternData = new PatternHandler().load(fileRelativePath_p);
        this.produceConditionStructures(patternData);
    }

    public void produceConditionStructures(PatternHandler.PatternData patternData_p) throws Exception {
        if (patternData_p == null) {
            return;
        }
        List<ParameterRelation> parameters = patternData_p.getAllParameters();
        if (parameters == null || parameters.isEmpty()) {
            this.removeOldConditionStructures(patternData_p);
            ProjectHelper.refreshProject((IProject)patternData_p.getJavaProject().getProject(), null);
            return;
        }
        this.updateConditionClass(patternData_p, parameters);
        this.replacePatternMatchingTemplates(patternData_p, parameters);
        ProjectHelper.refreshProject((IProject)patternData_p.getJavaProject().getProject(), null);
    }

    protected void producePublicParametersHandler(PatternHandler.PatternData patternData_p) {
        FactoryComponent fc = ModelHelper.createEmptyMinimalFC((String)"GeneratePublicParametersHandler");
        String generatorId = "asset.1212745121407.14";
        FactoryComponentInvocation fcInvocation = ModelHelper.addFactoryComponentInvocation((FactoryComponent)fc, (String)generatorId);
        Context context = ModelFactory.eINSTANCE.createContext();
        fcInvocation.setContext(context);
        String contributorId = PatternActivator.getDefault().getPluginID();
        ModelHelper.addReferencingContractContextElement((Context)context, (String)generatorId, (String)"contractElement.1212763579828.93", (String)patternData_p.getRealRelativePath(), (String)contributorId);
        ModelHelper.addReferencingContractContextElement((Context)context, (String)generatorId, (String)"contractElement.1212763518024.91", (String)patternData_p.getPatternName(), (String)contributorId);
        ModelHelper.addReferencingContractContextElement((Context)context, (String)generatorId, (String)"contractElement.1212763360724.90", (String)patternData_p.getPluginId(), (String)contributorId);
        CoreActivator.getDefault().generateFactoryComponentSynchronously(fc);
    }

    protected String getConditionClassContent(PatternHandler.PatternData patternData_p) {
        ConditionClassOutput.getSharedInstance().reset();
        FactoryComponent fc = ModelHelper.createEmptyMinimalFC((String)"GenerateConditionClass");
        String generatorId = "asset.1213692164306.87";
        FactoryComponentInvocation fcInvocation = ModelHelper.addFactoryComponentInvocation((FactoryComponent)fc, (String)generatorId);
        Context context = ModelFactory.eINSTANCE.createContext();
        fcInvocation.setContext(context);
        String contributorId = PatternActivator.getDefault().getPluginID();
        ModelHelper.addReferencingContractContextElement((Context)context, (String)generatorId, (String)"contractElement.1213715622825.42", (String)patternData_p.getRealRelativePath(), (String)contributorId);
        CoreActivator.getDefault().generateFactoryComponentSynchronously(fc);
        return ConditionClassOutput.getSharedInstance().getGeneratedConditionClassContent(patternData_p.getPattern().getId());
    }

    protected void updateConditionClass(PatternHandler.PatternData patternData_p, List<ParameterRelation> parameters_p) throws Exception {
        String resultingContent = this.getConditionClassContent(patternData_p);
        if (resultingContent == null || "".equals(resultingContent)) {
            throw new IllegalArgumentException();
        }
        String conditionClassRelativePath = GeneratedContentProducer.getConditionFileRelativePath(patternData_p);
        if (FileHelper.exists((String)conditionClassRelativePath)) {
            resultingContent = ConditionMergeHelper.merge(resultingContent, FileHelper.readFile((String)conditionClassRelativePath));
        }
        FileHelper.writeFile((String)conditionClassRelativePath, (boolean)true, (String)resultingContent);
        IPluginChangesCommandRunner runner = EgfPdeActivator.getDefault().getPluginChangesCommandRunner();
        runner.performChangesOnPlugin(patternData_p.getPluginId(), Collections.singletonList(PatternConditionExtensionFactory.setPatternConditionExtension((String)patternData_p.getPattern().getId(), (String)("org.eclipse.egf.condition" + '.' + GeneratedContentProducer.getConditionClassName(patternData_p)))));
    }

    public static String getConditionFileRelativePath(PatternHandler.PatternData patternData_p) {
        return GeneratedContentProducer.getGeneratedClassRelativePath(patternData_p.getPluginId(), CONDITION_SOURCE_FOLDER, "org.eclipse.egf.condition", GeneratedContentProducer.getConditionClassName(patternData_p));
    }

    public static String getGeneratedClassRelativePath(String pluginId_p, String sourceFolder_p, String packageName_p, String className_p) {
        if (pluginId_p == null || sourceFolder_p == null || packageName_p == null || className_p == null) {
            return "";
        }
        return pluginId_p + sourceFolder_p + '/' + FileHelper.convertPackageNameToFolderPath((String)packageName_p) + '/' + className_p + '.' + "java";
    }

    public static String getConditionClassName(PatternHandler.PatternData patternData_p) {
        return GeneratedContentProducer.getClassName(patternData_p.getPatternName(), "Condition");
    }

    public static String getClassName(String patternName_p, String suffix_p) {
        return StringHelper.toUpperFirst((String)patternName_p) + suffix_p;
    }

    protected void replacePatternMatchingTemplates(PatternHandler.PatternData patternData_p, List<ParameterRelation> parameters_p) {
        Couple<StringBuilder, StringBuilder> resultingTemplates = this._contributor.createPatternMatchingTemplates(patternData_p, parameters_p);
        String patternShortId = patternData_p.getPattern().getShortId();
        String pluginId = patternData_p.getPluginId();
        FileHelper.writeFile((String)TemplateHelper.getTemplateRelativePath(patternShortId, pluginId, "generatePreMatching", null), (boolean)true, (String)((StringBuilder)resultingTemplates.getKey()).toString());
        FileHelper.writeFile((String)TemplateHelper.getTemplateRelativePath(patternShortId, pluginId, "generatePostMatching", null), (boolean)true, (String)((StringBuilder)resultingTemplates.getValue()).toString());
    }

    protected void removeOldConditionStructures(PatternHandler.PatternData patternData_p) {
        String postMatchingRelativePath;
        String pluginId;
        String patternShortId;
        String preMatchingRelativePath;
        String conditionClassRelativePath = GeneratedContentProducer.getConditionFileRelativePath(patternData_p);
        if (FileHelper.exists((String)conditionClassRelativePath)) {
            FileHelper.deleteFile((String)conditionClassRelativePath);
        }
        if (FileHelper.exists((String)(preMatchingRelativePath = TemplateHelper.getTemplateRelativePath(patternShortId = patternData_p.getPattern().getShortId(), pluginId = patternData_p.getPluginId(), "generatePreMatching", null)))) {
            FileHelper.deleteFile((String)preMatchingRelativePath);
        }
        if (FileHelper.exists((String)(postMatchingRelativePath = TemplateHelper.getTemplateRelativePath(patternShortId, pluginId, "generatePostMatching", null)))) {
            FileHelper.deleteFile((String)postMatchingRelativePath);
        }
        this.replacePatternMatchingTemplates(patternData_p, new ArrayList<ParameterRelation>(0));
    }
}

