/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ecore;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egf.common.descriptor.GenericDescriptor;
import org.eclipse.egf.common.descriptor.IDescriptor;
import org.eclipse.egf.common.descriptor.pattern.helper.IPatternDescriptorHandler;
import org.eclipse.egf.common.descriptor.pattern.helper.PatternDescriptorStrategy;
import org.eclipse.egf.common.helper.FileHelper;
import org.eclipse.egf.common.helper.PatternHelper;
import org.eclipse.egf.common.helper.ProjectHelper;
import org.eclipse.egf.common.misc.PlatformLocationType;
import org.eclipse.egf.common.ui.helper.MessageFormatHelper;
import org.eclipse.egf.core.ui.EgfUiActivator;
import org.eclipse.egf.fc.generator.java.helper.FileNameHelper;
import org.eclipse.egf.model.ModelPackage;
import org.eclipse.egf.model.PatternModel;
import org.eclipse.egf.model.edit.helper.FactoryComponentHelper;
import org.eclipse.egf.pattern.Pattern;
import org.eclipse.egf.pattern.PatternPackage;
import org.eclipse.egf.pattern.ecore.AbstractPatternGenerator;
import org.eclipse.egf.pattern.ecore.AnnotationHandler;
import org.eclipse.egf.pattern.ecore.Messages;
import org.eclipse.egf.pattern.production.GeneratedContentHelper;
import org.eclipse.egf.pattern.production.GeneratedContentProducer;
import org.eclipse.egf.pattern.production.template.TemplateHelper;
import org.eclipse.egf.pattern.relations.CallParameter;
import org.eclipse.egf.pattern.relations.ParameterRelation;
import org.eclipse.egf.pde.EgfPdeActivator;
import org.eclipse.egf.pde.emf.plugin.command.EmfExtensionFactory;
import org.eclipse.egf.pde.pattern.plugin.command.PatternConditionExtensionFactory;
import org.eclipse.egf.pde.pattern.plugin.command.PatternTemplateExtensionFactory;
import org.eclipse.egf.pde.pattern.reader.PlatformPatternExtensionReader;
import org.eclipse.egf.pde.pattern.reader.WorkspacePatternExtensionReader;
import org.eclipse.egf.pde.plugin.command.IPluginChangesCommand;
import org.eclipse.egf.pde.plugin.command.IPluginChangesCommandRunner;
import org.eclipse.egf.pde.plugin.manifest.command.ManifestChangeCommandFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jdt.core.IJavaProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternHandler {
    private static final Logger __logger = Logger.getLogger((String)PatternHandler.class.getPackage().getName());
    private PatternData _patternData;
    private boolean _editable;

    public PatternHandler() {
        this(true);
    }

    public PatternHandler(boolean editable_p) {
        this._editable = editable_p;
    }

    public PatternData getPatternData() {
        return this._patternData;
    }

    public boolean isEditable() {
        return this._editable;
    }

    public void setFileRelativePath(String fileRelativePath_p) throws Exception {
        if (fileRelativePath_p == null) {
            throw new IllegalArgumentException("Null file relative path !");
        }
        if (this._patternData == null) {
            this._patternData = new PatternData();
        }
        this._patternData._fileRelativePath = fileRelativePath_p;
    }

    public PatternData load(String fileRelativePath_p) throws Exception {
        Pattern pattern;
        this.setFileRelativePath(fileRelativePath_p);
        this._patternData._fcId = new Path(this._patternData._fileRelativePath).segment(0);
        this._patternData._javaProject = ProjectHelper.getJavaProject((String)this._patternData.getPluginId());
        URI fileFullUri = FileHelper.getFileFullUri((String)this._patternData.getRealRelativePath());
        if (fileFullUri == null) {
            throw new IllegalArgumentException("File relative path " + this._patternData._fileRelativePath + " could not be converted to a full URI");
        }
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.getResource(fileFullUri, true);
        EPackage containingPackage = (EPackage)resource.getContents().get(0);
        this._patternData._pattern = pattern = (Pattern)containingPackage.getEClassifiers().get(0);
        this._patternData._patternName = pattern.getName();
        this._patternData._patternLogicalName = pattern.getLogicalName();
        this._patternData._generateOperation = this.getGenerateOperation(pattern);
        EList superTypes = pattern.getESuperTypes();
        this._patternData._patternDependenciesIds = new HashSet<String>(0);
        this._patternData._parentPattern = null;
        for (EClass superType : superTypes) {
            if (!(superType instanceof Pattern)) continue;
            this._patternData._parentPattern = (Pattern)superType;
            String patternId = (String)superType.eGet((EStructuralFeature)PatternPackage.Literals.PATTERN__ID, true);
            this._patternData._patternDependenciesIds.add(patternId);
        }
        ProductionOptionsHandler optionsHandler = this._patternData.getProductionOptionsHandler();
        optionsHandler._compileTemplate = true;
        optionsHandler._bufferModification = true;
        optionsHandler._patternTemplatePath = "";
        optionsHandler._enabled = false;
        this.readProductionContext(pattern, this._patternData);
        this.recomputeAllParameters();
        this.recomputeCallParameters();
        return this._patternData;
    }

    public PatternData save(PatternModel patternModel_p, String physicalFileRelativePath_p, String logicalFileRelativePath_p) throws Exception {
        if (this._patternData == null) {
            throw new IllegalStateException("No pattern to process.");
        }
        if (!this._editable) {
            throw new IllegalStateException("Pattern is in read-only mode !");
        }
        Pattern pattern = this._patternData.getPattern();
        AnnotationHandler annotationHandler = new AnnotationHandler();
        AbstractPatternGenerator.computeOperationsAnnotations(pattern, this._patternData.getFactoryComponentId(), annotationHandler);
        this.handleSaveProductionOptions(pattern, annotationHandler);
        boolean fileSaved = AbstractPatternGenerator.writePatternModelToFile(pattern, physicalFileRelativePath_p);
        if (!fileSaved) {
            throw new IllegalStateException("Pattern file can not be modified !");
        }
        PatternData patternData = this.reloadPatternAndUpdateModel(patternModel_p, logicalFileRelativePath_p);
        this.postSave();
        return patternData;
    }

    protected void handleSaveProductionOptions(Pattern pattern_p, AnnotationHandler handler_p) {
        ProductionOptionsHandler productionOptionsHandler = this._patternData.getProductionOptionsHandler();
        if (productionOptionsHandler.isEnabled()) {
            AbstractPatternGenerator.computeProductionAnnotation(pattern_p, productionOptionsHandler, handler_p);
        } else {
            handler_p.removeProductionAnnotation(pattern_p);
        }
    }

    public PatternData save(PatternModel patternModel_p) throws Exception {
        return this.save(patternModel_p, this._patternData.getRealRelativePath(), this._patternData.getFileRelativePath());
    }

    protected void postSave() {
        this.recomputeConditionStructures();
        this.ensurePluginDependencies();
    }

    public void recomputeConditionStructures() {
        GeneratedContentProducer producer = new GeneratedContentProducer();
        try {
            producer.produceConditionStructures(this._patternData);
        }
        catch (Exception exception_p) {
            StringBuilder loggerMessage = new StringBuilder("PatternHandler.recomputeConditionStructures(..) _ ");
            __logger.warn((Object)loggerMessage.toString(), (Throwable)exception_p);
        }
    }

    protected void ensurePluginDependencies() {
        HashSet<String> pluginIDs = new HashSet<String>(0);
        GenericDescriptor rootDescriptor = new GenericDescriptor();
        PatternDescriptorStrategy.retainRootOnly((GenericDescriptor)rootDescriptor, (IDescriptor)new WorkspacePatternExtensionReader().getPatternLibraries());
        PatternDescriptorStrategy.retainRootOnly((GenericDescriptor)rootDescriptor, (IDescriptor)new PlatformPatternExtensionReader().getPatternLibraries());
        final IDescriptor[] searchedDescriptor = new IDescriptor[1];
        final String[] searchedFullId = new String[1];
        PatternDescriptorStrategy strategy = new PatternDescriptorStrategy(){

            protected boolean stopSearch(IDescriptor parentDescriptor_p) {
                return searchedDescriptor[0] != null;
            }
        };
        IPatternDescriptorHandler handler = new IPatternDescriptorHandler(){

            public void handleDescriptor(IDescriptor descriptor_p) {
            }

            public void handleLibraryDescriptor(IDescriptor descriptor_p, String parentLibraryId_p) {
                if (parentLibraryId_p.equals(searchedFullId[0])) {
                    searchedDescriptor[0] = descriptor_p;
                }
            }

            public void handlePatternDescriptor(IDescriptor descriptor_p, String patternFullId_p) {
            }
        };
        for (String patternId : this._patternData.getPatternDependenciesIds()) {
            String pluginId;
            String rootLibraryId;
            searchedFullId[0] = rootLibraryId = PatternHelper.getRootLibraryId((String)patternId);
            searchedDescriptor[0] = null;
            strategy.iterateThroughPatternExtensionDescriptor(handler, (IDescriptor)rootDescriptor);
            IDescriptor returnedDescriptor = searchedDescriptor[0];
            if (returnedDescriptor == null || (pluginId = (String)returnedDescriptor.getValue("pluginId")) == null || pluginId.equals(this._patternData.getPluginId())) continue;
            pluginIDs.add(pluginId);
        }
        IPluginChangesCommand commandsOnManifest = ManifestChangeCommandFactory.setRequiredPlugins((String[])pluginIDs.toArray(new String[pluginIDs.size()]), (boolean)false);
        EgfPdeActivator.getDefault().getPluginChangesCommandRunner().performChangesOnManifest(this._patternData.getPluginId(), Collections.singletonList(commandsOnManifest));
    }

    protected PatternData reloadPatternAndUpdateModel(PatternModel patternModel_p, String fileRelativePath_p) throws Exception {
        PatternData result = this.load(fileRelativePath_p);
        if (this._editable) {
            this.updatePatternModel(patternModel_p, result);
        }
        return result;
    }

    protected void updatePatternModel(PatternModel patternModel_p, PatternData patternData_p) {
        if (patternData_p == null || patternModel_p == null) {
            return;
        }
        patternModel_p.setPath(patternData_p.getFileRelativePath());
        AdapterFactoryEditingDomain editingDomain = EgfUiActivator.getDefault().getEditingDomain();
        editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)editingDomain, (Object)patternModel_p, (Object)ModelPackage.Literals.NAMED_MODEL_ELEMENT_WITH_ID__NAME, (Object)patternData_p.getPatternLogicalName()));
    }

    public PatternData createPattern(final String fcId_p, final PatternModel patternModel_p) throws Exception {
        if (patternModel_p == null || fcId_p == null || !this._editable) {
            return null;
        }
        if (this._patternData == null) {
            this._patternData = new PatternData();
        }
        final String name = patternModel_p.getName();
        final String[] id = new String[1];
        new AbstractPatternGenerator(){

            protected void fillPattern(Pattern newPattern_p, AnnotationHandler handler_p, EOperation generate_p) {
                newPattern_p.setName(GeneratedContentHelper.getPatternClassName(newPattern_p));
                newPattern_p.setLogicalName(name);
                newPattern_p.setDescription(MessageFormatHelper.formatMessage((String)Messages.PatternHandler_AutoGeneratedDescriptionText, (Object[])new Object[]{name}));
            }

            public String getPatternContainingPluginId() {
                return FactoryComponentHelper.getPluginId((String)fcId_p, (PlatformLocationType)PlatformLocationType.WORKSPACE_ONLY);
            }

            public String getPatternFullId() {
                id[0] = patternModel_p.getId();
                return id[0];
            }
        }.generateEcoreFile();
        String fileRelativePath = AbstractPatternGenerator.getPatternModelRelativePath(fcId_p, (String)PatternHelper.deresolveId((String)id[0]).getValue());
        return this.reloadPatternAndUpdateModel(patternModel_p, fileRelativePath);
    }

    public void delete() {
        this.cleanGeneratedStructures();
        String pluginId = this._patternData.getPluginId();
        FileHelper.deleteFolder((String)((String)TemplateHelper.getPatternTemplatesFolderRelativePaths(this._patternData.getPattern().getShortId(), pluginId).getKey()));
        IPluginChangesCommandRunner runner = EgfPdeActivator.getDefault().getPluginChangesCommandRunner();
        runner.performChangesOnPlugin(pluginId, Collections.singletonList(PatternConditionExtensionFactory.unsetPatternConditionExtension((String)this._patternData.getPattern().getId())));
        String conditionClassRelativePath = GeneratedContentProducer.getConditionFileRelativePath(this._patternData);
        FileHelper.deleteFile((String)conditionClassRelativePath);
        FileHelper.deleteFile((String)this._patternData.getRealRelativePath());
        this._patternData = null;
    }

    public void cleanGeneratedStructures() {
        String pluginId = this._patternData.getPluginId();
        String patternName = this._patternData.getPatternName();
        IPluginChangesCommandRunner pluginChangesCommandRunner = EgfPdeActivator.getDefault().getPluginChangesCommandRunner();
        String genModelRelativePath = FileNameHelper.getGenModelPath((IPath)new Path(this._patternData.getRealRelativePath()));
        FileHelper.deleteFile((String)genModelRelativePath);
        String rootPackageRelativePath = GeneratedContentHelper.getEMFGeneratedRootFolderRelativePath(this._patternData);
        FileHelper.deleteFolder((String)rootPackageRelativePath);
        List<String> packageNames = GeneratedContentHelper.getEMFGeneratedPackagesNames(this._patternData);
        List<IPluginChangesCommand> suppressRuntimePackagesCommand = Collections.singletonList(ManifestChangeCommandFactory.unsetExportedPackages((String[])packageNames.toArray(new String[packageNames.size()])));
        pluginChangesCommandRunner.performChangesOnManifest(pluginId, suppressRuntimePackagesCommand);
        List<IPluginChangesCommand> suppressGeneratedPackageCommand = Collections.singletonList(EmfExtensionFactory.unsetEmfGeneratedPackageExtension((String)GeneratedContentHelper.getPatternPackageNsURI(this._patternData.getPattern())));
        pluginChangesCommandRunner.performChangesOnPlugin(pluginId, suppressGeneratedPackageCommand);
        String generatedTemplateFilePath = TemplateHelper.getPatternTemplatePath(this._patternData);
        FileHelper.deleteFile((String)generatedTemplateFilePath);
        FileHelper.deleteFolder((String)((String)TemplateHelper.getPatternTemplatesFolderRelativePaths(this._patternData.getPattern().getShortId(), pluginId).getValue()));
        String generatedPatternClassRelativePath = GeneratedContentHelper.getGeneratedPatternClassRelativePath(this._patternData);
        if (generatedPatternClassRelativePath != null) {
            FileHelper.deleteFile((String)generatedPatternClassRelativePath);
        }
        pluginChangesCommandRunner.performChangesOnPlugin(pluginId, Collections.singletonList(PatternTemplateExtensionFactory.unsetPatternTemplateExtension((String)this._patternData.getPattern().getShortId())));
        String generatedParametersHandlerClassRelativePath = GeneratedContentProducer.getGeneratedClassRelativePath(pluginId, "/generated", "org.eclipse.egf.pattern", GeneratedContentProducer.getClassName(patternName, "ParametersHandler"));
        FileHelper.deleteFile((String)generatedParametersHandlerClassRelativePath);
        pluginChangesCommandRunner.performChangesOnManifest(pluginId, Collections.singletonList(ManifestChangeCommandFactory.unsetExportedPackages((String[])new String[]{"org.eclipse.egf.pattern"})));
    }

    protected boolean readProductionContext(Pattern pattern_p, PatternData patternData_p) {
        boolean result = false;
        if (pattern_p == null) {
            return result;
        }
        EAnnotation productionAnnotation = pattern_p.getEAnnotation("http://www.eclipse.org/egf/1.0.0/Pattern/production");
        boolean bl = result = productionAnnotation != null;
        if (result) {
            String path;
            String modifyBuffer;
            ProductionOptionsHandler optionsHandler = patternData_p.getProductionOptionsHandler();
            optionsHandler._enabled = pattern_p == patternData_p.getPattern();
            EMap details = productionAnnotation.getDetails();
            String compileString = (String)details.get((Object)"Compilation");
            if (compileString != null) {
                optionsHandler._compileTemplate = Boolean.valueOf(compileString);
            }
            if ((modifyBuffer = (String)details.get((Object)"BufferModification")) != null) {
                optionsHandler._bufferModification = Boolean.valueOf(modifyBuffer);
            }
            if ((path = (String)details.get((Object)"Path")) != null) {
                optionsHandler._patternTemplatePath = path;
            }
        } else {
            EList parentTypes = pattern_p.getESuperTypes();
            if (!parentTypes.isEmpty()) {
                Iterator parents = parentTypes.iterator();
                while (parents.hasNext() && !result) {
                    EClass parent = (EClass)parents.next();
                    if (!(parent instanceof Pattern)) continue;
                    result = this.readProductionContext((Pattern)parent, patternData_p);
                }
            }
        }
        return result;
    }

    protected List<ParameterRelation> getAllParameters(Pattern pattern_p) {
        List<ParameterRelation> result = null;
        if (pattern_p == null) {
            result = Collections.emptyList();
        }
        result = new ArrayList(pattern_p.getParameters().size());
        EList parentTypes = pattern_p.getESuperTypes();
        if (!parentTypes.isEmpty()) {
            for (EClass parent : parentTypes) {
                if (!(parent instanceof Pattern)) continue;
                List<ParameterRelation> parentResult = this.getAllParameters((Pattern)parent);
                result.addAll(parentResult);
            }
        }
        result.addAll((Collection<ParameterRelation>)pattern_p.getParameters());
        return result;
    }

    protected List<CallParameter> getCallParameters(Pattern pattern_p) {
        List<CallParameter> result = null;
        if (pattern_p == null) {
            result = Collections.emptyList();
        }
        EList callParameters = pattern_p.getCallParameters();
        result = new ArrayList(callParameters.size());
        result.addAll((Collection<CallParameter>)callParameters);
        return result;
    }

    public List<ParameterRelation> recomputeAllParameters() {
        this._patternData._parameters = this.getAllParameters(this._patternData.getPattern());
        return this._patternData._parameters;
    }

    public List<CallParameter> recomputeCallParameters() {
        this._patternData._callParameters = this.getCallParameters(this._patternData.getPattern());
        return this._patternData._callParameters;
    }

    protected EOperation getGenerateOperation(Pattern pattern_p) {
        EOperation result = null;
        if (pattern_p == null) {
            return result;
        }
        EList operationsList = pattern_p.getEOperations();
        Iterator operations = operationsList.iterator();
        while (operations.hasNext() && result == null) {
            EOperation currentOperation = (EOperation)operations.next();
            if (!"generateBody".equals(currentOperation.getName())) continue;
            result = currentOperation;
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class PatternData {
        protected String _fileRelativePath;
        protected String _fcId;
        protected IJavaProject _javaProject;
        protected Pattern _pattern;
        protected String _patternName;
        protected String _patternLogicalName;
        protected Set<String> _patternDependenciesIds;
        protected List<ParameterRelation> _parameters;
        protected List<CallParameter> _callParameters;
        protected EOperation _generateOperation;
        protected Pattern _parentPattern;
        protected ProductionOptionsHandler _productionOptionsHandler;

        public EOperation getGenerateOperation() {
            return this._generateOperation;
        }

        public String getRealRelativePath() {
            return TemplateHelper.getPhysicalRelativePath(this._fileRelativePath, this.getPluginId());
        }

        public String getFileRelativePath() {
            return this._fileRelativePath;
        }

        public String getPluginId() {
            String result = FactoryComponentHelper.getPluginId((String)this._fcId, (PlatformLocationType)PlatformLocationType.WORKSPACE_THEN_TARGET_PLATFORM);
            if (result == null) {
                result = this._fcId;
            }
            return result;
        }

        public String getFactoryComponentId() {
            return this._fcId;
        }

        public IJavaProject getJavaProject() {
            return this._javaProject;
        }

        public Pattern getPattern() {
            return this._pattern;
        }

        public String getPatternName() {
            return this._patternName;
        }

        public String getPatternLogicalName() {
            return this._patternLogicalName;
        }

        public void setPatternLogicalName(String patternLogicalName_p) {
            this._patternLogicalName = patternLogicalName_p;
        }

        public Set<String> getPatternDependenciesIds() {
            return this._patternDependenciesIds;
        }

        public ProductionOptionsHandler getProductionOptionsHandler() {
            if (this._productionOptionsHandler == null) {
                this._productionOptionsHandler = new ProductionOptionsHandler();
            }
            return this._productionOptionsHandler;
        }

        public List<ParameterRelation> getAllParameters() {
            return this._parameters;
        }

        public List<CallParameter> getCallParameters() {
            return this._callParameters;
        }

        public Pattern getParentPattern() {
            return this._parentPattern;
        }

        public void cleanGeneratedStructures() {
            PatternHandler.this.cleanGeneratedStructures();
        }
    }

    public class ProductionOptionsHandler {
        protected String _patternTemplatePath;
        protected boolean _compileTemplate;
        protected boolean _bufferModification;
        protected boolean _enabled;

        public String getPatternTemplatePath() {
            return this._patternTemplatePath;
        }

        public void setPatternTemplatePath(String patternTemplatePath_p) {
            this._patternTemplatePath = patternTemplatePath_p;
        }

        public boolean shouldCompileTemplate() {
            return this._compileTemplate;
        }

        public void setCompileTemplateTo(boolean compile_p) {
            this._compileTemplate = compile_p;
        }

        public boolean shouldModifyBuffer() {
            return this._bufferModification;
        }

        public void setModifyBufferTo(boolean modifyBuffer_p) {
            this._bufferModification = modifyBuffer_p;
        }

        public boolean isEnabled() {
            return this._enabled;
        }

        public void setEnabled(boolean enabled_p) {
            this._enabled = enabled_p;
        }
    }
}

