/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.batch.application;

import java.net.URL;
import java.text.MessageFormat;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egf.batch.application.FactoryComponentRunnerWorkbenchWindowAdvisor;
import org.eclipse.egf.batch.application.Messages;
import org.eclipse.egf.core.CoreActivator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.internal.ide.model.WorkbenchAdapterBuilder;
import org.osgi.framework.Bundle;

public class FactoryComponentRunnerWorkbenchAdvisor
extends WorkbenchAdvisor {
    private static final Logger __logger = Logger.getLogger((String)FactoryComponentRunnerWorkbenchAdvisor.class.getPackage().getName());
    private String _factoryComponentId;

    public WorkbenchWindowAdvisor createWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        return new FactoryComponentRunnerWorkbenchWindowAdvisor(configurer);
    }

    public String getInitialWindowPerspectiveId() {
        return "org.eclipse.egf.core.ui.workbench.perspective";
    }

    public void initialize(IWorkbenchConfigurer configurer_p) {
        configurer_p.setSaveAndRestore(true);
        WorkbenchAdapterBuilder.registerAdapters();
        this.declareWorkbenchImages(configurer_p);
    }

    private void declareWorkbenchImage(IWorkbenchConfigurer configurer_p, Bundle bundle_p, String symbolicName_p, String path_p, boolean shared_p) {
        URL url = bundle_p.getEntry(path_p);
        ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
        configurer_p.declareImage(symbolicName_p, desc, shared_p);
    }

    private void declareWorkbenchImages(IWorkbenchConfigurer configurer_p) {
        Bundle ideBundle = Platform.getBundle((String)"org.eclipse.ui.ide");
        this.declareWorkbenchImage(configurer_p, ideBundle, "IMG_OBJ_PROJECT", "icons/full/obj16/prj_obj.gif", true);
        this.declareWorkbenchImage(configurer_p, ideBundle, "IMG_OBJ_PROJECT_CLOSED", "icons/full/obj16/cprj_obj.gif", true);
        Bundle uiBundle = Platform.getBundle((String)"org.eclipse.ui");
        this.declareWorkbenchImage(configurer_p, uiBundle, "IMG_OBJ_FILE", "icons/full/obj16/file_obj.gif", true);
        this.declareWorkbenchImage(configurer_p, uiBundle, "IMG_OBJ_FOLDER", "icons/full/obj16/fldr_obj.gif", true);
    }

    public void postStartup() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        try {
            root.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException exception_p) {
            StringBuilder loggerMessage = new StringBuilder("FactoryComponentRunnerWorkbenchAdvisor.postStartup(..) _ ");
            __logger.warn((Object)loggerMessage.toString(), (Throwable)exception_p);
        }
        String jobMessage = MessageFormat.format(Messages.FactoryComponentRunnerWorkbenchAdvisor_Job_Title, this._factoryComponentId);
        WorkspaceJob executeFactoryComponentJob = new WorkspaceJob(jobMessage){

            public IStatus runInWorkspace(IProgressMonitor monitor_p) throws CoreException {
                CoreActivator.getDefault().generateFactoryComponent(FactoryComponentRunnerWorkbenchAdvisor.this._factoryComponentId, monitor_p, false);
                final IWorkbench workbench = PlatformUI.getWorkbench();
                workbench.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        workbench.close();
                    }
                });
                return Status.OK_STATUS;
            }
        };
        executeFactoryComponentJob.setRule((ISchedulingRule)root);
        executeFactoryComponentJob.schedule();
    }

    public void setExecutedFactoryComponentId(String fcId_p) {
        this._factoryComponentId = fcId_p;
    }
}

