/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pde.reader;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.zip.ZipFile;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.egf.common.descriptor.IDescriptor;
import org.eclipse.egf.core.reader.descriptor.AbstractDescriptor;
import org.eclipse.egf.model.data.reader.descriptor.IContextDescriptor;
import org.eclipse.egf.model.data.reader.descriptor.IContractDescriptor;
import org.eclipse.egf.model.data.reader.descriptor.IContractElementReferenceDescriptor;
import org.eclipse.egf.model.data.reader.descriptor.IFactoryComponentDescriptor;
import org.eclipse.egf.model.data.reader.descriptor.IFactoryComponentInvocationDescriptor;
import org.eclipse.egf.model.data.reader.descriptor.IFactoryComponentReader;
import org.eclipse.egf.model.data.reader.descriptor.IProductionPlanDescriptor;
import org.eclipse.egf.model.data.reader.descriptor.ITaskFactoryDescriptor;
import org.eclipse.egf.pde.EgfPdeActivator;
import org.eclipse.egf.pde.internal.reader.CreateContextDescriptorOperation;
import org.eclipse.egf.pde.internal.reader.CreateContractDescriptorOperation;
import org.eclipse.egf.pde.internal.reader.CreateContractElementReferenceOperation;
import org.eclipse.egf.pde.internal.reader.CreateFactoryComponentDescriptorOperation;
import org.eclipse.egf.pde.internal.reader.CreateFactoryComponentInvocationDescriptorOperation;
import org.eclipse.egf.pde.internal.reader.CreateMappingDescriptorOperation;
import org.eclipse.egf.pde.internal.reader.CreateProductionPlanDescriptorOperation;
import org.eclipse.egf.pde.internal.reader.CreateTaskFactoryDescriptorOperation;
import org.eclipse.egf.pde.reader.CreateDescriptorOperation;
import org.eclipse.egf.pde.reader.WorkspaceFactoryComponentReader;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.plugin.ExternalPluginModel;
import org.eclipse.pde.internal.ui.editor.JarEntryFile;

public class PdeTargetPlatformReader
extends WorkspaceFactoryComponentReader {
    private static final Logger __logger = Logger.getLogger((String)PdeTargetPlatformReader.class.getPackage().getName());
    private static PdeTargetPlatformReader __default;

    public static PdeTargetPlatformReader getDefault() {
        if (__default == null) {
            __default = new PdeTargetPlatformReader();
        }
        return __default;
    }

    private PdeTargetPlatformReader() {
    }

    protected IDescriptor readDescriptor(CreateDescriptorOperation createDescriptorOperation_p) {
        IDescriptor result = null;
        if (createDescriptorOperation_p != null) {
            try {
                IPluginModel tempPluginModel;
                IPluginModelBase pluginModelBase = createDescriptorOperation_p.getPluginModelBase();
                if (pluginModelBase.getPluginBase().getExtensions().length > 0 && (tempPluginModel = this.createTemporaryPluginModel(pluginModelBase)) != null) {
                    createDescriptorOperation_p.modifyModel((IBaseModel)tempPluginModel, (IProgressMonitor)new NullProgressMonitor());
                    tempPluginModel.dispose();
                    tempPluginModel = null;
                }
            }
            catch (CoreException exception_p) {
                StringBuilder loggerMessage = new StringBuilder("PdeTargetPlatformReader.readDescriptor(..) _ ");
                __logger.error((Object)loggerMessage.toString(), (Throwable)exception_p);
            }
            if ((result = createDescriptorOperation_p.getDescriptor()) != null) {
                ((AbstractDescriptor)result).setFactoryComponentReader((IFactoryComponentReader)this);
            }
        }
        return result;
    }

    protected IPluginModel createTemporaryPluginModel(IPluginModelBase pluginModelBase_p) {
        StringBuilder loggerMessage;
        File location = new File(pluginModelBase_p.getInstallLocation());
        InputStream pluginInputStream = null;
        ExternalPluginModel extModel = null;
        if (location.isFile()) {
            try {
                ZipFile zipFile = new ZipFile(location);
                if (zipFile.getEntry("plugin.xml") != null) {
                    JarEntryFile jarEntryFile = new JarEntryFile(zipFile, "plugin.xml");
                    pluginInputStream = jarEntryFile.getContents();
                }
            }
            catch (Exception exception_p) {
                loggerMessage = new StringBuilder("PdeTargetPlatformReader.createTemporaryPluginModel(..) _ ");
                __logger.warn((Object)loggerMessage.toString(), (Throwable)exception_p);
            }
        } else {
            File pluginFile = new File(location, "plugin.xml");
            if (pluginFile.exists()) {
                try {
                    pluginInputStream = new FileInputStream(pluginFile);
                }
                catch (FileNotFoundException exception_p) {
                    StringBuilder loggerMessage2 = new StringBuilder("PdeTargetPlatformReader.createTemporaryPluginModel(..) _ ");
                    __logger.warn((Object)loggerMessage2.toString(), (Throwable)exception_p);
                }
            }
        }
        if (pluginInputStream != null) {
            extModel = new ExternalPluginModel();
            extModel.setBundleDescription(pluginModelBase_p.getBundleDescription());
            extModel.setInstallLocation(pluginModelBase_p.getInstallLocation());
            try {
                extModel.load(pluginInputStream, false);
                pluginInputStream.close();
            }
            catch (Exception exception_p) {
                loggerMessage = new StringBuilder("PdeTargetPlatformReader.createTemporaryPluginModel(..) _ ");
                __logger.warn((Object)loggerMessage.toString(), (Throwable)exception_p);
            }
        }
        return extModel;
    }

    public IFactoryComponentDescriptor readFactoryComponent(String fcId_p) {
        return this.readFactoryComponent(EgfPdeActivator.getDefault().getPluginModelForFactoryComponent(fcId_p));
    }

    public IFactoryComponentDescriptor readFactoryComponent(IPluginModelBase pluginModel_p) {
        IFactoryComponentDescriptor result = null;
        if (pluginModel_p == null) {
            return result;
        }
        CreateFactoryComponentDescriptorOperation descriptorOperation = new CreateFactoryComponentDescriptorOperation(null);
        descriptorOperation.setPluginModelBase(pluginModel_p);
        result = (IFactoryComponentDescriptor)this.readDescriptor(descriptorOperation);
        return result;
    }

    public IFactoryComponentInvocationDescriptor readFactoryComponentInvocation(String factoryComponentInvocation_p, String fcId_p) {
        CreateFactoryComponentInvocationDescriptorOperation descriptorOperation = new CreateFactoryComponentInvocationDescriptorOperation(null, factoryComponentInvocation_p);
        descriptorOperation.setPluginModelBase(EgfPdeActivator.getDefault().getPluginModelForFactoryComponent(fcId_p));
        IFactoryComponentInvocationDescriptor result = (IFactoryComponentInvocationDescriptor)this.readDescriptor(descriptorOperation);
        return result;
    }

    public IContextDescriptor readContext(String contextId_p, String fcId_p) {
        CreateContextDescriptorOperation descriptorOperation = new CreateContextDescriptorOperation(null, contextId_p);
        descriptorOperation.setPluginModelBase(EgfPdeActivator.getDefault().getPluginModelForFactoryComponent(fcId_p));
        IContextDescriptor result = (IContextDescriptor)this.readDescriptor(descriptorOperation);
        return result;
    }

    public IContractDescriptor readContract(String contractId_p, String fcId_p) {
        CreateContractDescriptorOperation descriptorOperation = new CreateContractDescriptorOperation(null, contractId_p);
        descriptorOperation.setPluginModelBase(EgfPdeActivator.getDefault().getPluginModelForFactoryComponent(fcId_p));
        IContractDescriptor result = (IContractDescriptor)this.readDescriptor(descriptorOperation);
        return result;
    }

    public IContractElementReferenceDescriptor readContractElementReference(String contractReferenceId_p, String fcId_p) {
        CreateContractElementReferenceOperation descriptorOperation = new CreateContractElementReferenceOperation(null, contractReferenceId_p);
        descriptorOperation.setPluginModelBase(EgfPdeActivator.getDefault().getPluginModelForFactoryComponent(fcId_p));
        IContractElementReferenceDescriptor result = (IContractElementReferenceDescriptor)this.readDescriptor(descriptorOperation);
        return result;
    }

    public IDescriptor readMappings(String fcId_p) {
        CreateMappingDescriptorOperation descriptorOperation = new CreateMappingDescriptorOperation(null);
        descriptorOperation.setPluginModelBase(EgfPdeActivator.getDefault().getPluginModelForFactoryComponent(fcId_p));
        IDescriptor result = this.readDescriptor(descriptorOperation);
        return result;
    }

    public IDescriptor readPatternLibraries(String fcId_p) {
        return null;
    }

    public IProductionPlanDescriptor readProductionPlan(String productionPlanId_p, String fcId_p) {
        CreateProductionPlanDescriptorOperation descriptorOperation = new CreateProductionPlanDescriptorOperation(null, productionPlanId_p);
        descriptorOperation.setPluginModelBase(EgfPdeActivator.getDefault().getPluginModelForFactoryComponent(fcId_p));
        IProductionPlanDescriptor result = (IProductionPlanDescriptor)this.readDescriptor(descriptorOperation);
        return result;
    }

    public ITaskFactoryDescriptor readTaskFactory(String taskFactoryId_p, String fcId_p) {
        CreateTaskFactoryDescriptorOperation descriptorOperation = new CreateTaskFactoryDescriptorOperation(null, taskFactoryId_p);
        descriptorOperation.setPluginModelBase(EgfPdeActivator.getDefault().getPluginModelForFactoryComponent(fcId_p));
        ITaskFactoryDescriptor result = (ITaskFactoryDescriptor)this.readDescriptor(descriptorOperation);
        return result;
    }

    public static /* bridge */ /* synthetic */ WorkspaceFactoryComponentReader getDefault() {
        return PdeTargetPlatformReader.getDefault();
    }
}

