/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pde.internal.reader;

import org.eclipse.core.resources.IFile;
import org.eclipse.egf.core.extensionpoint.IContextConstants;
import org.eclipse.egf.core.reader.descriptor.AbstractDescriptor;
import org.eclipse.egf.core.reader.descriptor.ContextDescriptor;
import org.eclipse.egf.core.reader.descriptor.ContextElementDescriptor;
import org.eclipse.egf.model.ModelFactory;
import org.eclipse.egf.model.Type;
import org.eclipse.egf.model.data.reader.descriptor.IContextElementDescriptor;
import org.eclipse.egf.pde.reader.CreateDescriptorOperation;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;

public class CreateContextDescriptorOperation
extends CreateDescriptorOperation {
    public CreateContextDescriptorOperation(IFile modelFile_p, String readExtensionId_p) {
        super(modelFile_p, readExtensionId_p);
    }

    protected AbstractDescriptor createDescriptor(IPluginModelBase model_p) {
        ContextDescriptor descriptor = null;
        IPluginElement pluginElement = this.getExtensionWithId(model_p, IContextConstants.FULLY_QUALIFIED_EXTENSION_POINT_ID, this.getReadExtensionId());
        if (pluginElement != null) {
            IPluginElement[] children;
            descriptor = new ContextDescriptor();
            String value = this.getPluginAttributeValue(pluginElement, "id");
            descriptor.setId(value);
            IPluginElement[] iPluginElementArray = children = this.getChildren(pluginElement, "contextElement");
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IPluginElement child = iPluginElementArray[n2];
                ContextElementDescriptor contextElementDescriptor = this.readContextElementDescriptor(child);
                if (contextElementDescriptor != null) {
                    descriptor.addContextElementDescriptor((IContextElementDescriptor)contextElementDescriptor);
                }
                ++n2;
            }
        }
        return descriptor;
    }

    private ContextElementDescriptor readContextElementDescriptor(IPluginElement child_p) {
        ContextElementDescriptor descriptor = new ContextElementDescriptor();
        String value = this.getPluginAttributeValue(child_p, "id");
        descriptor.setId(value);
        IPluginObject[] children = child_p.getChildren();
        int i = 0;
        while (i < children.length) {
            IPluginObject object = children[i];
            if (object instanceof IPluginElement) {
                IPluginElement element = (IPluginElement)object;
                if ("contractElementRef".equals(element.getName())) {
                    value = this.getPluginAttributeValue(element, "contractElementReferenceId");
                    descriptor.setContractReferenceId(value);
                } else if ("key".equals(element.getName())) {
                    value = this.getPluginAttributeValue(element, "name");
                    descriptor.setKey(value);
                } else if ("contextValue".equals(element.getName())) {
                    value = this.getPluginAttributeValue(element, "value");
                    descriptor.setReadableValue(value);
                    value = this.getPluginAttributeValue(element, "class");
                    if (value != null) {
                        Type type = ModelFactory.eINSTANCE.createType();
                        type.setTypeHolderClassName(value);
                        descriptor.setType(type);
                    }
                }
            }
            ++i;
        }
        return descriptor;
    }
}

