/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.common.helper;

import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class ExtensionPointHelper {
    private static final Logger _logger = Logger.getLogger((String)ExtensionPointHelper.class.getPackage().getName());
    public static final String ATT_CLASS = "class";
    public static final String ATT_NAME = "name";
    public static final String ATT_ID = "id";
    public static final String ELEMENT_DESCRIPTION = "description";

    public static IConfigurationElement[] getConfigurationElements(String pluginId_p, String extensionPointId_p) {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] configElements = extensionRegistry.getConfigurationElementsFor(pluginId_p, extensionPointId_p);
        return configElements;
    }

    public static IConfigurationElement[] getConfigurationElements(String pluginId_p, String extensionPointId_p, String extensionDeclaringPluginId_p) {
        IConfigurationElement[] allElements;
        ArrayList<IConfigurationElement> resultingElements = new ArrayList<IConfigurationElement>(0);
        IConfigurationElement[] iConfigurationElementArray = allElements = ExtensionPointHelper.getConfigurationElements(pluginId_p, extensionPointId_p);
        int n = allElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            if (ExtensionPointHelper.isDeclaredBy(configurationElement, extensionDeclaringPluginId_p)) {
                resultingElements.add(configurationElement);
            }
            ++n2;
        }
        return resultingElements.toArray(new IConfigurationElement[resultingElements.size()]);
    }

    public static boolean isDeclaredBy(IConfigurationElement configurationElement_p, String pluginId_p) {
        return configurationElement_p != null && pluginId_p != null && pluginId_p.equals(configurationElement_p.getContributor().getName());
    }

    public static IConfigurationElement getConfigurationElement(String pluginId_p, String extensionId_p, String idValue_p) {
        return ExtensionPointHelper.getConfigurationElement(pluginId_p, extensionId_p, ATT_ID, idValue_p);
    }

    public static IConfigurationElement getConfigurationElement(String pluginId_p, String extensionId_p, String attName_p, String attValue_p) {
        IConfigurationElement[] configElements = ExtensionPointHelper.getConfigurationElements(pluginId_p, extensionId_p);
        IConfigurationElement result = null;
        int i = 0;
        while (i < configElements.length && result == null) {
            IConfigurationElement configElement = configElements[i];
            if (ExtensionPointHelper.hasValue(configElement, attName_p, attValue_p)) {
                result = configElement;
            }
            ++i;
        }
        return result;
    }

    public static boolean hasValue(IConfigurationElement configurationElement_p, String attName_p, String attValue_p) {
        boolean result = false;
        if (configurationElement_p == null || attName_p == null || attValue_p == null) {
            return result;
        }
        String attValue = configurationElement_p.getAttribute(attName_p);
        result = attValue_p.equals(attValue);
        return result;
    }

    public static String getId(IConfigurationElement configurationElement_p) {
        String result = null;
        if (configurationElement_p != null) {
            result = configurationElement_p.getAttribute(ATT_ID);
        }
        return result;
    }

    public static Object createExecutableExtension(String pluginId_p, String extensionPointId_p, String attributeId_p, String attributeValue_p) {
        Object object = null;
        IConfigurationElement[] configElements = ExtensionPointHelper.getConfigurationElements(pluginId_p, extensionPointId_p);
        if (configElements.length == 0) {
            StringBuffer loggerMessage = new StringBuffer("ExtensionPointHelper.createExecutableExtension(..) _ ");
            loggerMessage.append("extensionPointId:");
            loggerMessage.append(extensionPointId_p);
            loggerMessage.append(", must exist!");
            _logger.error((Object)loggerMessage.toString());
        } else {
            boolean isMatchingImperative = false;
            if (attributeId_p != null && attributeValue_p != null) {
                isMatchingImperative = true;
            }
            int i = 0;
            while (i < configElements.length && object == null) {
                String attributeValue;
                IConfigurationElement configElement = configElements[i];
                boolean isExecutableExtensionCreatable = true;
                if (isMatchingImperative && !attributeValue_p.equals(attributeValue = configElement.getAttribute(attributeId_p))) {
                    isExecutableExtensionCreatable = false;
                }
                if (isExecutableExtensionCreatable) {
                    object = ExtensionPointHelper.createInstance(configElement, ATT_CLASS);
                }
                ++i;
            }
        }
        return object;
    }

    public static Object createExecutableExtension(String pluginId_p, String extensionPointId_p, String idValue_p) {
        return ExtensionPointHelper.createExecutableExtension(pluginId_p, extensionPointId_p, ATT_ID, idValue_p);
    }

    public static Object createInstance(IConfigurationElement configurationElement_p, String attributeName_p) {
        Object typeInstance = null;
        try {
            typeInstance = configurationElement_p.createExecutableExtension(attributeName_p);
        }
        catch (CoreException exception_p) {
            StringBuffer loggerMessage = new StringBuffer("ExtensionPointHelper.createTypeInstance(..) _ ");
            loggerMessage.append("Unable to instantiate class type:");
            loggerMessage.append(configurationElement_p.getAttribute(attributeName_p));
            _logger.error((Object)loggerMessage.toString(), (Throwable)exception_p);
        }
        return typeInstance;
    }

    public static String getExtensionPointId(String hostingPluginId_p, String extensionPointId_p) {
        StringBuilder result = new StringBuilder(hostingPluginId_p);
        result.append('.').append(extensionPointId_p);
        return result.toString();
    }
}

