/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.ui.wizard.page;

import org.eclipse.egf.common.helper.PatternHelper;
import org.eclipse.egf.common.ui.helper.FieldEditorHelper;
import org.eclipse.egf.common.ui.toolkit.fields.IFieldEditor;
import org.eclipse.egf.common.ui.toolkit.fields.ValidatingStringFieldEditor;
import org.eclipse.egf.common.ui.toolkit.validators.IValidator;
import org.eclipse.egf.core.ui.internal.help.IHelpContextIds;
import org.eclipse.egf.core.ui.internal.validators.PatternElementValidator;
import org.eclipse.egf.core.ui.wizard.AbstractPatternLibraryWizard;
import org.eclipse.egf.core.ui.wizard.Messages;
import org.eclipse.egf.core.ui.wizard.page.AbstractModelElementWizardPage;
import org.eclipse.egf.model.AbstractPatternElement;
import org.eclipse.egf.model.ModelPackage;
import org.eclipse.egf.model.NamedModelElementWithId;
import org.eclipse.egf.model.PatternLibrary;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class PatternLibraryWizardPage
extends AbstractModelElementWizardPage {
    private ValidatingStringFieldEditor _libraryNameFieldEditor;

    public PatternLibraryWizardPage(String pageName_p) {
        super(pageName_p);
    }

    public PatternLibraryWizardPage(String pageName_p, String title_p, ImageDescriptor titleImage_p) {
        super(pageName_p, title_p, titleImage_p);
    }

    protected void createPageArea(Composite parent_p) {
        this.createLibraryFullId();
        this.createLibraryNameFieldEditor(parent_p);
    }

    private void createLibraryNameFieldEditor(Composite parent_p) {
        this._libraryNameFieldEditor = FieldEditorHelper.createStringFieldEditor((Composite)parent_p, (DialogPage)this, (String)Messages.PatternLibraryWizardPage_Name_Title, (String)Messages.PatternLibraryWizardPage_Name_Tooltip, null, (int)-1, (IValidator)new PatternElementValidator(this.getParent(), (AbstractPatternElement)this.getModelElement(), Messages.PatternLibraryWizardPage_Name_ErrorMessage), (boolean)this.isReadOnly());
        Text libraryName = this._libraryNameFieldEditor.getTextControl();
        this.bindTextToAttribute(libraryName, ModelPackage.Literals.NAMED_MODEL_ELEMENT_WITH_ID__NAME, this.getModelElement(), null);
        this._libraryNameFieldEditor.isValid(true);
    }

    private void createLibraryFullId() {
        PatternLibrary patternLibrary = this.getPatternLibrary();
        boolean isInCreationMode = ((AbstractPatternLibraryWizard)this.getModelElementWizard()).isInCreationMode();
        if (isInCreationMode) {
            String createdLibraryShortId = patternLibrary.getId();
            NamedModelElementWithId parent = this.getParent();
            if (parent instanceof PatternLibrary) {
                String parentId = parent.getId();
                String createLibraryFullId = PatternHelper.getFullId((String)parentId, (String)createdLibraryShortId);
                patternLibrary.setId(createLibraryFullId);
            }
        }
    }

    protected boolean getCompleteStatus() {
        IFieldEditor[] fieldEditors = new IFieldEditor[]{this._libraryNameFieldEditor};
        return this.handleFieldEditorValidation(fieldEditors);
    }

    protected String getPageTitle() {
        return Messages.PatternLibraryWizardPage_Title;
    }

    protected PatternLibrary getPatternLibrary() {
        return (PatternLibrary)this.getModelElement();
    }

    public IWizardPage getNextPage() {
        return this.getWizard().getPage("patternLibraryProductionSequenceWizardPage");
    }

    protected String getHelpContextId() {
        return IHelpContextIds.NEW_PATTERN_LIBRARY_WIZARD_PAGE;
    }
}

