/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.ui.wizard.page;

import java.lang.reflect.Constructor;
import org.apache.log4j.Logger;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.egf.common.helper.ClassLoadingHelper;
import org.eclipse.egf.common.misc.ISelectionHandler;
import org.eclipse.egf.common.ui.field.ContextElementFieldEditor;
import org.eclipse.egf.common.ui.helper.FieldEditorHelper;
import org.eclipse.egf.common.ui.toolkit.fields.IFieldEditor;
import org.eclipse.egf.common.ui.toolkit.fields.ValidatingStringFieldEditor;
import org.eclipse.egf.common.ui.toolkit.validators.AbstractValidator;
import org.eclipse.egf.common.ui.toolkit.validators.IValidator;
import org.eclipse.egf.common.ui.toolkit.validators.NotEmptyStringValidator;
import org.eclipse.egf.core.data.helper.DataHelper;
import org.eclipse.egf.core.ui.internal.databinding.JavaTypeHolder;
import org.eclipse.egf.core.ui.internal.databinding.UpdateWizardPage;
import org.eclipse.egf.core.ui.internal.databinding.ValueChangeHandler;
import org.eclipse.egf.core.ui.internal.help.IHelpContextIds;
import org.eclipse.egf.core.ui.wizard.Messages;
import org.eclipse.egf.core.ui.wizard.page.AbstractModelElementWizardPage;
import org.eclipse.egf.model.ContextElement;
import org.eclipse.egf.model.ContractElement;
import org.eclipse.egf.model.ModelPackage;
import org.eclipse.egf.model.Type;
import org.eclipse.egf.model.contract.type.ClassTypeHolder;
import org.eclipse.egf.model.contract.type.ITypeHolder;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextElementValueWizardPage
extends AbstractModelElementWizardPage {
    private static final Logger __logger = Logger.getLogger((String)ContextElementValueWizardPage.class.getPackage().getName());
    private ValidatingStringFieldEditor _contextElementTypeFieldEditor;
    protected ContextElementFieldEditor _contextElementValueFieldEditor;
    protected JavaTypeHolder _contextElementType;
    protected ITypeHolder _typeHolder;
    private SelectionDialog _providedSelectionDialog;

    public ContextElementValueWizardPage(String pageName_p) {
        super(pageName_p);
    }

    public ContextElementValueWizardPage(String pageName_p, String title_p, ImageDescriptor titleImage_p) {
        super(pageName_p, title_p, titleImage_p);
    }

    protected void createPageArea(Composite parent_p) {
        String typeHolderClassName = this.createTypeFieldEditor(parent_p);
        this.createValueTypeFieldEditor(parent_p, typeHolderClassName);
        this.handlePageLayout(parent_p);
    }

    public IWizardPage getNextPage() {
        return null;
    }

    protected void handlePageLayout(Composite parent_p) {
        FieldEditorHelper.layoutFieldEditor((Composite)parent_p, (FieldEditor)this._contextElementTypeFieldEditor, (int)3);
    }

    private String createTypeFieldEditor(Composite parent_p) {
        this._contextElementTypeFieldEditor = FieldEditorHelper.createStringFieldEditor((Composite)parent_p, (DialogPage)this, (String)Messages.ContextElementValueWizardPage_Type_Title, (String)Messages.ContextElementValueWizardPage_Type_Tooltip, null, (int)-1, (IValidator)new NotEmptyStringValidator(null), (boolean)this.isReadOnly());
        Text type = this._contextElementTypeFieldEditor.getTextControl();
        type.setEditable(false);
        ContextElement contextElement = (ContextElement)this.getModelElement();
        String typeHolderClassName = DataHelper.getContextType((ContextElement)contextElement);
        Type contextType = contextElement.getContextType();
        if (contextType == null) {
            ContractElement referencedContractElement = contextElement.getContractElementReference().getReferencedContractElement();
            contextType = referencedContractElement.getContractType();
        }
        this._contextElementType = new JavaTypeHolder(typeHolderClassName);
        this.bindTextToAttribute(type, "type", this._contextElementType, null);
        return typeHolderClassName;
    }

    private void createValueTypeFieldEditor(Composite parent_p, String typeHolderClassName_p) {
        Class<?> classTypeFilter = this._typeHolder != null ? this.getClassTypeFilter(this._typeHolder) : null;
        this._contextElementValueFieldEditor = FieldEditorHelper.createContextElementFieldEditor((Composite)parent_p, (DialogPage)this, (String)Messages.ContextElementValueWizardPage_Value_Title, (String)Messages.ContextElementValueWizardPage_OpenValueTypeDialog_Title, (ClassLoader)this.getHostingProjectClassLoader(), (Bundle)this.getHostingBundle(), classTypeFilter, (boolean)this.isReadOnly());
        AbstractValidator valueValidator = new AbstractValidator(Messages.ContextElementValueWizardPage_ErrorMessage_NotValidValue){

            public String isValid(Object value_p) {
                String errorMessage = null;
                if (ContextElementValueWizardPage.this._typeHolder != null) {
                    if (ContextElementValueWizardPage.this._typeHolder.isJava()) {
                        ((ClassTypeHolder)ContextElementValueWizardPage.this._typeHolder).setClassLoader(ContextElementValueWizardPage.this.getHostingProjectClassLoader());
                        this.setErrorMessage(Messages.ContextElementValueWizardPage_ErrorMessage_NotValidJavaValue);
                    } else {
                        this.setErrorMessage(Messages.ContextElementValueWizardPage_ErrorMessage_EmtpyValue);
                    }
                    boolean result = ContextElementValueWizardPage.this._typeHolder.isValid(ContextElementValueWizardPage.this._contextElementValueFieldEditor.getStringValue());
                    if (!result) {
                        errorMessage = this.getErrorMessage();
                    }
                } else {
                    errorMessage = Messages.ContextElementValueWizardPage_ErrorMessage_EmtpyValue;
                }
                return errorMessage;
            }
        };
        this._contextElementValueFieldEditor.setValidator((IValidator)valueValidator);
        Text contextElementValue = this._contextElementValueFieldEditor.getTextControl(parent_p);
        ValueChangeHandler handler = this.createValueChangeHandler();
        this.bindTextToAttribute(contextElementValue, ModelPackage.Literals.CONTEXT_ELEMENT__READABLE_VALUE, this.getModelElement(), (UpdateWizardPage)handler);
        this.updateContextElementType(typeHolderClassName_p);
        this._contextElementValueFieldEditor.isValid(true);
    }

    private ValueChangeHandler createValueChangeHandler() {
        ValueChangeHandler handler = new ValueChangeHandler(this){

            protected void doHandleValueChange(ValueChangeEvent event_p) {
                String fullId = (String)event_p.diff.getNewValue();
                ContextElementValueWizardPage.this.setInitialSelectionForProvidedSelectionDialog(fullId);
            }
        };
        return handler;
    }

    private SelectionDialog getProvidedSelectionDialog(Shell parentShell_p) {
        SelectionDialog result = null;
        if (this._typeHolder == null) {
            return result;
        }
        String selectionDialogClassName = this._typeHolder.getSelectionDialog();
        if (selectionDialogClassName != null) {
            Class selectionDialogClass = ClassLoadingHelper.loadClass((String)selectionDialogClassName, (ClassLoader)this.getHostingProjectClassLoader());
            try {
                Constructor constructor = selectionDialogClass.getConstructor(Shell.class);
                result = (SelectionDialog)constructor.newInstance(parentShell_p);
            }
            catch (Exception exception_p) {
                StringBuilder loggerMessage = new StringBuilder("ContextElementValueWizardPage.getProvidedSelectionDialog(..) _ ");
                __logger.error((Object)loggerMessage.toString(), (Throwable)exception_p);
            }
        }
        return result;
    }

    private ISelectionHandler getSelectionHandler() {
        ISelectionHandler result = null;
        if (this._typeHolder == null) {
            return result;
        }
        result = this._typeHolder.getSelectionHandler();
        return result;
    }

    protected ContextElement getContextElement() {
        return (ContextElement)this.getModelElement();
    }

    protected boolean getCompleteStatus() {
        IFieldEditor[] fieldEditors = new IFieldEditor[]{this._contextElementValueFieldEditor};
        return this.handleFieldEditorValidation(fieldEditors);
    }

    protected String getPageTitle() {
        return Messages.ContextElementWizardPage_Title;
    }

    protected String getHelpContextId() {
        return IHelpContextIds.NEW_CONTEXT_ELEMENT_VALUE_WIZARD_PAGE;
    }

    public void updateContextElementType(String typeHolderClassName_p) {
        if (this._contextElementType != null) {
            Object typeInstance;
            boolean typeHolderHasChanged = false;
            if (this._contextElementTypeFieldEditor != null) {
                Text textControl = this._contextElementTypeFieldEditor.getTextControl();
                String currentValue = textControl.getText();
                if (!currentValue.equals(typeHolderClassName_p)) {
                    textControl.setText(typeHolderClassName_p);
                    typeHolderHasChanged = true;
                }
            } else {
                this._contextElementType.setType(typeHolderClassName_p);
                typeHolderHasChanged = true;
            }
            if ((typeHolderHasChanged || this._typeHolder == null) && (typeInstance = ClassLoadingHelper.instantiate((String)typeHolderClassName_p, (ClassLoader)this.getHostingProjectClassLoader())) != null) {
                this._typeHolder = (ITypeHolder)typeInstance;
                this._providedSelectionDialog = this.getProvidedSelectionDialog(this.getShell());
                boolean selectionDialogProvided = this._providedSelectionDialog != null;
                boolean textIsEditable = false;
                if (!this._typeHolder.isJava()) {
                    textIsEditable = !selectionDialogProvided;
                } else {
                    this._contextElementValueFieldEditor.setClassTypeFilter(this.getClassTypeFilter(this._typeHolder));
                }
                this._contextElementValueFieldEditor.getHelperControl().setEnabled(selectionDialogProvided || this._typeHolder.isJava());
                this._contextElementValueFieldEditor.setDialogToOpen(this._providedSelectionDialog);
                if (selectionDialogProvided) {
                    this.setInitialSelectionForProvidedSelectionDialog(this.getContextElement().getReadableValue());
                }
                ISelectionHandler selectionHandler = this.getSelectionHandler();
                this._contextElementValueFieldEditor.setSelectionHandler(selectionHandler);
                Text textValueWidget = (Text)this._contextElementValueFieldEditor.getValueControl();
                textValueWidget.setEditable(textIsEditable);
                if (textIsEditable) {
                    textValueWidget.setFocus();
                } else {
                    this._contextElementValueFieldEditor.getHelperControl().forceFocus();
                }
                if (typeHolderHasChanged) {
                    textValueWidget.setText("");
                }
            }
        }
    }

    private Class<?> getClassTypeFilter(ITypeHolder typeHolder_p) {
        Class result = null;
        if (typeHolder_p.isJava()) {
            ClassTypeHolder classTypeHolder = (ClassTypeHolder)typeHolder_p;
            result = classTypeHolder.getExpectedType();
        }
        return result;
    }

    private void setInitialSelectionForProvidedSelectionDialog(String fullId_p) {
        if (this._providedSelectionDialog == null || fullId_p == null) {
            return;
        }
        Object[] initialSelection = new Object[]{fullId_p};
        this._providedSelectionDialog.setInitialSelections(initialSelection);
    }
}

