/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.ui.viewers.explorer;

import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egf.common.listener.AbstractProjectListener;
import org.eclipse.egf.core.ui.EgfUiActivator;
import org.eclipse.egf.core.ui.data.explorer.FactoryComponentInWorkspace;
import org.eclipse.egf.core.ui.data.explorer.FactoryComponentWorkingSetManager;
import org.eclipse.egf.core.ui.viewers.AbstractAdaptedModelElementContentProvider;
import org.eclipse.egf.model.FactoryComponent;
import org.eclipse.egf.model.NamedModelElementWithId;
import org.eclipse.egf.model.data.helper.ModelHelper;
import org.eclipse.egf.pde.EgfPdeActivator;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.progress.UIJob;

public class FactoryComponentExplorerContentProvider
extends AbstractAdaptedModelElementContentProvider {
    private AbstractProjectListener _projectListener = new ProjectListener();

    public FactoryComponentExplorerContentProvider() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this._projectListener);
    }

    protected AdapterFactory getAdapterFactory() {
        return EgfUiActivator.getDefault().getEditingDomain().getAdapterFactory();
    }

    public void dispose() {
        super.dispose();
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this._projectListener);
    }

    protected FactoryComponentInWorkspace getFactoryComponentInWorkspace() {
        return (FactoryComponentInWorkspace)EgfUiActivator.getDefault().getFactoryComponentInWorkspaceInput();
    }

    protected void addProject(final IProject addedProject_p) {
        UIJob job = new UIJob(""){

            public IStatus runInUIThread(IProgressMonitor monitor_p) {
                FactoryComponentInWorkspace factoryComponentInWorkspace;
                boolean fcIsAdded;
                FactoryComponent factoryComponent;
                if (addedProject_p != null && (factoryComponent = EgfPdeActivator.getDefault().getFactoryComponent(addedProject_p)) != null && (fcIsAdded = (factoryComponentInWorkspace = FactoryComponentExplorerContentProvider.this.getFactoryComponentInWorkspace()).addFactoryComponent(factoryComponent))) {
                    AbstractTreeViewer viewer = FactoryComponentExplorerContentProvider.this.getViewer();
                    Object parent = null;
                    Object input = FactoryComponentExplorerContentProvider.this.getInitialInput();
                    parent = input instanceof FactoryComponentInWorkspace ? input : ((FactoryComponentWorkingSetManager)input).getParent(addedProject_p);
                    viewer.add(parent, (Object)factoryComponent);
                    viewer.setSelection((ISelection)new TreeSelection(new TreePath(new Object[]{parent, factoryComponent})), true);
                }
                return Status.OK_STATUS;
            }
        };
        job.setPriority(20);
        job.setSystem(true);
        job.setRule((ISchedulingRule)addedProject_p);
        job.schedule();
    }

    protected void removeProject(IProject removeProject_p) {
        if (removeProject_p != null) {
            FactoryComponentInWorkspace factoryComponentInWorkspace = this.getFactoryComponentInWorkspace();
            Iterator<FactoryComponent> fcs = factoryComponentInWorkspace.getFactoryComponents().iterator();
            FactoryComponent removedFactoryComponent = null;
            while (fcs.hasNext() && removedFactoryComponent == null) {
                FactoryComponent currentFactoryComponent = fcs.next();
                IProject currentFactoryComponentProject = ModelHelper.getProject((NamedModelElementWithId)currentFactoryComponent);
                if (currentFactoryComponentProject != removeProject_p) continue;
                removedFactoryComponent = currentFactoryComponent;
            }
            if (removedFactoryComponent != null) {
                factoryComponentInWorkspace.removeFactoryComponent(removedFactoryComponent);
                final FactoryComponent uiFactoryComponentToRemove = removedFactoryComponent;
                final AbstractTreeViewer viewer = this.getViewer();
                viewer.getControl().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        viewer.remove((Object)uiFactoryComponentToRemove);
                    }
                });
            }
        }
    }

    class ProjectListener
    extends AbstractProjectListener {
        ProjectListener() {
        }

        protected void handleProjectAdded(IProject project_p, IResourceDelta resourceDelta_p) {
            this.handleProjectChanged(project_p, resourceDelta_p);
        }

        protected void handleProjectChanged(IProject project_p, IResourceDelta resourceDelta_p) {
            IResourceDelta[] projectFilesResourceDelta;
            IResourceDelta[] iResourceDeltaArray = projectFilesResourceDelta = resourceDelta_p.getAffectedChildren();
            int n = projectFilesResourceDelta.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta projectFileResourceDelta = iResourceDeltaArray[n2];
                IResource projectFile = projectFileResourceDelta.getResource();
                if (EgfPdeActivator.getDefault().isPluginFile(projectFile)) {
                    FactoryComponentExplorerContentProvider.this.addProject(project_p);
                    break;
                }
                ++n2;
            }
        }

        protected void handleProjectRemoved(IProject project_p, IResourceDelta resourceDelta_p) {
            FactoryComponentExplorerContentProvider.this.removeProject(project_p);
        }

        protected void handleProjectClosed(IProject project_p, IResourceDelta resourceDelta_p) {
            this.handleProjectRemoved(project_p, resourceDelta_p);
        }
    }
}

