/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egf.common.helper.FileHelper;
import org.eclipse.egf.common.misc.Couple;
import org.eclipse.egf.pde.emf.reader.descriptor.IEmfExtensionDescriptor;
import org.eclipse.emf.codegen.ecore.generator.GeneratorAdapterFactory;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGenerateCodeOperation
extends WorkspaceModifyOperation {
    private String _modelPath;
    private GeneratorAdapterFactory _generatorAdapterFactory;
    private boolean _result;

    protected AbstractGenerateCodeOperation() {
        super(null);
    }

    public boolean getResult() {
        return this._result;
    }

    protected final void execute(IProgressMonitor monitor_p) throws CoreException, InvocationTargetException, InterruptedException {
        this._result = this.doExecute(monitor_p);
    }

    protected abstract boolean doExecute(IProgressMonitor var1) throws CoreException, InvocationTargetException, InterruptedException;

    protected GenModel loadExistingGenModel(IPath modelFileName_p, Collection<IEmfExtensionDescriptor> extensions_p) {
        GenModel result = null;
        URI fileFullUri = FileHelper.getFileFullUri((String)modelFileName_p.toString());
        if (fileFullUri == null) {
            return result;
        }
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.getResource(fileFullUri, true);
        EList contents = resource.getContents();
        if (!contents.isEmpty()) {
            EPackage rootPackage = (EPackage)contents.get(0);
            String nsURI = rootPackage.getNsURI();
            for (IEmfExtensionDescriptor descriptor : extensions_p) {
                Couple generatedPackage = descriptor.getGeneratedPackage();
                if (!nsURI.equals(generatedPackage.getKey())) continue;
                Resource genModelResource = resourceSet.getResource((URI)generatedPackage.getValue(), true);
                EList genModelContents = genModelResource.getContents();
                if (genModelContents.isEmpty()) break;
                result = (GenModel)genModelContents.get(0);
                break;
            }
        }
        return result;
    }

    protected String getModelPath() {
        return this._modelPath;
    }

    public void setModelPath(String modelPath_p) {
        this._modelPath = modelPath_p;
    }

    protected GeneratorAdapterFactory getGeneratorAdapterFactory() {
        return this._generatorAdapterFactory;
    }

    public void setGeneratorAdapterFactory(GeneratorAdapterFactory generatorAdapterFactory_p) {
        this._generatorAdapterFactory = generatorAdapterFactory_p;
    }
}

