/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.egf.model.AbstractViewpoint;
import org.eclipse.egf.model.ModelFactory;
import org.eclipse.egf.model.ModelPackage;
import org.eclipse.egf.model.Specification;
import org.eclipse.egf.model.ViewpointType;
import org.eclipse.egf.model.impl.NamedModelElementWithIdImpl;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpecificationImpl
extends NamedModelElementWithIdImpl
implements Specification {
    private static final Logger __logger = Logger.getLogger((String)SpecificationImpl.class.getPackage().getName());
    protected EList<AbstractViewpoint> viewpoints;
    protected Map<ViewpointType, EList<String>> viewpointIds;

    protected SpecificationImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return ModelPackage.Literals.SPECIFICATION;
    }

    @Override
    public EList<AbstractViewpoint> getViewpoints() {
        if (this.viewpoints == null) {
            this.viewpoints = new EObjectContainmentEList(AbstractViewpoint.class, (InternalEObject)this, 4);
            this.viewpoints.addAll(this.loadViewpoints());
        }
        return this.viewpoints;
    }

    private List<AbstractViewpoint> loadViewpoints() {
        ArrayList<AbstractViewpoint> result = new ArrayList<AbstractViewpoint>(0);
        if (this.viewpointIds != null) {
            for (Map.Entry<ViewpointType, EList<String>> currentEntry : this.viewpointIds.entrySet()) {
                ViewpointType currentType = currentEntry.getKey();
                EList<String> currentViewpointIds = currentEntry.getValue();
                for (String viewpointId : currentViewpointIds) {
                    AbstractViewpoint loadedViewpoint = null;
                    switch (currentType.getValue()) {
                        case 0: {
                            loadedViewpoint = ModelFactory.eINSTANCE.createContract();
                            break;
                        }
                        case 1: {
                            loadedViewpoint = ModelFactory.eINSTANCE.createPatternViewpoint();
                            break;
                        }
                        case 2: {
                            loadedViewpoint = ModelFactory.eINSTANCE.createMappingViewpoint();
                            break;
                        }
                        default: {
                            StringBuilder loggerMessage = new StringBuilder("SpecificationImpl.loadViewpoints(..) _ ");
                            loggerMessage.append("Viewpoint type #: ");
                            loggerMessage.append("unknwown");
                            __logger.error((Object)loggerMessage.toString());
                        }
                    }
                    if (loadedViewpoint == null) continue;
                    loadedViewpoint.setId(viewpointId);
                    result.add(loadedViewpoint);
                }
            }
        }
        return result;
    }

    @Override
    public Map<ViewpointType, EList<String>> getViewpointIds() {
        return this.viewpointIds;
    }

    @Override
    public void setViewpointIds(Map<ViewpointType, EList<String>> newViewpointIds) {
        Map<ViewpointType, EList<String>> oldViewpointIds = this.viewpointIds;
        this.viewpointIds = newViewpointIds;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, oldViewpointIds, this.viewpointIds));
        }
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 4: {
                return ((InternalEList)this.getViewpoints()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 4: {
                return this.getViewpoints();
            }
            case 5: {
                return this.getViewpointIds();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 4: {
                this.getViewpoints().clear();
                this.getViewpoints().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.setViewpointIds((Map)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 4: {
                this.getViewpoints().clear();
                return;
            }
            case 5: {
                this.setViewpointIds(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 4: 
            case 5: {
                return this.viewpointIds != null;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (viewpointIds: ");
        result.append(this.viewpointIds);
        result.append(')');
        return result.toString();
    }
}

