/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.utils;

import java.util.Arrays;
import org.eclipse.egerrit.internal.ui.EGerritUIPlugin;
import org.eclipse.egerrit.internal.ui.table.model.ReviewTableSorter;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class PersistentStorage {
    private static final String VIEW_COLUMN_ORDER = "egerritViewColumnOrder";
    private static final String VIEW_COLUMN_WIDTH = "egerritViewColumnWidth";
    private static final String COLUMN_SELECTION = "egerritSelectColumn";
    private static final String SORT_DIRECTION = "sortDirection";
    private String fStorageSectionName;
    private Viewer fViewer;
    private static final int CURRENT_VERSION = 2;
    private static final String VIEW_VERSION = "egerritVersionColumnStorage";

    public PersistentStorage(Viewer viewer, String storageSectionName) {
        this.fStorageSectionName = storageSectionName;
        this.fViewer = viewer;
    }

    public void storeDialogSettings() {
        int i2;
        if (this.fViewer == null) {
            return;
        }
        Table table = null;
        Tree tree = null;
        ReviewTableSorter comparator = null;
        if (this.fViewer instanceof TableViewer) {
            table = ((TableViewer)this.fViewer).getTable();
            comparator = (ReviewTableSorter)((TableViewer)this.fViewer).getComparator();
        }
        if (this.fViewer instanceof TreeViewer) {
            tree = ((TreeViewer)this.fViewer).getTree();
            comparator = (ReviewTableSorter)((TreeViewer)this.fViewer).getComparator();
        }
        int[] columnOrder = null;
        int[] columnWidth = null;
        if (table != null) {
            columnOrder = table.getColumnOrder();
            int numColumn = table.getColumnCount();
            columnWidth = new int[numColumn];
            i2 = 0;
            while (i2 < numColumn) {
                columnWidth[i2] = table.getColumn(i2).getWidth();
                ++i2;
            }
        } else if (tree != null) {
            columnOrder = tree.getColumnOrder();
            int numColumn = tree.getColumnCount();
            columnWidth = new int[numColumn];
            i2 = 0;
            while (i2 < numColumn) {
                columnWidth[i2] = tree.getColumn(i2).getWidth();
                ++i2;
            }
        }
        if (columnOrder != null) {
            this.getDialogSettings(this.fStorageSectionName).put(VIEW_COLUMN_ORDER, (String[])Arrays.stream(columnOrder).mapToObj(i -> String.valueOf(i)).toArray(String[]::new));
        }
        if (columnWidth != null) {
            this.getDialogSettings(this.fStorageSectionName).put(VIEW_COLUMN_WIDTH, (String[])Arrays.stream(columnWidth).mapToObj(i -> String.valueOf(i)).toArray(String[]::new));
        }
        if (comparator != null) {
            int direction = 0;
            if (table != null) {
                direction = table.getSortDirection();
            } else if (tree != null) {
                direction = tree.getSortDirection();
            }
            this.getDialogSettings(this.fStorageSectionName).put(COLUMN_SELECTION, comparator.getColumnSorter());
            this.getDialogSettings(this.fStorageSectionName).put(SORT_DIRECTION, direction);
        }
        this.getDialogSettings(this.fStorageSectionName).put(VIEW_VERSION, 2);
    }

    public void restoreDialogSettings() {
        if (this.fViewer == null) {
            return;
        }
        if (this.fViewer instanceof TableViewer) {
            this.restoreTableSettings((TableViewer)this.fViewer);
        } else if (this.fViewer instanceof TreeViewer) {
            this.restoreTreeSettings((TreeViewer)this.fViewer);
        }
    }

    private void restoreTableSettings(TableViewer tableViewer) {
        String[] backedUpValue = this.getDialogSettings(this.fStorageSectionName).getArray(VIEW_COLUMN_ORDER);
        if (backedUpValue != null) {
            int[] columnOrder = Arrays.stream(backedUpValue).mapToInt(Integer::parseInt).toArray();
            tableViewer.getTable().setColumnOrder(columnOrder);
        }
        if ((backedUpValue = this.getDialogSettings(this.fStorageSectionName).getArray(VIEW_COLUMN_WIDTH)) != null) {
            int[] columnWidth = Arrays.stream(backedUpValue).mapToInt(Integer::parseInt).toArray();
            int numColumn = tableViewer.getTable().getColumns().length;
            int i = 0;
            while (i < numColumn) {
                tableViewer.getTable().getColumn(i).setWidth(columnWidth[i]);
                ++i;
            }
        }
        int columnSelected = -1;
        try {
            columnSelected = this.getDialogSettings(this.fStorageSectionName).getInt(COLUMN_SELECTION);
        }
        catch (NumberFormatException numberFormatException) {}
        if (columnSelected >= 0) {
            try {
                int direction = this.getDialogSettings(this.fStorageSectionName).getInt(SORT_DIRECTION);
                TableColumn tableColumn = tableViewer.getTable().getColumn(columnSelected);
                tableViewer.getTable().setSortColumn(tableColumn);
                tableViewer.getTable().setSortDirection(direction);
                tableViewer.setComparator((ViewerComparator)new ReviewTableSorter(columnSelected));
            }
            catch (NumberFormatException numberFormatException) {}
            return;
        }
    }

    private void restoreTreeSettings(TreeViewer treeViewer) {
        try {
            if (this.getDialogSettings(this.fStorageSectionName).getInt(VIEW_VERSION) != 2) {
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
        String[] backedUpValue = this.getDialogSettings(this.fStorageSectionName).getArray(VIEW_COLUMN_ORDER);
        if (backedUpValue != null) {
            int[] columnOrder = Arrays.stream(backedUpValue).mapToInt(Integer::parseInt).toArray();
            treeViewer.getTree().setColumnOrder(columnOrder);
        }
        if ((backedUpValue = this.getDialogSettings(this.fStorageSectionName).getArray(VIEW_COLUMN_WIDTH)) != null) {
            int[] columnWidth = Arrays.stream(backedUpValue).mapToInt(Integer::parseInt).toArray();
            int numColumn = treeViewer.getTree().getColumns().length;
            int i = 0;
            while (i < numColumn) {
                treeViewer.getTree().getColumn(i).setWidth(columnWidth[i]);
                ++i;
            }
        }
        int columnSelected = -1;
        try {
            columnSelected = this.getDialogSettings(this.fStorageSectionName).getInt(COLUMN_SELECTION);
        }
        catch (NumberFormatException numberFormatException) {}
        if (columnSelected >= 0) {
            try {
                int direction = this.getDialogSettings(this.fStorageSectionName).getInt(SORT_DIRECTION);
                TreeColumn tableColumn = treeViewer.getTree().getColumn(columnSelected);
                treeViewer.getTree().setSortColumn(tableColumn);
                treeViewer.getTree().setSortDirection(direction);
                treeViewer.setComparator((ViewerComparator)new ReviewTableSorter(columnSelected));
            }
            catch (NumberFormatException numberFormatException) {}
            return;
        }
    }

    public IDialogSettings getDialogSettings(String selectSection) {
        IDialogSettings settings = EGerritUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(selectSection);
        if (section == null) {
            section = settings.addNewSection(selectSection);
        }
        return section;
    }
}

