/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.editors;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.egerrit.internal.core.EGerritCorePlugin;
import org.eclipse.egerrit.internal.core.GerritClient;
import org.eclipse.egerrit.internal.model.FetchInfo;
import org.eclipse.egerrit.internal.model.RevisionInfo;
import org.eclipse.egerrit.internal.ui.utils.GerritToGitMapping;
import org.eclipse.egerrit.internal.ui.utils.Messages;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.internal.CommonUtils;
import org.eclipse.egit.ui.internal.commit.RepositoryCommit;
import org.eclipse.egit.ui.internal.fetch.FetchOperationUI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jgit.errors.AmbiguousObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.RevisionSyntaxException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.services.IServiceLocator;

public class CherryPickRevision
extends Action {
    private static final String EGIT_CHERRY_PICK = "org.eclipse.egit.ui.commit.CherryPick";
    private RevCommit commit;
    private Repository repo;
    private RevisionInfo revision;
    private GerritClient gerritClient;

    public CherryPickRevision(RevisionInfo gerritRevision, GerritClient gerritClient) {
        this.gerritClient = gerritClient;
        this.revision = gerritRevision;
        this.setText(Messages.CherryPickRevision_0);
    }

    public void run() {
        this.repo = this.findLocalRepo(this.gerritClient, this.revision.getChangeInfo().getProject());
        if (this.repo == null) {
            Status status = new Status(4, "org.eclipse.egerrit.core", Messages.CherryPickRevision_1);
            ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.CherryPickRevision_2, (String)Messages.CherryPickRevision_3, (IStatus)status);
            return;
        }
        final URIish remoteURI = this.getRemoteURI();
        WorkspaceJob job = new WorkspaceJob(String.valueOf(Messages.CherryPickRevision_4) + remoteURI.toPrivateString()){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                try {
                    CherryPickRevision.this.fetchChange(monitor);
                }
                catch (IOException | URISyntaxException | CoreException e) {
                    return new Status(4, "org.eclipse.egerrit.ui", String.valueOf(Messages.CherryPickRevision_5) + remoteURI.toPrivateString(), e);
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                if (JobFamilies.FETCH.equals(family)) {
                    return true;
                }
                return super.belongsTo(family);
            }
        };
        job.setUser(true);
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        try {
            Status status;
            if (!job.getResult().isOK()) {
                return;
            }
            this.initializeCommitFromRevision();
            if (this.commit == null) {
                status = new Status(4, "org.eclipse.egerrit.core", Messages.CherryPickRevision_6);
                ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.CherryPickRevision_2, (String)Messages.CherryPickRevision_3, (IStatus)status);
            }
            if (!this.invokeEGitCherryPickCommand()) {
                status = new Status(4, "org.eclipse.egerrit.core", Messages.CherryPickRevision_9);
                ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.CherryPickRevision_2, (String)Messages.CherryPickRevision_3, (IStatus)status);
            }
        }
        catch (IOException | CoreException throwable) {
            Status status = new Status(4, "org.eclipse.egerrit.core", Messages.CherryPickRevision_12);
            ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.CherryPickRevision_2, (String)Messages.CherryPickRevision_3, (IStatus)status);
        }
    }

    private void initializeCommitFromRevision() throws RevisionSyntaxException, AmbiguousObjectException, IncorrectObjectTypeException, IOException, CoreException {
        ObjectId commitId = this.repo.resolve(this.revision.getCommit().getCommit());
        this.commit = null;
        Throwable throwable = null;
        Object var3_4 = null;
        try (RevWalk revWalk = new RevWalk(this.repo);){
            this.commit = revWalk.parseCommit((AnyObjectId)commitId);
            revWalk.dispose();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private String getRef() {
        Map.Entry x = (Map.Entry)this.revision.getFetch().iterator().next();
        return ((FetchInfo)x.getValue()).getRef();
    }

    private boolean invokeEGitCherryPickCommand() {
        StructuredSelection selection = new StructuredSelection((Object)new RepositoryCommit(this.repo, this.commit));
        ICommandService commandService = (ICommandService)CommonUtils.getService((IServiceLocator)PlatformUI.getWorkbench(), ICommandService.class);
        Command cmd = commandService.getCommand(EGIT_CHERRY_PICK);
        if (!cmd.isDefined()) {
            return false;
        }
        IHandlerService handlerService = (IHandlerService)CommonUtils.getService((IServiceLocator)PlatformUI.getWorkbench(), IHandlerService.class);
        EvaluationContext c = null;
        c = new EvaluationContext(handlerService.createContextSnapshot(false), (Object)selection.toList());
        c.addVariable("selection", (Object)selection);
        c.removeVariable("activeMenuSelection");
        try {
            handlerService.executeCommandInContext(new ParameterizedCommand(cmd, null), null, (IEvaluationContext)c);
        }
        catch (ExecutionException | NotEnabledException | NotHandledException | NotDefinedException throwable) {
            return false;
        }
        return true;
    }

    private void fetchChange(IProgressMonitor monitor) throws CoreException, URISyntaxException, IOException {
        RefSpec spec = new RefSpec().setSource(this.getRef()).setDestination("FETCH_HEAD");
        ArrayList<RefSpec> specs = new ArrayList<RefSpec>(1);
        specs.add(spec);
        new FetchOperationUI(this.repo, this.getRemoteURI(), specs, 0, false).execute(monitor);
    }

    private Repository findLocalRepo(GerritClient gerrit, String projectName) {
        GerritToGitMapping gerritToGitMap = null;
        try {
            gerritToGitMap = new GerritToGitMapping(new URIish(gerrit.getRepository().getURIBuilder(false).toString()), projectName);
        }
        catch (URISyntaxException e2) {
            EGerritCorePlugin.logError((String)(String.valueOf(gerrit.getRepository().formatGerritVersion()) + e2.getMessage()));
            return null;
        }
        Repository jgitRepo = null;
        try {
            jgitRepo = gerritToGitMap.find();
        }
        catch (IOException e2) {
            EGerritCorePlugin.logError((String)(String.valueOf(gerrit.getRepository().formatGerritVersion()) + e2.getMessage()));
        }
        return jgitRepo;
    }

    private URIish getRemoteURI() {
        try {
            return new URIish(String.valueOf(this.gerritClient.getRepository().getURIBuilder(false).toString()) + "/" + this.revision.getChangeInfo().getProject());
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    private boolean connectionTypeAvailable(String scheme) {
        return this.revision.getFetch().get((Object)scheme) != null;
    }
}

