/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.compare;

import java.util.function.Supplier;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.egerrit.internal.model.RevisionInfo;
import org.eclipse.egerrit.internal.ui.EGerritImages;
import org.eclipse.egerrit.internal.ui.compare.GerritMultipleInput;
import org.eclipse.egerrit.internal.ui.utils.Messages;
import org.eclipse.egerrit.internal.ui.utils.UIUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.TreeViewer;

public class ReplyAction
extends Action {
    private Supplier<TreeViewer> viewer;
    private GerritMultipleInput compareInput;

    public ReplyAction(GerritMultipleInput input, Supplier<TreeViewer> viewerRef) {
        this.viewer = viewerRef;
        this.compareInput = input;
        this.setText(Messages.ReplyAction_0);
        this.setDescription(Messages.ReplyAction_1);
        this.setImageDescriptor(EGerritImages.getDescriptor("icons/reply.png"));
        String anonymousUserToolTip = String.valueOf(Messages.ReplyAction_2) + input.gerritClient.getRepository().getServerInfo().getServerURI() + Messages.ReplyAction_3;
        if (input.gerritClient.getRepository().getServerInfo().isAnonymous()) {
            this.setToolTipText(anonymousUserToolTip);
            this.setEnabled(false);
        } else {
            this.setToolTipText(Messages.ReplyAction_4);
        }
    }

    public void run() {
        try {
            this.compareInput.saveChanges((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {
            return;
        }
        RevisionInfo revisionInfo = (RevisionInfo)this.compareInput.getChangeInfo().getRevisions().get((Object)this.compareInput.getRightSide());
        UIUtils.replyToChange(this.viewer.get().getControl().getShell(), revisionInfo, null, this.compareInput.gerritClient);
        this.compareInput.fireInputChange();
    }
}

