/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.compare;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareViewerSwitchingPane;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.DiffTreeViewer;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.IBeanValueProperty;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.property.Properties;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.egerrit.internal.model.FileInfo;
import org.eclipse.egerrit.internal.model.ModelPackage;
import org.eclipse.egerrit.internal.model.RevisionInfo;
import org.eclipse.egerrit.internal.ui.compare.GerritDiffNode;
import org.eclipse.egerrit.internal.ui.compare.GerritMultipleInput;
import org.eclipse.egerrit.internal.ui.compare.NextPreviousFileAction;
import org.eclipse.egerrit.internal.ui.compare.ReplyAction;
import org.eclipse.egerrit.internal.ui.compare.ShowCommentedFileAction;
import org.eclipse.egerrit.internal.ui.compare.ShowFilePathAction;
import org.eclipse.egerrit.internal.ui.compare.SwitchPatchAction;
import org.eclipse.egerrit.internal.ui.editors.QueryHelpers;
import org.eclipse.egerrit.internal.ui.table.model.FilesTableModel;
import org.eclipse.egerrit.internal.ui.table.model.ITableModel;
import org.eclipse.egerrit.internal.ui.table.model.ReviewTableSorter;
import org.eclipse.egerrit.internal.ui.table.provider.FileInfoCompareCellLabelProvider;
import org.eclipse.egerrit.internal.ui.utils.Messages;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.databinding.viewers.ObservableListTreeContentProvider;
import org.eclipse.jface.databinding.viewers.TreeStructureAdvisor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompareUpperSection
extends CompareViewerSwitchingPane {
    private static Logger logger = LoggerFactory.getLogger(CompareUpperSection.class);
    GerritMultipleInput compareInput;
    DiffTreeViewer viewer;
    Label leftPatch;
    Label rightPatch;

    public CompareUpperSection(Composite parent, int style, boolean visibility, CompareEditorInput cei) {
        super(parent, style, visibility);
        this.compareInput = (GerritMultipleInput)cei;
        this.leftPatch.setText(this.resolveShortName(this.compareInput.getLeftSide()));
        this.rightPatch.setText(this.resolveShortName(this.compareInput.getRightSide()));
        this.createViewer((Composite)this);
    }

    private String resolveShortName(String toResolve) {
        RevisionInfo match = (RevisionInfo)this.compareInput.getChangeInfo().getRevisions().get((Object)toResolve);
        if (match != null) {
            return String.valueOf(Messages.CompareUpperSection_PatchSet) + match.get_number();
        }
        return toResolve;
    }

    private CompareConfiguration getCompareConfiguration() {
        return this.compareInput.getCompareConfiguration();
    }

    protected Viewer getViewer(Viewer oldViewer, Object input) {
        this.viewer.setInput(input);
        this.revealFile();
        return this.viewer;
    }

    public void setInput(Object input) {
        super.setInput(input);
        this.viewer.setInput(input);
        this.revealFile();
    }

    private void revealFile() {
        if (this.compareInput.nodeToReveal != null) {
            StructuredSelection selection = new StructuredSelection((Object)this.compareInput.nodeToReveal);
            this.viewer.setSelection((ISelection)selection, true);
            this.callFeed1(selection);
        } else {
            this.callFeed1(null);
        }
    }

    private void callFeed1(StructuredSelection nodeToReveal) {
        Class<CompareEditorInput> clazz = CompareEditorInput.class;
        try {
            Method feed1Method = clazz.getDeclaredMethod("feed1", ISelection.class);
            feed1Method.setAccessible(true);
            feed1Method.invoke((Object)this.compareInput, nodeToReveal);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            logger.debug("Exception revealing the element selected by the user", (Object)nodeToReveal);
        }
    }

    private void createViewer(Composite parent) {
        this.viewer = new DiffTreeViewer(new Tree(parent, 65536), this.getCompareConfiguration()){

            protected void createToolItems(ToolBarManager toolbarManager) {
                toolbarManager.appendToGroup("navigation", (IAction)new NextPreviousFileAction(1, CompareUpperSection.this.compareInput));
                toolbarManager.appendToGroup("navigation", (IAction)new NextPreviousFileAction(2, CompareUpperSection.this.compareInput));
                toolbarManager.appendToGroup("modes", (IAction)new ShowFilePathAction(() -> CompareUpperSection.this.viewer));
                toolbarManager.appendToGroup("modes", (IAction)new ShowCommentedFileAction(() -> CompareUpperSection.this.viewer));
                toolbarManager.appendToGroup("merge", (IAction)new ReplyAction(CompareUpperSection.this.compareInput, () -> CompareUpperSection.this.viewer));
            }
        };
        ObservableListTreeContentProvider cp = new ObservableListTreeContentProvider((IObservableFactory)new TreeFactoryImpl(), (TreeStructureAdvisor)new TreeStructureAdvisorImpl());
        this.viewer.setContentProvider((IContentProvider)cp);
        FilesTableModel[] tableInfo = FilesTableModel.values();
        int size = tableInfo.length;
        int index = 0;
        while (index < size) {
            this.createTreeViewerColumn(tableInfo[index]);
            ++index;
        }
        this.viewer.getTree().setHeaderVisible(true);
        this.viewer.getTree().setLinesVisible(true);
        if (!this.compareInput.gerritClient.getRepository().getServerInfo().isAnonymous()) {
            this.viewer.getTree().addMouseListener((MouseListener)this.toggleReviewedStateListener());
        }
        ReviewTableSorter.bind((TreeViewer)this.viewer);
        this.viewer.setComparator((ViewerComparator)new ReviewTableSorter(2));
        IBeanValueProperty fileInfo = PojoProperties.value((String)"fileInfo");
        IValueProperty reviewedFlag = fileInfo.value((IValueProperty)EMFProperties.value((EStructuralFeature)ModelPackage.Literals.FILE_INFO__REVIEWED));
        IValueProperty comments = fileInfo.value((IValueProperty)EMFProperties.value((EStructuralFeature)ModelPackage.Literals.FILE_INFO__COMMENTS_COUNT));
        IValueProperty draftComments = fileInfo.value((IValueProperty)EMFProperties.value((EStructuralFeature)ModelPackage.Literals.FILE_INFO__DRAFTS_COUNT));
        IObservableMap[] watchedProperties = Properties.observeEach((IObservableSet)cp.getKnownElements(), (IValueProperty[])new IValueProperty[]{reviewedFlag, comments, draftComments});
        this.viewer.setLabelProvider((IBaseLabelProvider)new FileInfoCompareCellLabelProvider(watchedProperties));
    }

    private void fillMenuItemForChangeInfo(MenuManager menu, Label labelToUpdate, boolean side) {
        ArrayList revisions = new ArrayList(this.compareInput.getChangeInfo().getRevisions().values());
        revisions.sort((o1, o2) -> o2.get_number() - o1.get_number());
        revisions.stream().forEach(rev -> menu.add((IAction)new SwitchPatchAction(this.compareInput, (RevisionInfo)rev, labelToUpdate, side)));
    }

    protected Control createTopLeft(Composite p) {
        final Composite composite = new Composite(p, 0){

            public Point computeSize(int wHint, int hHint, boolean changed) {
                return super.computeSize(wHint, Math.max(24, hHint), changed);
            }
        };
        composite.setLayout((Layout)new GridLayout(5, false));
        this.leftPatch = new Label(composite, 0x1004000);
        GridData gridData = new GridData(16384, 0x1000000, false, false);
        gridData.widthHint = 90;
        this.leftPatch.setLayoutData((Object)gridData);
        Button leftPatchSelector = new Button(composite, 1028);
        GridData gridDataLeftPathSelector = new GridData(16384, 0x1000000, false, false);
        gridDataLeftPathSelector.heightHint = 20;
        gridDataLeftPathSelector.widthHint = 20;
        leftPatchSelector.setLayoutData((Object)gridDataLeftPathSelector);
        leftPatchSelector.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MenuManager mgr = new MenuManager();
                CompareUpperSection.this.fillMenuItemForChangeInfo(mgr, CompareUpperSection.this.leftPatch, true);
                mgr.add((IAction)new SwitchPatchAction(CompareUpperSection.this.compareInput, "WORKSPACE", CompareUpperSection.this.leftPatch, true));
                mgr.add((IAction)new SwitchPatchAction(CompareUpperSection.this.compareInput, "BASE", CompareUpperSection.this.leftPatch, true));
                mgr.createContextMenu((Control)composite).setVisible(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label separator = new Label(composite, 0x1000000);
        separator.setText("  /  ");
        this.rightPatch = new Label(composite, 0);
        GridData rightPatchData = new GridData(16384, 0x1000000, false, false);
        rightPatchData.widthHint = 90;
        this.rightPatch.setLayoutData((Object)rightPatchData);
        Button rightPatchSelector = new Button(composite, 1028);
        GridData gridDataRightPatchSelector = new GridData(16384, 0x1000000, false, false);
        gridDataRightPatchSelector.heightHint = 20;
        gridDataRightPatchSelector.widthHint = 20;
        rightPatchSelector.setLayoutData((Object)gridDataRightPatchSelector);
        rightPatchSelector.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MenuManager mgr = new MenuManager();
                CompareUpperSection.this.fillMenuItemForChangeInfo(mgr, CompareUpperSection.this.rightPatch, false);
                mgr.add((IAction)new SwitchPatchAction(CompareUpperSection.this.compareInput, "WORKSPACE", CompareUpperSection.this.rightPatch, false));
                mgr.createContextMenu((Control)composite).setVisible(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return composite;
    }

    protected boolean inputChanged(Object input) {
        return this.getInput() != input;
    }

    public void setText(String label) {
    }

    public void setImage(Image image) {
        Control[] children;
        Composite c = (Composite)this.getTopLeft();
        Control[] controlArray = children = c.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control element = controlArray[n2];
            if (element instanceof CLabel) {
                CLabel cl = (CLabel)element;
                if (cl != null && !cl.isDisposed()) {
                    cl.setImage(image);
                }
                return;
            }
            ++n2;
        }
    }

    public void addMouseListener(MouseListener listener) {
        Control[] children;
        Composite c = (Composite)this.getTopLeft();
        Control[] controlArray = children = c.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control element = controlArray[n2];
            if (element instanceof CLabel) {
                CLabel cl = (CLabel)element;
                cl.addMouseListener(listener);
            }
            ++n2;
        }
    }

    private MouseAdapter toggleReviewedStateListener() {
        return new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ISelection selection;
                ViewerCell viewerCell = CompareUpperSection.this.viewer.getCell(new Point(e.x, e.y));
                if (viewerCell != null && viewerCell.getColumnIndex() == 0 && (selection = CompareUpperSection.this.viewer.getSelection()) instanceof IStructuredSelection) {
                    IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                    Object element = structuredSelection.getFirstElement();
                    FileInfo fileInfo = ((GerritDiffNode)((Object)element)).getFileInfo();
                    CompareUpperSection.this.toggleReviewed(fileInfo);
                }
            }
        };
    }

    private void toggleReviewed(FileInfo fileInfo) {
        if (fileInfo.isReviewed()) {
            QueryHelpers.markAsNotReviewed(this.compareInput.gerritClient, fileInfo);
        } else {
            QueryHelpers.markAsReviewed(this.compareInput.gerritClient, fileInfo);
        }
    }

    private TreeViewerColumn createTreeViewerColumn(ITableModel tableInfo) {
        TreeViewerColumn treeColumViewer = new TreeViewerColumn((TreeViewer)this.viewer, 0);
        TreeColumn column = treeColumViewer.getColumn();
        column.setText(tableInfo.getName());
        column.setWidth(tableInfo.getWidth());
        column.setAlignment(tableInfo.getAlignment());
        column.setResizable(tableInfo.getResize());
        column.setMoveable(tableInfo.getMoveable());
        return treeColumViewer;
    }

    private static class TreeFactoryImpl
    implements IObservableFactory {
        private TreeFactoryImpl() {
        }

        public IObservableList createObservable(Object target) {
            return BeanProperties.list((String)"children").observe(target);
        }
    }

    private static class TreeStructureAdvisorImpl
    extends TreeStructureAdvisor {
        private TreeStructureAdvisorImpl() {
        }

        public Object getParent(Object element) {
            if (element instanceof DiffNode) {
                return ((DiffNode)element).getParent();
            }
            return null;
        }

        public Boolean hasChildren(Object element) {
            if (element instanceof DiffNode && ((DiffNode)element).getChildren().length > 0) {
                return Boolean.TRUE;
            }
            return super.hasChildren(element);
        }
    }
}

