/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.compare;

import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.egerrit.internal.core.GerritClient;
import org.eclipse.egerrit.internal.core.command.GetContentFromCommitCommand;
import org.eclipse.egerrit.internal.core.exception.EGerritException;
import org.eclipse.egerrit.internal.model.CommentInfo;
import org.eclipse.egerrit.internal.model.FileInfo;
import org.eclipse.egerrit.internal.ui.compare.CommentableCompareItem;
import org.eclipse.egerrit.internal.ui.compare.GerritCompareHelper;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CommitCompareItem
extends CommentableCompareItem
implements IStreamContentAccessor,
ITypedElement {
    private static Logger logger = LoggerFactory.getLogger(CommitCompareItem.class);
    private final String projectId;
    private final String commitId;
    private static final String PARENT = "PARENT";

    CommitCompareItem(GerritClient gerrit, String projectId, String commitId, FileInfo fileInfo) {
        super(PARENT);
        this.gerrit = gerrit;
        this.projectId = projectId;
        this.commitId = commitId;
        this.fileInfo = fileInfo;
    }

    public String getName() {
        return "Base: " + GerritCompareHelper.extractFilename(this.getOldPathOrPath()) + ' ' + '(' + GerritCompareHelper.shortenCommitId(this.commitId) + ')';
    }

    private String getOldPathOrPath() {
        if (this.fileInfo.getOld_path() == null) {
            return this.fileInfo.getPath();
        }
        return this.fileInfo.getOld_path();
    }

    @Override
    protected byte[] loadFileContent() {
        GetContentFromCommitCommand getContent = this.gerrit.getContentFromCommit(this.projectId, this.commitId, this.getOldPathOrPath());
        try {
            return Base64.decodeBase64((String)((String)getContent.call()));
        }
        catch (EGerritException e) {
            logger.debug("Exception retrieving commitId", (Throwable)e);
            return new byte[0];
        }
    }

    @Override
    protected EList<CommentInfo> filterComments(EList<CommentInfo> eList) {
        return (EList)eList.stream().filter(comment -> PARENT.equals(comment.getSide())).collect(Collectors.toCollection(BasicEList::new));
    }
}

