/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.rrobot.impl.generators;

import com.google.common.base.Objects;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.fx.ide.rrobot.model.bundle.BundlePackage;
import org.eclipse.fx.ide.rrobot.model.bundle.BundleProject;
import org.eclipse.fx.ide.rrobot.model.bundle.ComponentDefinitionFile;
import org.eclipse.fx.ide.rrobot.model.bundle.ExportedPackage;
import org.eclipse.fx.ide.rrobot.model.bundle.ImportedPackage;
import org.eclipse.fx.ide.rrobot.model.bundle.ManifestFile;
import org.eclipse.fx.ide.rrobot.model.bundle.PluginXMLFile;
import org.eclipse.fx.ide.rrobot.model.bundle.RequiredBundle;
import org.eclipse.fx.ide.rrobot.model.task.BooleanExpression;
import org.eclipse.fx.ide.rrobot.model.task.ExcludeableElementMixin;
import org.eclipse.fx.ide.rrobot.model.task.Folder;
import org.eclipse.fx.ide.rrobot.model.task.Generator;
import org.eclipse.fx.ide.rrobot.model.task.Resource;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class BundleManifestGenerator
implements Generator<ManifestFile> {
    public InputStream generate(ManifestFile file, Map<String, Object> data) {
        byte[] _bytes = this.generateContent(file, data).toString().getBytes();
        return new ByteArrayInputStream(_bytes);
    }

    public CharSequence generateContent(ManifestFile file, final Map<String, Object> data) {
        boolean _isEmpty_3;
        boolean _not_3;
        boolean _isEmpty_2;
        boolean _not_2;
        boolean _isEmpty_1;
        boolean _not_1;
        boolean _not;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Manifest-Version: 1.0");
        _builder.newLine();
        _builder.append("Bundle-ManifestVersion: 2");
        _builder.newLine();
        _builder.append("Bundle-Name: ");
        String _bundlename = file.getBundlename();
        _builder.append(_bundlename);
        _builder.newLineIfNotEmpty();
        _builder.append("Bundle-SymbolicName: ");
        String _symbolicname = file.getSymbolicname();
        _builder.append(_symbolicname);
        EObject _eContainer = file.eContainer();
        PluginXMLFile _pluginxml = ((BundleProject)_eContainer).getPluginxml();
        boolean bl = _notEquals = !Objects.equal((Object)_pluginxml, null);
        if (_notEquals) {
            _builder.append("; singleton:=true");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("Bundle-Version: ");
        String _version = file.getVersion();
        _builder.append(_version);
        _builder.newLineIfNotEmpty();
        _builder.append("Bundle-RequiredExecutionEnvironment: ");
        String _executionEnvironment = file.getExecutionEnvironment();
        _builder.append(_executionEnvironment);
        _builder.newLineIfNotEmpty();
        _builder.append("Bundle-ActivationPolicy: lazy");
        _builder.newLine();
        boolean _isEmpty = file.getRequiredBundles().isEmpty();
        boolean bl2 = _not = !_isEmpty;
        if (_not) {
            _builder.append("Require-Bundle: ");
            Functions.Function1<RequiredBundle, Boolean> _function = new Functions.Function1<RequiredBundle, Boolean>(){

                public Boolean apply(RequiredBundle e) {
                    return BundleManifestGenerator.this.excludeExpression((ExcludeableElementMixin)e, data);
                }
            };
            Functions.Function1<RequiredBundle, String> _function_1 = new Functions.Function1<RequiredBundle, String>(){

                public String apply(RequiredBundle it) {
                    return BundleManifestGenerator.this.requireBundleBuilder(it);
                }
            };
            String _join = IterableExtensions.join((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)file.getRequiredBundles(), (Functions.Function1)_function), (Functions.Function1)_function_1), (CharSequence)",\r\n ");
            _builder.append(_join);
            _builder.newLineIfNotEmpty();
        }
        boolean bl3 = _not_1 = !(_isEmpty_1 = file.getImportedPackages().isEmpty());
        if (_not_1) {
            _builder.append("Import-Package: ");
            Functions.Function1<ImportedPackage, Boolean> _function_2 = new Functions.Function1<ImportedPackage, Boolean>(){

                public Boolean apply(ImportedPackage e) {
                    return BundleManifestGenerator.this.excludeExpression((ExcludeableElementMixin)e, data);
                }
            };
            Functions.Function1<ImportedPackage, String> _function_3 = new Functions.Function1<ImportedPackage, String>(){

                public String apply(ImportedPackage it) {
                    return BundleManifestGenerator.this.importPackageBuilder(it);
                }
            };
            String _join_1 = IterableExtensions.join((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)file.getImportedPackages(), (Functions.Function1)_function_2), (Functions.Function1)_function_3), (CharSequence)",\r\n ");
            _builder.append(_join_1);
            _builder.newLineIfNotEmpty();
        }
        boolean bl4 = _not_2 = !(_isEmpty_2 = file.getExportedPackages().isEmpty());
        if (_not_2) {
            _builder.append("Export-Package: ");
            Functions.Function1<ExportedPackage, Boolean> _function_4 = new Functions.Function1<ExportedPackage, Boolean>(){

                public Boolean apply(ExportedPackage e) {
                    return BundleManifestGenerator.this.excludeExpression((ExcludeableElementMixin)e, data);
                }
            };
            Functions.Function1<ExportedPackage, String> _function_5 = new Functions.Function1<ExportedPackage, String>(){

                public String apply(ExportedPackage it) {
                    return BundleManifestGenerator.this.exportPackageBuilder(it);
                }
            };
            String _join_2 = IterableExtensions.join((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)file.getExportedPackages(), (Functions.Function1)_function_4), (Functions.Function1)_function_5), (CharSequence)",\r\n ");
            _builder.append(_join_2);
            _builder.newLineIfNotEmpty();
        }
        boolean bl5 = _not_3 = !(_isEmpty_3 = this.serviceComponents(file).isEmpty());
        if (_not_3) {
            _builder.append("Service-Component: ");
            String _join_3 = IterableExtensions.join(this.serviceComponents(file), (CharSequence)",\r\n ");
            _builder.append(_join_3);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public boolean excludeExpression(ExcludeableElementMixin mixin, Map<String, Object> data) {
        boolean _notEquals;
        BooleanExpression _excludeExpression = mixin.getExcludeExpression();
        boolean bl = _notEquals = !Objects.equal((Object)_excludeExpression, null);
        if (_notEquals) {
            boolean _execute = mixin.getExcludeExpression().execute(data);
            return !_execute;
        }
        return true;
    }

    public ArrayList<String> serviceComponents(ManifestFile file) {
        final ArrayList<String> rv = new ArrayList<String>();
        EObject _eContainer = file.eContainer();
        BundleProject project = (BundleProject)_eContainer;
        Consumer<Resource> _function = new Consumer<Resource>(){

            @Override
            public void accept(Resource r) {
                BundleManifestGenerator.this.collect(rv, "", r);
            }
        };
        project.getResources().forEach((Consumer)_function);
        return rv;
    }

    public Boolean collect(List<String> files, String prefix, Resource r) {
        boolean _xifexpression = false;
        if (r instanceof ComponentDefinitionFile) {
            String _name = ((ComponentDefinitionFile)r).getName();
            String _plus = String.valueOf(prefix) + _name;
            _xifexpression = files.add(_plus);
        } else if (r instanceof Folder) {
            Folder f = (Folder)r;
            EList _children = f.getChildren();
            for (Resource c : _children) {
                String _name_1 = ((Folder)r).getName();
                String _plus_1 = String.valueOf(prefix) + _name_1;
                String _plus_2 = String.valueOf(_plus_1) + "/";
                this.collect(files, _plus_2, c);
            }
        }
        return _xifexpression;
    }

    public String exportPackageBuilder(ExportedPackage e) {
        String rv = e.getName();
        boolean _eIsSet = e.eIsSet((EStructuralFeature)BundlePackage.Literals.EXPORTED_PACKAGE__VERSION);
        if (_eIsSet) {
            Object _eGet = e.eGet((EStructuralFeature)BundlePackage.Literals.EXPORTED_PACKAGE__VERSION);
            String _plus = ";version=\"" + _eGet;
            String _plus_1 = String.valueOf(_plus) + "\"";
            rv = rv.concat(_plus_1);
        }
        return rv;
    }

    public String importPackageBuilder(ImportedPackage i) {
        String rv = i.getName();
        if (i.eIsSet((EStructuralFeature)BundlePackage.Literals.IMPORTED_PACKAGE__MIN_VERSION) || i.eIsSet((EStructuralFeature)BundlePackage.Literals.IMPORTED_PACKAGE__MAX_VERSION)) {
            boolean _not;
            rv = rv.concat(";version=\"");
            boolean _eIsSet = i.eIsSet((EStructuralFeature)BundlePackage.Literals.IMPORTED_PACKAGE__MAX_VERSION);
            boolean bl = _not = !_eIsSet;
            if (_not) {
                rv = rv.concat(i.eGet((EStructuralFeature)BundlePackage.Literals.IMPORTED_PACKAGE__MIN_VERSION).toString());
            } else {
                boolean _isMinExclusive = i.isMinExclusive();
                rv = _isMinExclusive ? rv.concat("(") : rv.concat("[");
                rv = rv.concat(i.eGet((EStructuralFeature)BundlePackage.Literals.IMPORTED_PACKAGE__MIN_VERSION).toString());
                boolean _isMaxExclusive = i.isMaxExclusive();
                rv = _isMaxExclusive ? rv.concat(")") : rv.concat("]");
            }
            rv = rv.concat("\"");
        }
        return rv;
    }

    public String requireBundleBuilder(RequiredBundle r) {
        String rv = r.getName();
        if (r.eIsSet((EStructuralFeature)BundlePackage.Literals.REQUIRED_BUNDLE__MIN_VERSION) || r.eIsSet((EStructuralFeature)BundlePackage.Literals.REQUIRED_BUNDLE__MAX_VERSION)) {
            boolean _not;
            rv = rv.concat("bundle-version=\"");
            boolean _eIsSet = r.eIsSet((EStructuralFeature)BundlePackage.Literals.REQUIRED_BUNDLE__MAX_VERSION);
            boolean bl = _not = !_eIsSet;
            if (_not) {
                rv = rv.concat(r.eGet((EStructuralFeature)BundlePackage.Literals.REQUIRED_BUNDLE__MIN_VERSION).toString());
            } else {
                boolean _isMinExclusive = r.isMinExclusive();
                rv = _isMinExclusive ? rv.concat("(") : rv.concat("[");
                rv = rv.concat(r.eGet((EStructuralFeature)BundlePackage.Literals.REQUIRED_BUNDLE__MIN_VERSION).toString());
                boolean _isMaxExclusive = r.isMaxExclusive();
                rv = _isMaxExclusive ? rv.concat(")") : rv.concat("]");
            }
            rv = rv.concat("\"");
        }
        return rv;
    }
}

