/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.jdt.ui.internal.editors;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ObservablesManager;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public abstract class AddDialog<T extends EObject>
extends TitleAreaDialog {
    protected final DataBindingContext dbContext = new DataBindingContext();
    private final ObservablesManager mgr = new ObservablesManager();
    protected static final int DELAY = 500;

    public AddDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(final Composite parent) {
        final AtomicReference c = new AtomicReference();
        this.mgr.runAndCollect(new Runnable(){

            @Override
            public void run() {
                c.set(AddDialog.this.createDialogContent(parent));
            }
        });
        return (Control)c.get();
    }

    protected void okPressed() {
        IStatus status = this.validate();
        if (status.isOK()) {
            Command cmd = this.generateOkCommand();
            if (cmd.canExecute()) {
                cmd.execute();
                this.dbContext.updateModels();
                this.doCleanUp();
                super.okPressed();
            }
        } else if (status.isMultiStatus()) {
            StringBuffer errors = new StringBuffer();
            IStatus[] iStatusArray = ((MultiStatus)status).getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus s = iStatusArray[n2];
                errors.append(s.getMessage()).append("\n");
                ++n2;
            }
            this.setErrorMessage(errors.toString());
        } else {
            this.setErrorMessage(status.getMessage());
        }
    }

    protected void cancelPressed() {
        this.doCleanUp();
        super.cancelPressed();
    }

    private void doCleanUp() {
        this.mgr.dispose();
        this.dbContext.dispose();
    }

    protected abstract Command generateOkCommand();

    protected abstract IStatus validate();

    protected abstract Control createDialogContent(Composite var1);

    protected abstract T getObject();
}

