/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.tabpane;

import java.util.function.Consumer;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.control.TabPane;
import org.eclipse.fx.ui.controls.tabpane.DndTabPaneFactory;
import org.eclipse.fx.ui.controls.tabpane.skin.DnDTabPaneSkinHookerFullDrag;
import org.eclipse.fx.ui.controls.tabpane.skin.DndTabPaneSkinHooker;
import org.eclipse.jdt.annotation.Nullable;

public class DndTabPane
extends TabPane {
    private static final DndTabPaneFactory.FeedbackType DEFAULT_FEEDBACK_TYPE = DndTabPaneFactory.FeedbackType.MARKER;
    private @Nullable BooleanProperty allowDetach;
    private @Nullable ObjectProperty<DndTabPaneFactory.FeedbackType> feedbackType;
    private DndTabPaneFactory.DragSetup setup;

    public DndTabPane() {
        this(DEFAULT_FEEDBACK_TYPE, false);
    }

    public DndTabPane(DndTabPaneFactory.FeedbackType feedbackType, boolean allowDetach) {
        this.setFeedbackType(feedbackType);
        this.setAllowDetach(allowDetach);
        this.initListeners(setup -> DndTabPaneFactory.setup(() -> this.feedbackTypeProperty().get(), (Node)this, (ObservableList<Node>)this.getChildren(), setup, null));
    }

    public DndTabPane(boolean allowDetach, Consumer<DndTabPaneFactory.DragSetup> setup) {
        this(DEFAULT_FEEDBACK_TYPE, allowDetach, setup);
    }

    public DndTabPane(DndTabPaneFactory.FeedbackType feedbackType, boolean allowDetach, Consumer<DndTabPaneFactory.DragSetup> setup) {
        this.setFeedbackType(feedbackType);
        this.setAllowDetach(allowDetach);
        this.initListeners(setup);
    }

    private void initListeners(Consumer<DndTabPaneFactory.DragSetup> setup) {
        this.skinProperty().addListener((observable, oldValue, newValue) -> {
            if (oldValue != null && this.setup != null) {
                DndTabPaneFactory.teardown(this.setup);
            }
            if (newValue != null) {
                this.setupDnd((Skin<?>)newValue, setup);
            }
        });
        this.allowDetachProperty().addListener((observable, oldValue, newValue) -> {
            Skin skin;
            if (newValue != null && (skin = this.getSkin()) != null) {
                if (this.setup != null) {
                    DndTabPaneFactory.teardown(this.setup);
                }
                this.setupDnd(skin, setup);
            }
        });
    }

    private void setupDnd(Skin<?> skin, Consumer<DndTabPaneFactory.DragSetup> setup) {
        this.setup = this.isAllowDetach() ? new DnDTabPaneSkinHookerFullDrag((Skin<TabPane>)((SkinBase)skin)) : new DndTabPaneSkinHooker(skin);
        setup.accept(this.setup);
    }

    public BooleanProperty allowDetachProperty() {
        if (this.allowDetach == null) {
            this.allowDetach = new SimpleBooleanProperty((Object)this, "allowDetach");
        }
        return this.allowDetach;
    }

    public boolean isAllowDetach() {
        return this.allowDetach != null ? this.allowDetach.get() : false;
    }

    public void setAllowDetach(boolean allowDetach) {
        this.allowDetachProperty().set(allowDetach);
    }

    public ObjectProperty<DndTabPaneFactory.FeedbackType> feedbackTypeProperty() {
        if (this.feedbackType == null) {
            this.feedbackType = new SimpleObjectProperty((Object)this, "feedbackType", (Object)DEFAULT_FEEDBACK_TYPE);
        }
        return this.feedbackType;
    }

    public DndTabPaneFactory.FeedbackType getFeedbackType() {
        return this.feedbackType != null ? (DndTabPaneFactory.FeedbackType)((Object)this.feedbackType.get()) : DEFAULT_FEEDBACK_TYPE;
    }

    public void setFeedbackType(DndTabPaneFactory.FeedbackType feedbackType) {
        this.feedbackTypeProperty().set((Object)feedbackType);
    }
}

