/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.filesystem.skin;

import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.time.temporal.TemporalAccessor;
import java.util.ResourceBundle;
import javafx.beans.Observable;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import org.eclipse.fx.ui.controls.filesystem.DirItem;
import org.eclipse.fx.ui.controls.filesystem.FileItem;
import org.eclipse.fx.ui.controls.filesystem.ResourceItem;
import org.eclipse.fx.ui.controls.filesystem.ResourcePreview;
import org.eclipse.fx.ui.panes.GridLayoutPane;

public class ResourcePreviewSkin
extends SkinBase<ResourcePreview> {
    private Label nameProperty;
    private StackPane preview;
    private Label size;
    private Label lastModified;
    private GridLayoutPane fileProperties;
    private VBox box = new VBox();
    private Label imageSizeValue;
    private Label imageSizeLabel;

    public ResourcePreviewSkin(ResourcePreview control) {
        super((Control)control);
        this.box.setVisible(false);
        this.box.setPadding(new Insets(10.0));
        this.preview = new StackPane();
        VBox.setVgrow((Node)this.preview, (Priority)Priority.ALWAYS);
        this.box.getChildren().add((Object)this.preview);
        this.nameProperty = new Label();
        this.nameProperty.getStyleClass().addAll((Object[])new String[]{"preview", "resourceName"});
        this.nameProperty.setPrefWidth(Double.MAX_VALUE);
        this.nameProperty.setAlignment(Pos.CENTER);
        this.box.getChildren().add((Object)this.nameProperty);
        this.fileProperties = new GridLayoutPane();
        this.fileProperties.setNumColumns(2);
        ResourceBundle b = ResourceBundle.getBundle("org.eclipse.fx.ui.controls.filesystem.skin.resource");
        Label l = new Label(b.getString("ResourcePreviewSkin_Size"));
        l.getStyleClass().addAll((Object[])new String[]{"preview", "resourcePropertyLabel"});
        this.fileProperties.getChildren().add((Object)l);
        this.size = new Label();
        this.fileProperties.getChildren().add((Object)this.size);
        l = new Label(b.getString("ResourcePreviewSkin_Lastmodified"));
        l.getStyleClass().addAll((Object[])new String[]{"preview", "resourcePropertyLabel"});
        this.fileProperties.getChildren().add((Object)l);
        this.lastModified = new Label();
        this.fileProperties.getChildren().add((Object)this.lastModified);
        this.imageSizeLabel = new Label(b.getString("ResourcePreviewSkin_Imagesize"));
        this.imageSizeLabel.getStyleClass().addAll((Object[])new String[]{"preview", "resourcePropertyLabel"});
        this.fileProperties.getChildren().add((Object)this.imageSizeLabel);
        this.imageSizeValue = new Label();
        this.fileProperties.getChildren().add((Object)this.imageSizeValue);
        this.box.getChildren().add((Object)this.fileProperties);
        control.itemProperty().addListener(this::handleItemChanged);
        this.getChildren().add((Object)this.box);
        this.handleItemChanged((Observable)control.itemProperty());
    }

    private void handleItemChanged(Observable o) {
        ResourceItem item = ((ResourcePreview)this.getSkinnable()).getItem();
        this.imageSizeValue.textProperty().unbind();
        this.fileProperties.getChildren().removeAll((Object[])new Node[]{this.imageSizeLabel, this.imageSizeValue});
        if (item != null) {
            this.box.setVisible(true);
            this.nameProperty.setText(item.getName());
            ImageView v = new ImageView(){

                public double minHeight(double width) {
                    return 48.0;
                }

                public double minWidth(double height) {
                    return 48.0;
                }
            };
            v.setPreserveRatio(true);
            v.fitWidthProperty().bind((ObservableValue)this.preview.widthProperty());
            if (item instanceof DirItem) {
                v.getStyleClass().add((Object)"folderBig");
                this.size.setText("--");
            } else {
                if (item.getName().endsWith(".png") || item.getName().endsWith(".jpg") || item.getName().endsWith(".gif")) {
                    Image value = new Image(item.getUri(), true);
                    v.setImage(value);
                    this.imageSizeValue.textProperty().bind((ObservableValue)value.widthProperty().asString("%.0f").concat((Object)" x ").concat((Object)value.heightProperty().asString("%.0f")));
                    this.fileProperties.getChildren().addAll((Object[])new Node[]{this.imageSizeLabel, this.imageSizeValue});
                } else {
                    v.getStyleClass().add((Object)"fileBig");
                }
                this.size.setText(((FileItem)item).getFormattedSize());
            }
            this.lastModified.setText(DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT).format((TemporalAccessor)item.lastModifiedProperty().get()));
            this.preview.getChildren().setAll((Object[])new Node[]{v});
        } else {
            this.box.setVisible(false);
            this.preview.getChildren().clear();
            this.nameProperty.setText(null);
        }
    }
}

